/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.wrapper;

import java.util.List;
import org.dynjs.parser.Statement;
import org.dynjs.parser.ast.FunctionDeclaration;
import org.dynjs.parser.ast.VariableDeclaration;
import org.dynjs.runtime.AbstractFunction;
import org.dynjs.runtime.BasicBlock;
import org.dynjs.runtime.BasicBlockDelegate;
import org.dynjs.runtime.Completion;
import org.dynjs.runtime.DynObject;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.LexicalEnvironment;
import org.dynjs.runtime.PropertyDescriptor;
import org.dynjs.runtime.Types;
import org.dynjs.runtime.interp.InterpretedBasicBlock;

public class JavascriptFunction
extends AbstractFunction {
    private BasicBlock code;

    public JavascriptFunction(String identifier, BasicBlock code, LexicalEnvironment scope, boolean strict, String ... formalParameters) {
        super(scope, strict, formalParameters);
        this.code = code;
        DynObject proto = new DynObject(scope.getGlobalObject());
        PropertyDescriptor constructorDesc = new PropertyDescriptor();
        constructorDesc.set((byte)0, this);
        constructorDesc.set((byte)3, true);
        constructorDesc.set((byte)5, false);
        constructorDesc.set((byte)4, true);
        proto.defineOwnProperty(null, "constructor", constructorDesc, false);
        PropertyDescriptor prototypeDesc = new PropertyDescriptor();
        prototypeDesc.set((byte)0, proto);
        prototypeDesc.set((byte)3, true);
        prototypeDesc.set((byte)5, false);
        prototypeDesc.set((byte)4, false);
        this.defineOwnProperty(null, "prototype", prototypeDesc, false);
        PropertyDescriptor nameDesc = new PropertyDescriptor();
        nameDesc.set((byte)0, identifier);
        nameDesc.set((byte)3, true);
        nameDesc.set((byte)5, false);
        nameDesc.set((byte)4, true);
        this.defineOwnProperty(null, "name", nameDesc, false);
    }

    @Override
    public String getFileName() {
        return this.code.getFileName();
    }

    @Override
    public Object call(ExecutionContext context) {
        Completion result = this.code.call(context);
        if (result.type == Completion.Type.RETURN) {
            if (result.value == null) {
                return Types.UNDEFINED;
            }
            return result.value;
        }
        return Types.UNDEFINED;
    }

    @Override
    public List<FunctionDeclaration> getFunctionDeclarations() {
        return this.code.getFunctionDeclarations();
    }

    @Override
    public List<VariableDeclaration> getVariableDeclarations() {
        return this.code.getVariableDeclarations();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("function(");
        String[] params = this.getFormalParameters();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(params[i]);
        }
        buffer.append("){\n");
        Statement statement = null;
        if (this.code instanceof BasicBlockDelegate && ((BasicBlockDelegate)this.code).getDelegate() instanceof InterpretedBasicBlock) {
            statement = ((InterpretedBasicBlock)((BasicBlockDelegate)this.code).getDelegate()).getBody();
        } else if (this.code instanceof InterpretedBasicBlock) {
            statement = ((InterpretedBasicBlock)this.code).getBody();
        }
        if (statement != null) {
            buffer.append(statement.toIndentedString("  "));
        }
        buffer.append("}");
        return buffer.toString();
    }
}

