/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.ErrorMessages;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.NumberAssert;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteAssert
extends GenericAssert<ByteAssert, Byte>
implements NumberAssert {
    private static final byte ZERO = 0;

    @VisibleForTesting
    ByteAssert(int actual) {
        this((byte)actual);
    }

    protected ByteAssert(byte actual) {
        super(ByteAssert.class, actual);
    }

    protected ByteAssert(Byte actual) {
        super(ByteAssert.class, actual);
    }

    @Override
    public ByteAssert isEqualTo(byte expected) {
        return (ByteAssert)this.isEqualTo(Byte.valueOf(expected));
    }

    @Override
    public ByteAssert isNotEqualTo(byte other) {
        return (ByteAssert)this.isNotEqualTo(Byte.valueOf(other));
    }

    public ByteAssert isGreaterThan(byte other) {
        if ((Byte)this.actual > other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, other));
    }

    public ByteAssert isLessThan(byte other) {
        if ((Byte)this.actual < other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, other));
    }

    public ByteAssert isGreaterThanOrEqualTo(byte other) {
        if ((Byte)this.actual >= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, other));
    }

    public ByteAssert isLessThanOrEqualTo(byte other) {
        if ((Byte)this.actual <= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, other));
    }

    @Override
    public ByteAssert isZero() {
        return this.isEqualTo((byte)0);
    }

    @Override
    public ByteAssert isPositive() {
        return this.isGreaterThan((byte)0);
    }

    @Override
    public ByteAssert isNegative() {
        return this.isLessThan((byte)0);
    }
}

