/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Formatting;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.NumberAssert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatAssert
extends GenericAssert<FloatAssert, Float>
implements NumberAssert {
    private static final float ZERO = 0.0f;

    protected FloatAssert(float actual) {
        super(FloatAssert.class, Float.valueOf(actual));
    }

    protected FloatAssert(Float actual) {
        super(FloatAssert.class, actual);
    }

    @Override
    public FloatAssert isEqualTo(float expected) {
        return (FloatAssert)this.isEqualTo(Float.valueOf(expected));
    }

    @Deprecated
    public FloatAssert isEqualTo(float expected, Delta delta) {
        return this.isEqualTo(expected, delta.value);
    }

    public FloatAssert isEqualTo(float expected, org.fest.assertions.Delta delta) {
        return this.isEqualTo(expected, delta.floatValue());
    }

    private FloatAssert isEqualTo(float expected, float deltaValue) {
        return this.isEqualTo(Float.valueOf(expected), deltaValue);
    }

    public FloatAssert isEqualTo(Float expected, org.fest.assertions.Delta delta) {
        return this.isEqualTo(expected, delta.floatValue());
    }

    private FloatAssert isEqualTo(Float expected, float deltaValue) {
        if (this.actual == null || expected == null) {
            return (FloatAssert)this.isEqualTo(expected);
        }
        if (((Float)this.actual).compareTo(expected) == 0) {
            return this;
        }
        if (Math.abs(expected.floatValue() - ((Float)this.actual).floatValue()) <= deltaValue) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected) + Formatting.format(" using delta:<%s>", Float.valueOf(deltaValue)));
    }

    @Override
    public FloatAssert isNotEqualTo(float other) {
        if (this.compareTo(other) != 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, Float.valueOf(other)));
    }

    public FloatAssert isGreaterThan(float other) {
        if (this.compareTo(other) > 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, Float.valueOf(other)));
    }

    public FloatAssert isLessThan(float other) {
        if (this.compareTo(other) < 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, Float.valueOf(other)));
    }

    public FloatAssert isGreaterThanOrEqualTo(float other) {
        if (this.compareTo(other) >= 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, Float.valueOf(other)));
    }

    public FloatAssert isLessThanOrEqualTo(float other) {
        if (this.compareTo(other) <= 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, Float.valueOf(other)));
    }

    private int compareTo(float other) {
        return Float.compare(((Float)this.actual).floatValue(), other);
    }

    public FloatAssert isNaN() {
        return this.isEqualTo(Float.NaN);
    }

    @Override
    public FloatAssert isZero() {
        return this.isEqualTo(0.0f);
    }

    @Override
    public FloatAssert isPositive() {
        return this.isGreaterThan(0.0f);
    }

    @Override
    public FloatAssert isNegative() {
        return this.isLessThan(0.0f);
    }

    @Deprecated
    public static Delta delta(float d) {
        return new Delta(d);
    }

    @Deprecated
    public static class Delta {
        final float value;

        private Delta(float value) {
            this.value = value;
        }
    }
}

