/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Collection;
import org.fest.assertions.Assert;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Fail;
import org.fest.assertions.Formatting;
import org.fest.util.Collections;
import org.fest.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericAssert<S, A>
extends Assert {
    protected final A actual;
    protected final S myself;

    protected GenericAssert(Class<S> selfType, A actual) {
        this.actual = actual;
        this.myself = selfType.cast(this);
    }

    public final void isNull() {
        Fail.failIfNotNull(this.customErrorMessage(), this.rawDescription(), this.actual);
    }

    public final S satisfies(Condition<A> condition) {
        if (this.matches(condition)) {
            return this.myself;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(this.errorMessageIfConditionNotSatisfied(condition));
    }

    private String errorMessageIfConditionNotSatisfied(Condition<A> condition) {
        return condition.addDescriptionTo(Formatting.format("actual value:<%s> should satisfy condition", this.actual));
    }

    public final S doesNotSatisfy(Condition<A> condition) {
        if (!this.matches(condition)) {
            return this.myself;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(this.errorMessageIfConditionSatisfied(condition));
    }

    private String errorMessageIfConditionSatisfied(Condition<A> condition) {
        return condition.addDescriptionTo(Formatting.format("actual value:<%s> should not satisfy condition", this.actual));
    }

    public final S is(Condition<A> condition) {
        if (this.matches(condition)) {
            return this.myself;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(this.errorMessageIfIsNot(condition));
    }

    private String errorMessageIfIsNot(Condition<A> condition) {
        return condition.addDescriptionTo(Formatting.format("actual value:<%s> should be", this.actual));
    }

    public final S isNot(Condition<A> condition) {
        if (!this.matches(condition)) {
            return this.myself;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(this.errorMessageIfIs(condition));
    }

    private boolean matches(Condition<A> condition) {
        this.validateIsNotNull(condition);
        return condition.matches(this.actual);
    }

    private void validateIsNotNull(Condition<A> condition) {
        if (condition == null) {
            throw new NullPointerException("Condition to check should not be null");
        }
    }

    private String errorMessageIfIs(Condition<A> condition) {
        return condition.addDescriptionTo(Formatting.format("actual value:<%s> should not be", this.actual));
    }

    public S as(String description) {
        this.description(description);
        return this.myself;
    }

    public S describedAs(String description) {
        return this.as(description);
    }

    public S as(Description description) {
        this.description(description);
        return this.myself;
    }

    public S describedAs(Description description) {
        return this.as(description);
    }

    public S isEqualTo(A expected) {
        Fail.failIfNotEqual(this.customErrorMessage(), this.rawDescription(), this.actual, expected);
        return this.myself;
    }

    public S isNotEqualTo(A other) {
        Fail.failIfEqual(this.customErrorMessage(), this.rawDescription(), this.actual, other);
        return this.myself;
    }

    public final S isNotNull() {
        Fail.failIfActualIsNull(this.customErrorMessage(), this.rawDescription(), this.actual);
        return this.myself;
    }

    public final S isSameAs(A expected) {
        Fail.failIfNotSame(this.customErrorMessage(), this.rawDescription(), this.actual, expected);
        return this.myself;
    }

    public final S isNotSameAs(A other) {
        Fail.failIfSame(this.customErrorMessage(), this.rawDescription(), this.actual, other);
        return this.myself;
    }

    public final S isIn(Object ... values) {
        return this.isIn(Collections.list(values));
    }

    public final S isIn(Collection<?> values) {
        if (values == null) {
            throw new NullPointerException(this.formattedErrorMessage("expecting values parameter not to be null"));
        }
        if (this.isActualIn(values)) {
            return this.myself;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotIn(this.customErrorMessage(), this.actual, values));
    }

    public final S isNotIn(Object ... values) {
        return this.isNotIn(Collections.list(values));
    }

    public final S isNotIn(Collection<?> values) {
        if (values == null) {
            throw new NullPointerException(this.formattedErrorMessage("expecting values parameter not to be null"));
        }
        if (!this.isActualIn(values)) {
            return this.myself;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedIn(this.customErrorMessage(), this.actual, values));
    }

    private boolean isActualIn(Collection<?> values) {
        if (values.isEmpty()) {
            return false;
        }
        for (Object value : values) {
            if (!Objects.areEqual(this.actual, value)) continue;
            return true;
        }
        return false;
    }

    public S overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this.myself;
    }
}

