/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.fest.assertions.GroupAssert;
import org.fest.util.Strings;
import org.fest.util.ToString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapAssert
extends GroupAssert<MapAssert, Map<?, ?>> {
    private static final String ENTRY = "entry";
    private static final String ENTRIES = "entries";

    protected MapAssert(Map<?, ?> actual) {
        super(MapAssert.class, actual);
    }

    public MapAssert includes(Entry ... entries) {
        this.isNotNull();
        this.validate(ENTRIES, entries);
        ArrayList<Entry> notFound = new ArrayList<Entry>();
        for (Entry e : entries) {
            if (this.containsEntry(e)) continue;
            notFound.add(e);
        }
        if (!notFound.isEmpty()) {
            this.failIfNotFound(this.entryOrEntries(notFound), notFound);
        }
        return this;
    }

    public MapAssert excludes(Entry ... entries) {
        this.isNotNull();
        this.validate(ENTRIES, entries);
        ArrayList<Entry> found = new ArrayList<Entry>();
        for (Entry e : entries) {
            if (!this.containsEntry(e)) continue;
            found.add(e);
        }
        if (!found.isEmpty()) {
            this.failIfFound(this.entryOrEntries(found), found);
        }
        return this;
    }

    private boolean containsEntry(Entry e) {
        if (e == null) {
            throw new NullPointerException(this.formattedErrorMessage("Entries to check should not contain null"));
        }
        if (!((Map)this.actual).containsKey(e.key)) {
            return false;
        }
        return ((Map)this.actual).get(e.key).equals(e.value);
    }

    private String entryOrEntries(List<Entry> found) {
        return found.size() == 1 ? ENTRY : ENTRIES;
    }

    public static Entry entry(Object key, Object value) {
        return new Entry(key, value);
    }

    private void failIfNotFound(String description, Collection<?> notFound) {
        this.failIfCustomMessageIsSet();
        this.fail(String.format("the map:<%s> does not contain the %s:<%s>", this.formattedActual(), description, ToString.toStringOf(notFound)));
    }

    private void validate(String description, Object[] objects) {
        if (objects == null) {
            throw new NullPointerException(this.formattedErrorMessage(String.format("The given array of %s should not be null", description)));
        }
    }

    private void failIfFound(String description, Collection<?> found) {
        this.failIfCustomMessageIsSet();
        this.fail(String.format("the map:<%s> contains the %s:<%s>", this.formattedActual(), description, ToString.toStringOf(found)));
    }

    private String formattedActual() {
        return ToString.toStringOf(this.actual);
    }

    @Override
    protected int actualGroupSize() {
        this.isNotNull();
        return ((Map)this.actual).size();
    }

    public static class Entry {
        final Object key;
        final Object value;

        Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return String.format("%s=%s", Strings.quote(this.key), Strings.quote(this.value));
        }
    }
}

