/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fest.assertions.JavaBeanDescriptor;
import org.fest.util.Collections;
import org.fest.util.Introspection;
import org.fest.util.IntrospectionError;
import org.fest.util.Strings;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PropertySupport {
    private static final String SEPARATOR = ".";
    private static final PropertySupport INSTANCE = new PropertySupport();
    private final JavaBeanDescriptor javaBeanDescriptor;

    static PropertySupport instance() {
        return INSTANCE;
    }

    private PropertySupport() {
        this(new JavaBeanDescriptor());
    }

    PropertySupport(JavaBeanDescriptor javaBeanDescriptor) {
        this.javaBeanDescriptor = javaBeanDescriptor;
    }

    List<Object> propertyValues(String propertyName, Collection<?> target) {
        if (Collections.isEmpty(target) || Collections.hasOnlyNullElements(target)) {
            return java.util.Collections.emptyList();
        }
        Collection<?> nonNullElements = Collections.nonNullElements(target);
        if (this.isNestedProperty(propertyName)) {
            String firstProperty = this.firstPropertyIfNested(propertyName);
            List<Object> firstPropertyValues = this.propertyValues(firstProperty, nonNullElements);
            return this.propertyValues(this.removeFirstPropertyIfNested(propertyName), firstPropertyValues);
        }
        return this.simplePropertyValues(propertyName, nonNullElements);
    }

    private List<Object> simplePropertyValues(String propertyName, Collection<?> target) {
        ArrayList<Object> propertyValues = new ArrayList<Object>();
        for (Object e : target) {
            propertyValues.add(this.propertyValue(propertyName, e));
        }
        return propertyValues;
    }

    boolean isNestedProperty(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("The property name to verify should not be null");
        }
        return propertyName.contains(SEPARATOR) && !propertyName.startsWith(SEPARATOR) && !propertyName.endsWith(SEPARATOR);
    }

    String removeFirstPropertyIfNested(String propertyName) {
        if (!this.isNestedProperty(propertyName)) {
            return "";
        }
        return propertyName.substring(propertyName.indexOf(SEPARATOR) + 1);
    }

    String firstPropertyIfNested(String propertyName) {
        if (!this.isNestedProperty(propertyName)) {
            return propertyName;
        }
        return propertyName.substring(0, propertyName.indexOf(SEPARATOR));
    }

    private Object propertyValue(String propertyName, Object target) {
        PropertyDescriptor descriptor = Introspection.descriptorForProperty(propertyName, target);
        return this.propertyValue(descriptor, propertyName, target);
    }

    @VisibleForTesting
    Object propertyValue(PropertyDescriptor descriptor, String propertyName, Object target) {
        try {
            return this.javaBeanDescriptor.invokeReadMethod(descriptor, target);
        }
        catch (Exception e) {
            throw new IntrospectionError("Unable to obtain the value in property " + Strings.quote(propertyName), e);
        }
    }
}

