/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl;

import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.cl.OptionProperty;
import org.jboss.aesh.cl.ParsedOption;
import org.jboss.aesh.cl.exception.OptionParserException;

public class CommandLine {
    private List<ParsedOption> options = new ArrayList<ParsedOption>();
    private List<String> arguments = new ArrayList<String>();

    public void addOption(ParsedOption option) throws OptionParserException {
        ParsedOption existingOption = this.getOption(option.getName());
        if (existingOption == null) {
            this.options.add(option);
        } else {
            if (existingOption.getProperties() == null || existingOption.getProperties().size() == 0 || option.getProperties() == null || existingOption.getProperties().size() == 0) {
                throw new OptionParserException("Not allowed to specify the same option (" + option.getDisplayName() + ") twice");
            }
            existingOption.getProperties().addAll(option.getProperties());
        }
    }

    protected List<ParsedOption> getOptions() {
        return this.options;
    }

    public void addArgument(String arg) {
        this.arguments.add(arg);
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public boolean hasOption(char name) {
        return this.hasOption(String.valueOf(name));
    }

    private ParsedOption getOption(String name) {
        for (ParsedOption po : this.options) {
            if ((po.getName() == null || !po.getName().equals(name)) && (po.getLongName() == null || !po.getLongName().equals(name))) continue;
            return po;
        }
        return null;
    }

    public boolean hasOption(String name) {
        for (ParsedOption po : this.options) {
            if (!po.getName().equals(name) && !po.getLongName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String getOptionValue(char c) {
        return this.getOptionValue(String.valueOf(c));
    }

    public String getOptionValue(String name) {
        return this.getOptionValue(name, null);
    }

    public String getOptionValue(String name, String fallback) {
        for (ParsedOption po : this.options) {
            if ((po.getName() == null || !po.getName().equals(name)) && (po.getLongName() == null || !po.getLongName().equals(name))) continue;
            return po.getValue();
        }
        return fallback;
    }

    public List<String> getOptionValues(char c) {
        return this.getOptionValues(String.valueOf(c), new ArrayList<String>());
    }

    public List<String> getOptionValues(String name) {
        return this.getOptionValues(name, new ArrayList<String>());
    }

    public List<String> getOptionValues(String name, List<String> fallback) {
        for (ParsedOption po : this.options) {
            if ((po.getName() == null || !po.getName().equals(name)) && (po.getLongName() == null || !po.getLongName().equals(name))) continue;
            return po.getValues();
        }
        return fallback;
    }

    public List<OptionProperty> getOptionProperties(String name) {
        for (ParsedOption po : this.options) {
            if ((po.getName() == null || !po.getName().equals(name)) && (po.getLongName() == null || !po.getLongName().equals(name))) continue;
            return po.getProperties();
        }
        return new ArrayList<OptionProperty>();
    }
}

