/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.aesh.cl.exception.OptionParserException;
import org.jboss.aesh.cl.internal.OptionInt;
import org.jboss.aesh.console.Config;

public class ParameterInt {
    private String name;
    private String usage;
    private Class<?> argumentType;
    private List<OptionInt> options;

    public ParameterInt(String name, String usage) {
        this.setName(name);
        this.setUsage(usage);
        this.options = new ArrayList<OptionInt>();
    }

    public ParameterInt(String name, String usage, Class<?> argumentType) {
        this.setName(name);
        this.setUsage(usage);
        this.setArgumentType(argumentType);
        this.options = new ArrayList<OptionInt>();
    }

    public ParameterInt(String name, String usage, Class<?> argumentType, OptionInt[] options) throws OptionParserException {
        this.setName(name);
        this.setUsage(usage);
        this.setArgumentType(argumentType);
        this.options = new ArrayList<OptionInt>();
        this.setOptions(Arrays.asList(options));
    }

    public ParameterInt(String name, String usage, Class<?> argumentType, List<OptionInt> options) throws OptionParserException {
        this.setName(name);
        this.setUsage(usage);
        this.setArgumentType(argumentType);
        this.options = new ArrayList<OptionInt>();
        this.setOptions(options);
    }

    public List<OptionInt> getOptions() {
        return this.options;
    }

    public void addOption(OptionInt opt) throws OptionParserException {
        this.options.add(new OptionInt(this.verifyThatNamesAreUnique(opt.getName(), opt.getLongName()), opt.getLongName(), opt.getDescription(), opt.hasValue(), opt.getArgument(), opt.isRequired(), opt.getValueSeparator(), opt.isProperty(), opt.hasMultipleValues(), opt.getType()));
    }

    public void addOption(char name, String longName, String description, boolean hasValue, String argument, boolean required, char valueSeparator, boolean isProperty, boolean hasMultipleValues, Class<?> type) throws OptionParserException {
        this.options.add(new OptionInt(this.verifyThatNamesAreUnique(name, longName), longName, description, hasValue, argument, required, valueSeparator, isProperty, hasMultipleValues, type));
    }

    public void addOption(char name, String longName, String description, boolean hasValue, String argument, boolean required, boolean hasMultipleValues, Class<?> type) throws OptionParserException {
        this.options.add(new OptionInt(this.verifyThatNamesAreUnique(name, longName), longName, description, hasValue, argument, required, '\u0000', false, hasMultipleValues, type));
    }

    public void addOption(char name, String longName, String description, boolean hasValue) throws OptionParserException {
        this.addOption(this.verifyThatNamesAreUnique(name, longName), longName, description, hasValue, null, false, false, null);
    }

    private void setOptions(List<OptionInt> options) throws OptionParserException {
        for (OptionInt opt : options) {
            this.options.add(new OptionInt(this.verifyThatNamesAreUnique(opt.getName(), opt.getLongName()), opt.getLongName(), opt.getDescription(), opt.hasValue(), opt.getArgument(), opt.isRequired(), opt.getValueSeparator(), opt.isProperty(), opt.hasMultipleValues(), opt.getType()));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public Class<?> getArgumentType() {
        return this.argumentType;
    }

    public void setArgumentType(Class<?> argumentType) {
        this.argumentType = argumentType;
    }

    private char verifyThatNamesAreUnique(String name, String longName) throws OptionParserException {
        return this.verifyThatNamesAreUnique(name.charAt(0), longName);
    }

    private char verifyThatNamesAreUnique(char name, String longName) throws OptionParserException {
        if (longName != null && longName.length() > 0 && this.findLongOption(longName) != null) {
            throw new OptionParserException("Option --" + longName + " is already added to Param: " + this.toString());
        }
        if (name != '\u0000' && this.findOption(String.valueOf(name)) != null) {
            throw new OptionParserException("Option -" + name + " is already added to Param: " + this.toString());
        }
        if (name == '\u0000') {
            if (longName != null && longName.length() > 0) {
                return this.findPossibleName(longName);
            }
            throw new OptionParserException("Neither option name and option long name can be both null");
        }
        return name;
    }

    private char findPossibleName(String longName) throws OptionParserException {
        for (int i = 0; i < longName.length(); ++i) {
            if (this.findOption(String.valueOf(longName.charAt(i))) != null) continue;
            return longName.charAt(i);
        }
        throw new OptionParserException("All option names are taken, please specify a unique name");
    }

    public OptionInt findOption(String name) {
        for (OptionInt option : this.options) {
            if (option.getName() == null || !option.getName().equals(name)) continue;
            return option;
        }
        return null;
    }

    public OptionInt findLongOption(String name) {
        for (OptionInt option : this.options) {
            if (option.getLongName() == null || !option.getLongName().equals(name)) continue;
            return option;
        }
        return null;
    }

    public OptionInt startWithOption(String name) {
        for (OptionInt option : this.options) {
            if (!name.startsWith(option.getName())) continue;
            return option;
        }
        return null;
    }

    public OptionInt startWithLongOption(String name) {
        for (OptionInt option : this.options) {
            if (!name.startsWith(option.getLongName())) continue;
            return option;
        }
        return null;
    }

    public void clean() {
        for (OptionInt optionInt : this.options) {
            optionInt.clean();
        }
    }

    public List<String> getOptionLongNamesWithDash() {
        ArrayList<String> names = new ArrayList<String>(this.options.size());
        for (OptionInt o : this.options) {
            names.add("--" + o.getLongName());
        }
        return names;
    }

    public List<String> findPossibleLongNamesWitdDash(String name) {
        ArrayList<String> names = new ArrayList<String>(this.options.size());
        for (OptionInt o : this.options) {
            if (!o.getName().equals(name) && !o.getLongName().startsWith(name)) continue;
            names.add("--" + o.getLongName());
        }
        return names;
    }

    public String printHelp() {
        int maxLength = 0;
        int width = 80;
        for (OptionInt o : this.getOptions()) {
            if (o.getFormattedLength() <= maxLength) continue;
            maxLength = o.getFormattedLength();
        }
        StringBuilder sb = new StringBuilder();
        for (OptionInt o : this.getOptions()) {
            sb.append(o.getFormattedOption(2, maxLength + 4, width)).append(Config.getLineSeparator());
        }
        return "Usage: " + this.getName() + " " + this.getUsage() + Config.getLineSeparator() + sb.toString();
    }

    public String toString() {
        return "ParameterInt{name='" + this.name + '\'' + ", usage='" + this.usage + '\'' + ", argumentType=" + this.argumentType + ", options=" + this.options + '}';
    }
}

