/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jboss.aesh.edit.KeyOperation;

public class KeyOperationManager {
    private List<KeyOperation> operations = new ArrayList<KeyOperation>();

    public List<KeyOperation> getOperations() {
        return this.operations;
    }

    public void clear() {
        this.operations.clear();
    }

    public void addOperations(List<KeyOperation> newOperations) {
        for (KeyOperation ko : newOperations) {
            this.checkAndRemove(ko);
            this.operations.add(ko);
        }
    }

    public void addOperation(KeyOperation operation) {
        this.checkAndRemove(operation);
        this.operations.add(operation);
    }

    private boolean exists(KeyOperation operation) {
        for (KeyOperation ko : this.operations) {
            if (!Arrays.equals(ko.getKeyValues(), operation.getKeyValues())) continue;
            return true;
        }
        return false;
    }

    private void checkAndRemove(KeyOperation ko) {
        Iterator<KeyOperation> iter = this.operations.iterator();
        while (iter.hasNext()) {
            KeyOperation operation = iter.next();
            if (!Arrays.equals(operation.getKeyValues(), ko.getKeyValues()) || !operation.getWorkingMode().equals((Object)ko.getWorkingMode())) continue;
            iter.remove();
            return;
        }
    }

    public KeyOperation findOperation(int[] input) {
        for (KeyOperation operation : this.operations) {
            if (!operation.getKey().equalTo(input)) continue;
            return operation;
        }
        return null;
    }
}

