/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.history;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.history.InMemoryHistory;

public class FileHistory
extends InMemoryHistory {
    private String historyFile;

    public FileHistory(String fileName, int maxSize) throws IOException {
        super(maxSize);
        this.historyFile = fileName;
        this.readFile();
    }

    private void readFile() throws IOException {
        if (new File(this.historyFile).exists()) {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(this.historyFile));
            while ((line = reader.readLine()) != null) {
                this.push(line);
            }
            reader.close();
        }
    }

    private void writeFile() throws IOException {
        new File(this.historyFile).delete();
        FileWriter fw = new FileWriter(this.historyFile);
        for (int i = 0; i < this.size(); ++i) {
            fw.write(this.get(i) + Config.getLineSeparator());
        }
        fw.flush();
        fw.close();
    }

    @Override
    public void stop() {
        try {
            this.writeFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

