/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal;

import org.jboss.aesh.terminal.CharacterType;
import org.jboss.aesh.terminal.Color;
import org.jboss.aesh.util.ANSI;

public class TerminalString {
    private String characters;
    private Color backgroundColor;
    private Color textColor;
    private CharacterType type;

    public TerminalString(String chars, Color backgroundColor, Color textColor, CharacterType type) {
        this.characters = chars;
        this.type = type;
        this.backgroundColor = backgroundColor;
        this.textColor = textColor;
    }

    public TerminalString(String chars, Color backgroundColor, Color textColor) {
        this(chars, backgroundColor, textColor, CharacterType.NORMAL);
    }

    public TerminalString(String chars, CharacterType type) {
        this(chars, Color.DEFAULT_BG, Color.DEFAULT_TEXT, type);
    }

    public TerminalString(String chars) {
        this(chars, Color.DEFAULT_BG, Color.DEFAULT_TEXT, CharacterType.NORMAL);
    }

    public String getCharacters() {
        return this.characters;
    }

    public CharacterType getType() {
        return this.type;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public String getAsString(TerminalString prev) {
        if (this.equalsIgnoreCharacter(prev)) {
            return this.characters;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(ANSI.getStart());
        builder.append(this.type.getValueComparedToPrev(prev.getType()));
        if (this.getTextColor() != prev.getTextColor() || prev.getType() == CharacterType.INVERT) {
            builder.append(';').append(this.getTextColor().getValue());
        }
        if (this.getBackgroundColor() != prev.getBackgroundColor() || prev.getType() == CharacterType.INVERT) {
            builder.append(';').append(this.getBackgroundColor().getValue());
        }
        builder.append('m');
        builder.append(this.getCharacters());
        return builder.toString();
    }

    public String getAsString() {
        StringBuilder builder = new StringBuilder();
        builder.append(ANSI.getStart());
        builder.append(this.type.getValue()).append(';');
        builder.append(this.getTextColor().getValue()).append(';');
        builder.append(this.getBackgroundColor().getValue());
        builder.append('m');
        builder.append(this.getCharacters());
        return builder.toString();
    }

    public boolean equalsIgnoreCharacter(TerminalString that) {
        if (this.type != that.type) {
            return false;
        }
        if (this.backgroundColor != that.backgroundColor) {
            return false;
        }
        return this.textColor == that.textColor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TerminalString)) {
            return false;
        }
        TerminalString that = (TerminalString)o;
        if (this.backgroundColor != that.backgroundColor) {
            return false;
        }
        if (!this.characters.equals(that.characters)) {
            return false;
        }
        if (this.textColor != that.textColor) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.characters.hashCode();
        result = 31 * result + this.backgroundColor.hashCode();
        result = 31 * result + this.textColor.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return "TerminalString{characters='" + this.characters + '\'' + ", backgroundColor=" + (Object)((Object)this.backgroundColor) + ", textColor=" + (Object)((Object)this.textColor) + ", type=" + (Object)((Object)this.type) + '}';
    }
}

