/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.rephract.mop;

import com.headius.invokebinder.Binder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import org.projectodd.rephract.LinkLogger;
import org.projectodd.rephract.Operation;
import org.projectodd.rephract.StrategicLink;
import org.projectodd.rephract.StrategyChain;
import org.projectodd.rephract.guards.Guards;
import org.projectodd.rephract.mop.BaseMetaObjectProtocolLinkStrategy;

public abstract class ContextualLinkStrategy<T>
extends BaseMetaObjectProtocolLinkStrategy {
    private Class<T> runtimeContextClass;

    public ContextualLinkStrategy(Class<T> runtimeContextClass) {
        this.runtimeContextClass = runtimeContextClass;
    }

    public ContextualLinkStrategy(Class<T> runtimeContextClass, LinkLogger logger) {
        super(logger);
        this.runtimeContextClass = runtimeContextClass;
    }

    public Class<T> getRuntimeContextClass() {
        return this.runtimeContextClass;
    }

    public T acquireContext(Object candidateContext) {
        if (candidateContext != null && this.runtimeContextClass.isAssignableFrom(candidateContext.getClass())) {
            return (T)candidateContext;
        }
        return null;
    }

    protected MethodHandle contextAcquisitionFilter() throws NoSuchMethodException, IllegalAccessException {
        if (this.runtimeContextClass == null) {
            return MethodHandles.identity(Object.class);
        }
        return Binder.from(Object.class, this.getClass(), Object.class).invokeVirtual(MethodHandles.lookup(), "acquireContext").bindTo(this);
    }

    @Override
    protected StrategicLink linkGetProperty(StrategyChain chain, Operation op) throws NoSuchMethodException, IllegalAccessException {
        Object receiver = chain.getRequest().receiver();
        Binder binder = Binder.from(chain.getRequest().type());
        Binder guardBinder = Binder.from(chain.getRequest().type().changeReturnType(Boolean.TYPE));
        Object[] args = chain.getRequest().arguments();
        String propName = op.getParameter();
        if (args.length == 1) {
            binder = this.insertContext(binder);
            binder = this.insertName(binder, propName);
            guardBinder = this.insertContext(guardBinder);
            guardBinder = this.insertName(guardBinder, propName);
        } else if (args.length == 2) {
            if (propName == null) {
                propName = (String)args[1];
                binder = this.insertContext(binder);
                guardBinder = this.insertContext(guardBinder);
            } else {
                binder = this.insertName(binder, propName);
                guardBinder = this.insertName(guardBinder, propName);
            }
        } else if (args.length == 3) {
            propName = (String)args[2];
            binder = this.filterContext(binder);
            guardBinder = this.filterContext(guardBinder);
        }
        binder = binder.convert(Object.class, Object.class, this.getRuntimeContextClass(), String.class);
        guardBinder = guardBinder.convert(Boolean.TYPE, Object.class, this.getRuntimeContextClass(), String.class);
        this.log("[GET_PROPERTY] receiver=%s; propName=%s", receiver, propName);
        return this.linkGetProperty(chain, receiver, propName, binder, guardBinder);
    }

    @Override
    protected StrategicLink linkGetMethod(StrategyChain chain, Operation op) throws NoSuchMethodException, IllegalAccessException {
        Object receiver = chain.getRequest().receiver();
        Binder binder = Binder.from(chain.getRequest().type());
        Binder guardBinder = Binder.from(chain.getRequest().type().changeReturnType(Boolean.TYPE));
        Object[] args = chain.getRequest().arguments();
        String propName = op.getParameter();
        if (args.length == 1) {
            binder = this.insertContext(binder);
            binder = this.insertName(binder, propName);
            guardBinder = this.insertContext(guardBinder);
            guardBinder = this.insertName(guardBinder, propName);
        } else if (args.length == 2) {
            if (propName == null) {
                propName = (String)args[1];
                binder = this.insertContext(binder);
                guardBinder = this.insertContext(guardBinder);
            } else {
                binder = this.insertName(binder, propName);
                guardBinder = this.insertName(guardBinder, propName);
            }
        } else if (args.length == 3) {
            binder = this.filterContext(binder);
            guardBinder = this.filterContext(guardBinder);
            propName = (String)args[2];
        }
        binder = binder.convert(Object.class, Object.class, this.getRuntimeContextClass(), String.class);
        guardBinder = guardBinder.convert(Boolean.TYPE, Object.class, this.getRuntimeContextClass(), String.class);
        this.log("[GET_METHOD] receiver=%s; propName=%s", receiver, propName);
        return this.linkGetMethod(chain, receiver, propName, binder, guardBinder);
    }

    @Override
    protected StrategicLink linkSetProperty(StrategyChain chain, Operation op) throws NoSuchMethodException, IllegalAccessException {
        Binder binder = Binder.from(chain.getRequest().type());
        Binder guardBinder = Binder.from(chain.getRequest().type().changeReturnType(Boolean.TYPE));
        Object[] args = chain.getRequest().arguments();
        Object receiver = args[0];
        Object value = args[args.length - 1];
        String propName = op.getParameter();
        if (args.length == 2) {
            binder = this.insertContext(binder);
            binder = this.insertName(binder, propName);
            guardBinder = this.insertContext(guardBinder);
            guardBinder = this.insertName(guardBinder, propName);
        } else if (args.length == 3) {
            if (propName == null) {
                propName = (String)args[1];
                binder = this.insertContext(binder);
                guardBinder = this.insertContext(guardBinder);
            } else {
                binder = this.insertName(binder, propName);
                guardBinder = this.insertName(guardBinder, propName);
            }
        } else if (args.length == 4) {
            propName = (String)args[2];
            binder = this.filterContext(binder);
            guardBinder = this.filterContext(guardBinder);
        }
        binder = binder.convert(Void.TYPE, Object.class, this.getRuntimeContextClass(), String.class, Object.class);
        guardBinder = guardBinder.convert(Boolean.TYPE, Object.class, this.getRuntimeContextClass(), String.class, Object.class);
        this.log("[SET_PROPERTY] receiver=%s; propName=%s", receiver, propName);
        return this.linkSetProperty(chain, receiver, propName, value, binder, guardBinder);
    }

    @Override
    protected StrategicLink linkCall(StrategyChain chain, Operation each) throws NoSuchMethodException, IllegalAccessException {
        Binder binder = Binder.from(chain.getRequest().type());
        Binder guardBinder = Binder.from(chain.getRequest().type().changeReturnType(Boolean.TYPE));
        Object[] args = chain.getRequest().arguments();
        Object receiver = args[0];
        Object self = null;
        Object[] callArgs = (Object[])args[args.length - 1];
        if (args.length == 3) {
            self = args[1];
            binder = this.insertContext(binder);
            guardBinder = this.insertContext(guardBinder);
        } else if (args.length == 4) {
            self = args[2];
            binder = this.filterContext(binder);
            guardBinder = this.filterContext(guardBinder);
        }
        binder = binder.convert(Object.class, Object.class, this.getRuntimeContextClass(), Object.class, Object[].class);
        guardBinder = guardBinder.convert(Boolean.TYPE, Object.class, this.getRuntimeContextClass(), Object.class, Object[].class);
        this.log("[CALL] receiver=%s", receiver);
        return this.linkCall(chain, receiver, self, callArgs, binder, guardBinder);
    }

    @Override
    protected StrategicLink linkConstruct(StrategyChain chain, Operation each) throws NoSuchMethodException, IllegalAccessException {
        Binder binder = Binder.from(chain.getRequest().type());
        Binder guardBinder = Binder.from(chain.getRequest().type().changeReturnType(Boolean.TYPE));
        Object[] args = chain.getRequest().arguments();
        Object receiver = args[0];
        Object[] callArgs = (Object[])args[args.length - 1];
        if (args.length == 2) {
            binder = binder.insert(1, new Class[]{Object.class}, new Object[]{null});
            binder = binder.filter(1, this.contextAcquisitionFilter());
            guardBinder = guardBinder.insert(1, new Class[]{Object.class}, new Object[]{null});
            guardBinder = guardBinder.filter(1, this.contextAcquisitionFilter());
        } else if (args.length == 3) {
            binder = binder.filter(1, this.contextAcquisitionFilter());
            guardBinder = guardBinder.filter(1, this.contextAcquisitionFilter());
        }
        this.log("[CONSTRUCT] receiver=%s", receiver);
        return this.linkConstruct(chain, receiver, callArgs, binder, guardBinder);
    }

    public static MethodHandle getReceiverClassAndNameAndValueClassGuard(Class<?> expectedReceiverClass, String expectedName, Class<?> expectedValueClass, Binder binder) throws NoSuchMethodException, IllegalAccessException {
        return binder.drop(1).insert(3, expectedReceiverClass).insert(4, expectedName).insert(5, expectedValueClass).invokeStatic(ContextualLinkStrategy.lookup(), Guards.class, "receiverClassAndNameAndValueClassGuard");
    }

    private Binder filterContext(Binder binder) throws NoSuchMethodException, IllegalAccessException {
        return binder.filter(1, this.contextAcquisitionFilter());
    }

    private Binder insertContext(Binder binder) throws NoSuchMethodException, IllegalAccessException {
        return this.filterContext(binder.insert(1, new Class[]{Object.class}, new Object[]{null}));
    }

    private Binder insertName(Binder binder, String name) {
        return binder.insert(2, name);
    }
}

