/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.rephract.mop.java;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.projectodd.rephract.mop.java.CoercionMatrix;
import org.projectodd.rephract.mop.java.DynamicMethod;

public class AbstractResolver {
    private CoercionMatrix coercionMatrix;
    private Class<?> targetClass;
    private Map<String, MethodHandle> propertyReaders = new HashMap<String, MethodHandle>();
    private Map<String, DynamicMethod> propertyWriters = new HashMap<String, DynamicMethod>();
    private Map<String, DynamicMethod> methods = new HashMap<String, DynamicMethod>();

    public AbstractResolver(CoercionMatrix coercionMatrix, Class<?> targetClass) {
        this.coercionMatrix = coercionMatrix;
        this.targetClass = targetClass;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public CoercionMatrix getCoercionMatrix() {
        return this.coercionMatrix;
    }

    protected void analyzeMethod(Method method) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        String name = method.getName();
        DynamicMethod dynamicMethod = this.methods.get(name);
        if (dynamicMethod == null) {
            dynamicMethod = new DynamicMethod(this.getCoercionMatrix(), name, Modifier.isStatic(method.getModifiers()));
            this.methods.put(name, dynamicMethod);
        }
        try {
            MethodHandle unreflectedMethod = lookup.unreflect(method);
            dynamicMethod.addMethodHandle(unreflectedMethod);
            if (name.length() >= 4) {
                if (name.startsWith("set")) {
                    DynamicMethod writer = this.propertyWriters.get(name = this.convertToPropertyName(name));
                    if (writer == null) {
                        writer = new DynamicMethod(this.getCoercionMatrix(), name, Modifier.isStatic(method.getModifiers()));
                        this.propertyWriters.put(name, writer);
                    }
                    writer.addMethodHandle(unreflectedMethod);
                } else if (name.startsWith("get")) {
                    name = this.convertToPropertyName(name);
                    this.propertyReaders.put(name, unreflectedMethod);
                }
            }
        }
        catch (IllegalAccessException e1) {
            // empty catch block
        }
    }

    protected void analyzeField(Field field) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        String name = field.getName();
        try {
            DynamicMethod writer = this.propertyWriters.get(name);
            if (writer == null) {
                writer = new DynamicMethod(this.getCoercionMatrix(), name, Modifier.isStatic(field.getModifiers()));
                this.propertyWriters.put(name, writer);
            }
            if (!Modifier.isFinal(field.getModifiers())) {
                writer.addMethodHandle(lookup.unreflectSetter(field));
            }
            this.propertyReaders.put(name, lookup.unreflectGetter(field));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected String convertToPropertyName(String name) {
        String propName = null;
        propName = name.length() == 4 ? name.substring(3).toLowerCase() : name.substring(3, 4).toLowerCase() + name.substring(4);
        return propName;
    }

    public DynamicMethod getMethod(String name) {
        return this.methods.get(name);
    }

    public MethodHandle getPropertyReader(String name) {
        return this.propertyReaders.get(name);
    }

    public DynamicMethod getPropertyWriter(String name) {
        return this.propertyWriters.get(name);
    }
}

