/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.rephract.mop.java;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.projectodd.rephract.mop.java.AbstractResolver;
import org.projectodd.rephract.mop.java.CoercionMatrix;
import org.projectodd.rephract.mop.java.DynamicConstructor;

public class ClassResolver
extends AbstractResolver {
    private DynamicConstructor constructor;

    public ClassResolver(CoercionMatrix coercionMatrix, Class<?> target) {
        super(coercionMatrix, target);
        this.constructor = new DynamicConstructor(coercionMatrix);
        this.analyze(target, true);
    }

    private void analyze(Class<?> cls, boolean topLevel) {
        int i;
        if (!Modifier.isPublic(cls.getModifiers())) {
            return;
        }
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        if (topLevel) {
            this.constructor = new DynamicConstructor(this.getCoercionMatrix());
            Constructor<?>[] constructors = cls.getConstructors();
            for (i = 0; i < constructors.length; ++i) {
                try {
                    this.constructor.addConstructorHandle(lookup.unreflectConstructor(constructors[i]));
                    continue;
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
        Method[] methods = this.getTargetClass().getMethods();
        for (i = 0; i < methods.length; ++i) {
            int modifiers = methods[i].getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) continue;
            this.analyzeMethod(methods[i]);
        }
        Field[] fields = this.getTargetClass().getFields();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            int modifiers = fields[i2].getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) continue;
            this.analyzeField(fields[i2]);
        }
        if (cls.getSuperclass() != null) {
            this.analyze(cls.getSuperclass(), false);
        }
        Class<?>[] interfaces = cls.getInterfaces();
        for (int i3 = 0; i3 < interfaces.length; ++i3) {
            this.analyze(interfaces[i3], false);
        }
    }

    public DynamicConstructor getConstructor() {
        return this.constructor;
    }
}

