/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.rephract.mop.java;

import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.projectodd.rephract.mop.java.AbstractDynamicMember;
import org.projectodd.rephract.mop.java.BoundDynamicMethod;
import org.projectodd.rephract.mop.java.CoercionMatrix;
import org.projectodd.rephract.mop.java.InvocationPlan;

public class DynamicMethod
extends AbstractDynamicMember {
    private String name;
    private List<MethodHandle> methods = new ArrayList<MethodHandle>();
    private boolean isStatic;

    public DynamicMethod(CoercionMatrix coercionMatrix, String name, boolean isStatic) {
        super(coercionMatrix);
        this.name = name;
        this.isStatic = isStatic;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String getName() {
        return this.name;
    }

    public void addMethodHandle(MethodHandle method) {
        this.methods.add(method);
    }

    public BoundDynamicMethod bind(Object self) {
        return new BoundDynamicMethod(self, this);
    }

    public List<MethodHandle> getMethods() {
        return this.methods;
    }

    public InvocationPlan findMethodInvoationPlan(Object[] args) {
        CoercionMatrix matrix = this.getCoercionMatrix();
        int matchedIndex = -1;
        int bestDistance = Integer.MAX_VALUE;
        int numMethods = this.methods.size();
        block0: for (int i = 0; i < numMethods; ++i) {
            MethodHandle each = this.methods.get(i);
            int methodDistance = 0;
            Class<?>[] paramTypes = this.getPureParameterArray(each);
            if (paramTypes.length != args.length) continue;
            for (int j = 0; j < paramTypes.length; ++j) {
                int paramDistance;
                int n = paramDistance = args[j] == null ? 0 : matrix.isCompatible(paramTypes[j], args[j]);
                if (paramDistance < 0) continue block0;
                methodDistance += paramDistance;
            }
            if (methodDistance >= bestDistance) continue;
            matchedIndex = i;
            bestDistance = methodDistance;
        }
        if (matchedIndex >= 0) {
            MethodHandle matchedMethod = this.methods.get(matchedIndex);
            Class<?>[] paramTypes = this.getPureParameterArray(matchedMethod);
            MethodHandle[] filters = new MethodHandle[paramTypes.length];
            for (int j = 0; j < paramTypes.length; ++j) {
                filters[j] = matrix.getFilter(paramTypes[j], args[j]);
            }
            return new InvocationPlan(matchedMethod, filters);
        }
        return null;
    }

    protected Class<?>[] getPureParameterArray(MethodHandle handle) {
        List<Class<?>> paramList = handle.type().parameterList();
        if (this.isStatic) {
            return paramList.toArray(new Class[paramList.size()]);
        }
        if (paramList.size() == 1) {
            return new Class[0];
        }
        return paramList.subList(1, paramList.size()).toArray(new Class[paramList.size() - 1]);
    }

    public String toString() {
        return "[DynamicMethod: name=" + this.name + "; isStatic=" + this.isStatic + "; methods=" + Arrays.asList(this.methods) + "]";
    }
}

