/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.rephract.mop.java;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.projectodd.rephract.mop.java.AbstractResolver;
import org.projectodd.rephract.mop.java.CoercionMatrix;

public class InstanceResolver
extends AbstractResolver {
    public InstanceResolver(CoercionMatrix coercionMatrix, Class<?> target) {
        super(coercionMatrix, target);
        this.analyze(target);
    }

    private void analyze(Class<?> cls) {
        Method[] methods = cls.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            int modifiers = methods[i].getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) continue;
            this.analyzeMethod(methods[i]);
        }
        Field[] fields = cls.getFields();
        for (int i = 0; i < fields.length; ++i) {
            int modifiers = fields[i].getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) continue;
            this.analyzeField(fields[i]);
        }
        if (cls.getSuperclass() != null) {
            this.analyze(cls.getSuperclass());
        }
        Class<?>[] interfaces = cls.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.analyze(interfaces[i]);
        }
    }
}

