/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.rephract.mop.java;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ReturnFilters {
    private final MethodHandle noOp;
    private final Map<Class<?>, MethodHandle> filters = new HashMap();

    private static void noOp() {
    }

    public ReturnFilters() {
        try {
            this.noOp = MethodHandles.lookup().findStatic(ReturnFilters.class, "noOp", MethodType.methodType(Void.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public void addReturnFilter(Class<?> clazz, MethodHandle handle) {
        this.filters.put(clazz, handle);
    }

    public MethodHandle getReturnFilter(Class<?> returnType) {
        MethodHandle result = this.getMethodHandleInner(returnType, new LinkedHashSet(Arrays.asList(returnType.getInterfaces())));
        if (result == null) {
            return this.inferNoOpReturnFilter(returnType);
        }
        return result;
    }

    private MethodHandle getMethodHandleInner(Class<?> returnType, Set<Class<?>> classes) {
        if (this.filters.containsKey(returnType)) {
            return this.filters.get(returnType);
        }
        if (!classes.isEmpty()) {
            Class<?> next = classes.iterator().next();
            classes.remove(next);
            classes.addAll(Arrays.asList(next.getInterfaces()));
            return this.getMethodHandleInner(next, classes);
        }
        return null;
    }

    public MethodHandle getReturnFilter(MethodHandle handle) {
        return this.getReturnFilter((Class<?>)handle.type().returnType());
    }

    private MethodHandle inferNoOpReturnFilter(Class<?> returnType) {
        if (returnType == Void.TYPE) {
            return this.noOp;
        }
        return MethodHandles.identity(returnType);
    }

    MethodHandle getNoOp() {
        return this.noOp;
    }
}

