/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.Builder;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class BuildMojo
extends AbstractMojo {
    private String classPath = null;
    private String[] classPaths = null;
    private File outputDirectory = null;
    protected String outputName = null;
    protected boolean compile = true;
    protected boolean header = false;
    protected String jarPrefix = null;
    protected String properties = null;
    protected File propertyFile = null;
    protected Properties propertyKeysAndValues = null;
    protected String classOrPackageName = null;
    protected String[] classOrPackageNames = null;
    protected Map<String, String> environmentVariables = null;
    protected String[] compilerOptions = null;

    public void execute() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)"Executing JavaCPP Builder");
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("classPath: " + this.classPath));
                this.getLog().debug((CharSequence)("classPaths: " + Arrays.deepToString(this.classPaths)));
                this.getLog().debug((CharSequence)("outputDirectory: " + this.outputDirectory));
                this.getLog().debug((CharSequence)("outputName: " + this.outputName));
                this.getLog().debug((CharSequence)("compile: " + this.compile));
                this.getLog().debug((CharSequence)("header: " + this.header));
                this.getLog().debug((CharSequence)("jarPrefix: " + this.jarPrefix));
                this.getLog().debug((CharSequence)("properties: " + this.properties));
                this.getLog().debug((CharSequence)("propertyFile: " + this.propertyFile));
                this.getLog().debug((CharSequence)("propertyKeysAndValues: " + this.propertyKeysAndValues));
                this.getLog().debug((CharSequence)("classOrPackageName: " + this.classOrPackageName));
                this.getLog().debug((CharSequence)("classOrPackageNames: " + Arrays.deepToString(this.classOrPackageNames)));
                this.getLog().debug((CharSequence)("environmentVariables: " + this.environmentVariables));
                this.getLog().debug((CharSequence)("compilerOptions: " + this.compilerOptions));
            }
            if (this.classPaths != null && this.classPath != null) {
                this.classPaths = Arrays.copyOf(this.classPaths, this.classPaths.length + 1);
                this.classPaths[this.classPaths.length - 1] = this.classPath;
            } else if (this.classPath != null) {
                this.classPaths = new String[]{this.classPath};
            }
            if (this.classOrPackageNames != null && this.classOrPackageName != null) {
                this.classOrPackageNames = Arrays.copyOf(this.classOrPackageNames, this.classOrPackageNames.length + 1);
                this.classOrPackageNames[this.classOrPackageNames.length - 1] = this.classOrPackageName;
            } else if (this.classOrPackageName != null) {
                this.classOrPackageNames = new String[]{this.classOrPackageName};
            }
            Collection<File> outputFiles = new Builder().classPaths(this.classPaths).outputDirectory(this.outputDirectory).outputName(this.outputName).compile(this.compile).header(this.header).jarPrefix(this.jarPrefix).properties(this.properties).propertyFile(this.propertyFile).properties(this.propertyKeysAndValues).classesOrPackages(this.classOrPackageNames).environmentVariables(this.environmentVariables).compilerOptions(this.compilerOptions).build();
            this.getLog().info((CharSequence)"Successfully executed JavaCPP Builder");
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("outputFiles: " + outputFiles));
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Failed to execute JavaCPP Builder: " + e.getMessage()));
            throw new MojoExecutionException("Failed to execute JavaCPP Builder", e);
        }
    }
}

