/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.BoolPointer;
import com.googlecode.javacpp.BytePointer;
import com.googlecode.javacpp.CLongPointer;
import com.googlecode.javacpp.CharPointer;
import com.googlecode.javacpp.DoublePointer;
import com.googlecode.javacpp.FloatPointer;
import com.googlecode.javacpp.FunctionPointer;
import com.googlecode.javacpp.IntPointer;
import com.googlecode.javacpp.Loader;
import com.googlecode.javacpp.LongPointer;
import com.googlecode.javacpp.Pointer;
import com.googlecode.javacpp.PointerPointer;
import com.googlecode.javacpp.ShortPointer;
import com.googlecode.javacpp.SizeTPointer;
import com.googlecode.javacpp.annotation.Adapter;
import com.googlecode.javacpp.annotation.Allocator;
import com.googlecode.javacpp.annotation.ArrayAllocator;
import com.googlecode.javacpp.annotation.ByPtr;
import com.googlecode.javacpp.annotation.ByPtrPtr;
import com.googlecode.javacpp.annotation.ByPtrRef;
import com.googlecode.javacpp.annotation.ByRef;
import com.googlecode.javacpp.annotation.ByVal;
import com.googlecode.javacpp.annotation.Cast;
import com.googlecode.javacpp.annotation.Const;
import com.googlecode.javacpp.annotation.Convention;
import com.googlecode.javacpp.annotation.Function;
import com.googlecode.javacpp.annotation.Index;
import com.googlecode.javacpp.annotation.MemberGetter;
import com.googlecode.javacpp.annotation.MemberSetter;
import com.googlecode.javacpp.annotation.Name;
import com.googlecode.javacpp.annotation.Namespace;
import com.googlecode.javacpp.annotation.NoDeallocator;
import com.googlecode.javacpp.annotation.NoException;
import com.googlecode.javacpp.annotation.NoOffset;
import com.googlecode.javacpp.annotation.Opaque;
import com.googlecode.javacpp.annotation.Platform;
import com.googlecode.javacpp.annotation.Properties;
import com.googlecode.javacpp.annotation.Raw;
import com.googlecode.javacpp.annotation.ValueGetter;
import com.googlecode.javacpp.annotation.ValueSetter;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator
implements Closeable {
    public static final String JNI_VERSION = "JNI_VERSION_1_6";
    private static final Logger logger = Logger.getLogger(Generator.class.getName());
    private static final List<Class> baseClasses = Arrays.asList(Pointer.class, BytePointer.class, ShortPointer.class, IntPointer.class, LongPointer.class, FloatPointer.class, DoublePointer.class, CharPointer.class, PointerPointer.class, BoolPointer.class, CLongPointer.class, SizeTPointer.class);
    private java.util.Properties properties;
    private PrintWriter out;
    private PrintWriter out2;
    private LinkedListRegister<String> functionDefinitions;
    private LinkedListRegister<String> functionPointers;
    private LinkedListRegister<Class> deallocators;
    private LinkedListRegister<Class> arrayDeallocators;
    private LinkedListRegister<Class> jclasses;
    private LinkedListRegister<Class> jclassesInit;
    private HashMap<Class, LinkedList<String>> members;
    private boolean mayThrowExceptions;
    private boolean usesAdapters;

    public Generator(java.util.Properties properties) {
        this.properties = properties;
    }

    public boolean generate(String sourceFilename, String headerFilename, String classPath, Class<?> ... classes) throws FileNotFoundException {
        this.out = new PrintWriter(new Writer(){

            public void close() {
            }

            public void flush() {
            }

            public void write(char[] cbuf, int off, int len) {
            }
        });
        this.out2 = null;
        this.functionDefinitions = new LinkedListRegister();
        this.functionPointers = new LinkedListRegister();
        this.deallocators = new LinkedListRegister();
        this.arrayDeallocators = new LinkedListRegister();
        this.jclasses = new LinkedListRegister();
        this.jclassesInit = new LinkedListRegister();
        this.members = new HashMap();
        this.mayThrowExceptions = false;
        this.usesAdapters = false;
        if (this.doClasses(true, true, classPath, classes)) {
            this.out = new PrintWriter(sourceFilename);
            if (headerFilename != null) {
                this.out2 = new PrintWriter(headerFilename);
            }
            return this.doClasses(this.mayThrowExceptions, this.usesAdapters, classPath, classes);
        }
        return false;
    }

    @Override
    public void close() {
        if (this.out != null) {
            this.out.close();
        }
        if (this.out2 != null) {
            this.out2.close();
        }
    }

    private boolean doClasses(boolean handleExceptions, boolean defineAdapters, String classPath, Class<?> ... classes) {
        LinkedList<String> m;
        String[] typeName;
        String name;
        String define;
        this.out.println("/* DO NOT EDIT THIS FILE - IT IS MACHINE GENERATED */");
        this.out.println();
        if (this.out2 != null) {
            this.out2.println("/* DO NOT EDIT THIS FILE - IT IS MACHINE GENERATED */");
            this.out2.println();
        }
        if ((define = this.properties.getProperty("generator.define")) != null && define.length() > 0) {
            for (String s : define.split("\u0000")) {
                this.out.println("#define " + s);
            }
            this.out.println();
        }
        this.out.println("#ifdef __APPLE__");
        this.out.println("    #define _JAVASOFT_JNI_MD_H_");
        this.out.println();
        this.out.println("    #define JNIEXPORT __attribute__((visibility(\"default\")))");
        this.out.println("    #define JNIIMPORT");
        this.out.println("    #define JNICALL");
        this.out.println();
        this.out.println("    typedef int jint;");
        this.out.println("    typedef long long jlong;");
        this.out.println("    typedef signed char jbyte;");
        this.out.println("#endif");
        this.out.println("#ifdef _WIN32");
        this.out.println("    #define _JAVASOFT_JNI_MD_H_");
        this.out.println();
        this.out.println("    #define JNIEXPORT __declspec(dllexport)");
        this.out.println("    #define JNIIMPORT __declspec(dllimport)");
        this.out.println("    #define JNICALL __stdcall");
        this.out.println();
        this.out.println("    typedef int jint;");
        this.out.println("    typedef long long jlong;");
        this.out.println("    typedef signed char jbyte;");
        this.out.println("#endif");
        this.out.println("#include <jni.h>");
        if (this.out2 != null) {
            this.out2.println("#include <jni.h>");
        }
        this.out.println("#ifdef ANDROID");
        this.out.println("    #include <android/log.h>");
        this.out.println("    #define NewWeakGlobalRef(obj) NewGlobalRef(obj)");
        this.out.println("    #define DeleteWeakGlobalRef(obj) DeleteGlobalRef(obj)");
        this.out.println("#endif");
        this.out.println();
        this.out.println("#include <stddef.h>");
        this.out.println("#ifndef _WIN32");
        this.out.println("    #include <stdint.h>");
        this.out.println("#endif");
        this.out.println("#include <stdio.h>");
        this.out.println("#include <stdlib.h>");
        this.out.println("#include <string.h>");
        this.out.println("#include <exception>");
        this.out.println("#include <new>");
        this.out.println();
        this.out.println("#define jlong_to_ptr(a) ((void*)(uintptr_t)(a))");
        this.out.println("#define ptr_to_jlong(a) ((jlong)(uintptr_t)(a))");
        this.out.println();
        this.out.println("#if defined(_MSC_VER)");
        this.out.println("    #define JavaCPP_noinline __declspec(noinline)");
        this.out.println("    #define JavaCPP_hidden /* hidden by default */");
        this.out.println("#elif defined(__GNUC__)");
        this.out.println("    #define JavaCPP_noinline __attribute__((noinline))");
        this.out.println("    #define JavaCPP_hidden   __attribute__((visibility(\"hidden\")))");
        this.out.println("#else");
        this.out.println("    #define JavaCPP_noinline");
        this.out.println("    #define JavaCPP_hidden");
        this.out.println("#endif");
        this.out.println();
        String[] include = new String[]{this.properties.getProperty("generator.include"), this.properties.getProperty("generator.cinclude")};
        for (int i = 0; i < include.length; ++i) {
            if (include[i] == null || include[i].length() <= 0) continue;
            if (i == 1) {
                this.out.println("extern \"C\" {");
                if (this.out2 != null) {
                    this.out2.println("#ifdef __cplusplus");
                    this.out2.println("extern \"C\" {");
                    this.out2.println("#endif");
                }
            }
            for (String s : include[i].split("\u0000")) {
                String line = "#include ";
                if (!s.startsWith("<") && !s.startsWith("\"")) {
                    line = line + '\"';
                }
                line = line + s;
                if (!s.endsWith(">") && !s.endsWith("\"")) {
                    line = line + '\"';
                }
                this.out.println(line);
                if (this.out2 == null) continue;
                this.out2.println(line);
            }
            if (i == 1) {
                this.out.println("}");
                if (this.out2 != null) {
                    this.out2.println("#ifdef __cplusplus");
                    this.out2.println("}");
                    this.out2.println("#endif");
                }
            }
            this.out.println();
        }
        this.out.println("static JavaVM* JavaCPP_vm = NULL;");
        this.out.println("static const char* JavaCPP_classNames[" + this.jclasses.size() + "] = {");
        Iterator classIterator = this.jclasses.iterator();
        int maxMemberSize = 0;
        while (classIterator.hasNext()) {
            LinkedList<String> m2;
            Class c = (Class)classIterator.next();
            this.out.print("        \"" + c.getName().replace('.', '/') + "\"");
            if (classIterator.hasNext()) {
                this.out.println(",");
            }
            if ((m2 = this.members.get(c)) == null || m2.size() <= maxMemberSize) continue;
            maxMemberSize = m2.size();
        }
        this.out.println(" };");
        this.out.println("static jclass JavaCPP_classes[" + this.jclasses.size() + "] = { NULL };");
        this.out.println("static jmethodID JavaCPP_initMID = NULL;");
        this.out.println("static jfieldID JavaCPP_addressFID = NULL;");
        this.out.println("static jfieldID JavaCPP_positionFID = NULL;");
        this.out.println("static jfieldID JavaCPP_limitFID = NULL;");
        this.out.println("static jfieldID JavaCPP_capacityFID = NULL;");
        this.out.println();
        this.out.println("static inline void JavaCPP_log(const char* fmt, ...) {");
        this.out.println("    va_list ap;");
        this.out.println("    va_start(ap, fmt);");
        this.out.println("#ifdef ANDROID");
        this.out.println("    __android_log_vprint(ANDROID_LOG_ERROR, \"javacpp\", fmt, ap);");
        this.out.println("#else");
        this.out.println("    vfprintf(stderr, fmt, ap);");
        this.out.println("    fprintf(stderr, \"\\n\");");
        this.out.println("#endif");
        this.out.println("    va_end(ap);");
        this.out.println("}");
        this.out.println();
        this.out.println("static JavaCPP_noinline jclass JavaCPP_getClass(JNIEnv* env, int i) {");
        this.out.println("    if (JavaCPP_classes[i] == NULL && env->PushLocalFrame(1) == 0) {");
        this.out.println("        jclass cls = env->FindClass(JavaCPP_classNames[i]);");
        this.out.println("        if (cls == NULL || env->ExceptionCheck()) {");
        this.out.println("            JavaCPP_log(\"Error loading class %s.\", JavaCPP_classNames[i]);");
        this.out.println("            return NULL;");
        this.out.println("        }");
        this.out.println("        JavaCPP_classes[i] = (jclass)env->NewWeakGlobalRef(cls);");
        this.out.println("        if (JavaCPP_classes[i] == NULL || env->ExceptionCheck()) {");
        this.out.println("            JavaCPP_log(\"Error creating global reference of class %s.\", JavaCPP_classNames[i]);");
        this.out.println("            return NULL;");
        this.out.println("        }");
        this.out.println("        env->PopLocalFrame(NULL);");
        this.out.println("    }");
        this.out.println("    return JavaCPP_classes[i];");
        this.out.println("}");
        this.out.println();
        this.out.println("template <typename P> static inline P JavaCPP_dereference(JNIEnv* env, P* ptr) {");
        this.out.println("    if (ptr == NULL) {");
        this.out.println("        env->ThrowNew(JavaCPP_getClass(env, " + this.jclasses.register(NullPointerException.class) + "), \"Return pointer address is NULL.\");");
        this.out.println("        return P();");
        this.out.println("    }");
        this.out.println("    return *ptr;");
        this.out.println("}");
        this.out.println();
        this.out.println("class JavaCPP_hidden JavaCPP_exception : public std::exception {");
        this.out.println("public:");
        this.out.println("    JavaCPP_exception(const char* str) throw() {");
        this.out.println("        if (str == NULL) {");
        this.out.println("            strcpy(msg, \"Unknown exception.\");");
        this.out.println("        } else {");
        this.out.println("            strncpy(msg, str, sizeof(msg));");
        this.out.println("            msg[sizeof(msg) - 1] = 0;");
        this.out.println("        }");
        this.out.println("    }");
        this.out.println("    virtual const char* what() const throw() { return msg; }");
        this.out.println("    char msg[1024];");
        this.out.println("};");
        this.out.println();
        if (handleExceptions) {
            this.out.println("static JavaCPP_noinline void JavaCPP_handleException(JNIEnv* env) {");
            this.out.println("    try {");
            this.out.println("        throw;");
            this.out.println("    } catch (std::exception& e) {");
            this.out.println("        env->ThrowNew(JavaCPP_getClass(env, " + this.jclasses.register(RuntimeException.class) + "), e.what());");
            this.out.println("    } catch (...) {");
            this.out.println("        env->ThrowNew(JavaCPP_getClass(env, " + this.jclasses.register(RuntimeException.class) + "), \"Unknown exception.\");");
            this.out.println("    }");
            this.out.println("}");
            this.out.println();
        }
        if (defineAdapters) {
            this.out.println("#include <vector>");
            this.out.println("template<typename P, typename T = P> class JavaCPP_hidden VectorAdapter {");
            this.out.println("public:");
            this.out.println("    VectorAdapter(const P* ptr, typename std::vector<T>::size_type size) : ptr((P*)ptr), size(size),");
            this.out.println("        vec2(ptr ? std::vector<T>((P*)ptr, (P*)ptr + size) : std::vector<T>()), vec(vec2) { }");
            this.out.println("    VectorAdapter(const std::vector<T>& vec) : ptr(0), size(0), vec2(vec), vec(vec2) { }");
            this.out.println("    VectorAdapter(      std::vector<T>& vec) : ptr(0), size(0), vec(vec) { }");
            this.out.println("    void assign(P* ptr, typename std::vector<T>::size_type size) {");
            this.out.println("        this->ptr = ptr;");
            this.out.println("        this->size = size;");
            this.out.println("        vec.assign(ptr, ptr + size);");
            this.out.println("    }");
            this.out.println("    static void deallocate(P* ptr) { delete[] ptr; }");
            this.out.println("    operator P*() {");
            this.out.println("        if (vec.size() > size) {");
            this.out.println("            ptr = new (std::nothrow) P[vec.size()];");
            this.out.println("        }");
            this.out.println("        if (ptr) {");
            this.out.println("            std::copy(vec.begin(), vec.end(), ptr);");
            this.out.println("        }");
            this.out.println("        size = vec.size();");
            this.out.println("        return ptr;");
            this.out.println("    }");
            this.out.println("    operator const P*()        { return &vec[0]; }");
            this.out.println("    operator std::vector<T>&() { return vec; }");
            this.out.println("    operator std::vector<T>*() { return ptr ? &vec : 0; }");
            this.out.println("    P* ptr;");
            this.out.println("    typename std::vector<T>::size_type size;");
            this.out.println("    std::vector<T> vec2;");
            this.out.println("    std::vector<T>& vec;");
            this.out.println("};");
            this.out.println();
            this.out.println("#include <string>");
            this.out.println("class JavaCPP_hidden StringAdapter {");
            this.out.println("public:");
            this.out.println("    StringAdapter(const          char* ptr, size_t size) : ptr((char*)ptr), size(size),");
            this.out.println("        str2(ptr ? (char*)ptr : \"\"), str(str2) { }");
            this.out.println("    StringAdapter(const signed   char* ptr, size_t size) : ptr((char*)ptr), size(size),");
            this.out.println("        str2(ptr ? (char*)ptr : \"\"), str(str2) { }");
            this.out.println("    StringAdapter(const unsigned char* ptr, size_t size) : ptr((char*)ptr), size(size),");
            this.out.println("        str2(ptr ? (char*)ptr : \"\"), str(str2) { }");
            this.out.println("    StringAdapter(const std::string& str) : ptr(0), size(0), str2(str), str(str2) { }");
            this.out.println("    StringAdapter(      std::string& str) : ptr(0), size(0), str(str) { }");
            this.out.println("    void assign(char* ptr, size_t size) {");
            this.out.println("        this->ptr = ptr;");
            this.out.println("        this->size = size;");
            this.out.println("        str.assign(ptr ? ptr : \"\");");
            this.out.println("    }");
            this.out.println("    static void deallocate(char* ptr) { free(ptr); }");
            this.out.println("    operator char*() {");
            this.out.println("        const char* c_str = str.c_str();");
            this.out.println("        if (ptr == NULL || strcmp(c_str, ptr) != 0) {");
            this.out.println("            ptr = strdup(c_str);");
            this.out.println("        }");
            this.out.println("        size = strlen(c_str) + 1;");
            this.out.println("        return ptr;");
            this.out.println("    }");
            this.out.println("    operator       signed   char*() { return (signed   char*)(operator char*)(); }");
            this.out.println("    operator       unsigned char*() { return (unsigned char*)(operator char*)(); }");
            this.out.println("    operator const          char*() { return                 str.c_str(); }");
            this.out.println("    operator const signed   char*() { return (signed   char*)str.c_str(); }");
            this.out.println("    operator const unsigned char*() { return (unsigned char*)str.c_str(); }");
            this.out.println("    operator         std::string&() { return str; }");
            this.out.println("    operator         std::string*() { return ptr ? &str : 0; }");
            this.out.println("    char* ptr;");
            this.out.println("    size_t size;");
            this.out.println("    std::string str2;");
            this.out.println("    std::string& str;");
            this.out.println("};");
            this.out.println();
        }
        if (!this.functionDefinitions.isEmpty()) {
            this.out.println("static JavaCPP_noinline void JavaCPP_detach(int detach) {");
            this.out.println("    if (detach > 0 && JavaCPP_vm->DetachCurrentThread() != 0) {");
            this.out.println("        JavaCPP_log(\"Could not detach the JavaVM from the current thread.\");");
            this.out.println("    }");
            this.out.println("}");
            this.out.println();
            this.out.println("static JavaCPP_noinline int JavaCPP_getEnv(JNIEnv** env) {");
            this.out.println("    int attached = 0;");
            this.out.println("    struct {");
            this.out.println("        JNIEnv **env;");
            this.out.println("        operator JNIEnv**() { return env; } // Android JNI");
            this.out.println("        operator void**() { return (void**)env; } // standard JNI");
            this.out.println("    } env2 = { env };");
            this.out.println("    JavaVM *vm = JavaCPP_vm;");
            this.out.println("    if (vm == NULL) {");
            if (this.out2 != null) {
                this.out.println("#ifndef ANDROID");
                this.out.println("        int size = 1;");
                this.out.println("        if (JNI_GetCreatedJavaVMs(&vm, 1, &size) != 0 || size == 0) {");
                this.out.println("#endif");
            }
            this.out.println("            JavaCPP_log(\"Could not get any created JavaVM.\");");
            this.out.println("            return -1;");
            if (this.out2 != null) {
                this.out.println("#ifndef ANDROID");
                this.out.println("        }");
                this.out.println("#endif");
            }
            this.out.println("    }");
            this.out.println("    if (vm->GetEnv((void**)env, JNI_VERSION_1_6) != JNI_OK) {");
            this.out.println("        if (vm->AttachCurrentThread(env2, NULL) != 0) {");
            this.out.println("            JavaCPP_log(\"Could not attach the JavaVM to the current thread.\");");
            this.out.println("            return -1;");
            this.out.println("        }");
            this.out.println("        attached = 1;");
            this.out.println("    }");
            this.out.println("    if (JavaCPP_vm == NULL) {");
            this.out.println("        if (JNI_OnLoad(vm, NULL) < 0) {");
            this.out.println("            JavaCPP_detach(attached);");
            this.out.println("            return -1;");
            this.out.println("        }");
            this.out.println("    }");
            this.out.println("    return attached;");
            this.out.println("}");
            this.out.println();
        }
        for (String s : this.functionDefinitions) {
            this.out.println(s);
        }
        this.out.println();
        for (String s : this.functionPointers) {
            this.out.println(s);
        }
        this.out.println();
        for (Class c : this.deallocators) {
            name = "JavaCPP_" + Generator.mangle(c.getName());
            this.out.print("static void " + name + "_deallocate(");
            if (FunctionPointer.class.isAssignableFrom(c)) {
                typeName = this.getFunctionClassName(c);
                this.out.println((String)typeName + "* p) { JNIEnv *e; int a = JavaCPP_getEnv(&e); if (a >= 0) e->DeleteWeakGlobalRef(p->obj); delete p; JavaCPP_detach(a); }");
                continue;
            }
            typeName = Generator.getCPPTypeName(c);
            this.out.println(typeName[0] + " p" + typeName[1] + ") { delete p; }");
        }
        for (Class c : this.arrayDeallocators) {
            name = "JavaCPP_" + Generator.mangle(c.getName());
            typeName = Generator.getCPPTypeName(c);
            this.out.println("static void " + name + "_deallocateArray(" + typeName[0] + " p" + typeName[1] + ") { delete[] p; }");
        }
        this.out.println();
        this.out.println("extern \"C\" {");
        if (this.out2 != null) {
            this.out2.println();
            this.out2.println("#ifdef __cplusplus");
            this.out2.println("extern \"C\" {");
            this.out2.println("#endif");
            this.out2.println("JNIIMPORT int JavaCPP_init(int argc, const char *argv[]);");
            this.out.println();
            this.out.println("#ifndef ANDROID");
            this.out.println("JNIEXPORT int JavaCPP_init(int argc, const char *argv[]) {");
            this.out.println("    JavaVM *vm;");
            this.out.println("    JNIEnv *env;");
            this.out.println("    int nOptions = 1 + (argc > 255 ? 255 : argc);");
            this.out.println("    JavaVMOption options[256] = { { NULL } };");
            this.out.println("    options[0].optionString = (char*)\"-Djava.class.path=" + classPath + "\";");
            this.out.println("    for (int i = 1; i < nOptions && argv != NULL; i++) {");
            this.out.println("        options[i].optionString = (char*)argv[i - 1];");
            this.out.println("    }");
            this.out.println("    JavaVMInitArgs vm_args = { JNI_VERSION_1_6, nOptions, options };");
            this.out.println("    return JNI_CreateJavaVM(&vm, (void **)&env, &vm_args);");
            this.out.println("}");
            this.out.println("#endif");
        }
        this.out.println();
        this.out.println("JNIEXPORT jint JNICALL JNI_OnLoad(JavaVM* vm, void* reserved) {");
        this.out.println("    JNIEnv* env;");
        this.out.println("    if (vm->GetEnv((void**)&env, JNI_VERSION_1_6) != JNI_OK) {");
        this.out.println("        JavaCPP_log(\"Could not get JNIEnv for JNI_VERSION_1_6 inside JNI_OnLoad().\");");
        this.out.println("        return JNI_ERR;");
        this.out.println("    }");
        this.out.println("    if (JavaCPP_vm == vm) {");
        this.out.println("        return env->GetVersion();");
        this.out.println("    }");
        this.out.println("    JavaCPP_vm = vm;");
        this.out.println("    const char* members[" + this.jclasses.size() + "][" + maxMemberSize + "] = {");
        classIterator = this.jclasses.iterator();
        while (classIterator.hasNext()) {
            Iterator memberIterator;
            this.out.print("            { ");
            m = this.members.get(classIterator.next());
            Iterator iterator = memberIterator = m == null ? null : m.iterator();
            while (memberIterator != null && memberIterator.hasNext()) {
                this.out.print("\"" + (String)memberIterator.next() + "\"");
                if (!memberIterator.hasNext()) continue;
                this.out.print(", ");
            }
            this.out.print(" }");
            if (!classIterator.hasNext()) continue;
            this.out.println(",");
        }
        this.out.println(" };");
        this.out.println("    int offsets[" + this.jclasses.size() + "][" + maxMemberSize + "] = {");
        classIterator = this.jclasses.iterator();
        while (classIterator.hasNext()) {
            Iterator memberIterator;
            this.out.print("            { ");
            Class c = (Class)classIterator.next();
            LinkedList<String> m3 = this.members.get(c);
            Iterator iterator = memberIterator = m3 == null ? null : m3.iterator();
            while (memberIterator != null && memberIterator.hasNext()) {
                typeName = Generator.getCPPTypeName(c);
                String valueTypeName = Generator.getValueTypeName(typeName);
                String memberName = (String)memberIterator.next();
                if ("sizeof".equals(memberName)) {
                    if ("void".equals(valueTypeName)) {
                        valueTypeName = "void*";
                    }
                    this.out.print("sizeof(" + valueTypeName + ")");
                } else {
                    this.out.print("offsetof(" + valueTypeName + "," + memberName + ")");
                }
                if (!memberIterator.hasNext()) continue;
                this.out.print(", ");
            }
            this.out.print(" }");
            if (!classIterator.hasNext()) continue;
            this.out.println(",");
        }
        this.out.println(" };");
        this.out.print("    int memberOffsetSizes[" + this.jclasses.size() + "] = { ");
        classIterator = this.jclasses.iterator();
        while (classIterator.hasNext()) {
            m = this.members.get(classIterator.next());
            this.out.print(m == null ? 0 : m.size());
            if (!classIterator.hasNext()) continue;
            this.out.print(", ");
        }
        this.out.println(" };");
        this.out.println("    jmethodID putMemberOffsetMID = env->GetStaticMethodID(JavaCPP_getClass(env, " + this.jclasses.register(Loader.class) + "), \"putMemberOffset\", \"(Ljava/lang/String;Ljava/lang/String;I)V\");");
        this.out.println("    if (putMemberOffsetMID == NULL || env->ExceptionCheck()) {");
        this.out.println("        JavaCPP_log(\"Error getting method ID of Loader.putMemberOffset().\");");
        this.out.println("        return JNI_ERR;");
        this.out.println("    }");
        this.out.println("    for (int i = 0; i < " + this.jclasses.size() + " && !env->ExceptionCheck(); i++) {");
        this.out.println("        for (int j = 0; j < memberOffsetSizes[i] && !env->ExceptionCheck(); j++) {");
        this.out.println("            if (env->PushLocalFrame(2) == 0) {");
        this.out.println("                jvalue args[3];");
        this.out.println("                args[0].l = env->NewStringUTF(JavaCPP_classNames[i]);");
        this.out.println("                args[1].l = env->NewStringUTF(members[i][j]);");
        this.out.println("                args[2].i = offsets[i][j];");
        this.out.println("                env->CallStaticVoidMethodA(JavaCPP_getClass(env, " + this.jclasses.register(Loader.class) + "), putMemberOffsetMID, args);");
        this.out.println("                env->PopLocalFrame(NULL);");
        this.out.println("            }");
        this.out.println("        }");
        this.out.println("    }");
        this.out.println("    JavaCPP_initMID = env->GetMethodID(JavaCPP_getClass(env, " + this.jclasses.register(Pointer.class) + "), \"init\", \"(JIJ)V\");");
        this.out.println("    if (JavaCPP_initMID == NULL || env->ExceptionCheck()) {");
        this.out.println("        JavaCPP_log(\"Error getting method ID of Pointer.init().\");");
        this.out.println("        return JNI_ERR;");
        this.out.println("    }");
        this.out.println("    JavaCPP_addressFID = env->GetFieldID(JavaCPP_getClass(env, " + this.jclasses.register(Pointer.class) + "), \"address\", \"J\");");
        this.out.println("    if (JavaCPP_addressFID == NULL || env->ExceptionCheck()) {");
        this.out.println("        JavaCPP_log(\"Error getting field ID of Pointer.address.\");");
        this.out.println("        return JNI_ERR;");
        this.out.println("    }");
        this.out.println("    JavaCPP_positionFID = env->GetFieldID(JavaCPP_getClass(env, " + this.jclasses.register(Pointer.class) + "), \"position\", \"I\");");
        this.out.println("    if (JavaCPP_positionFID == NULL || env->ExceptionCheck()) {");
        this.out.println("        JavaCPP_log(\"Error getting field ID of Pointer.position.\");");
        this.out.println("        return JNI_ERR;");
        this.out.println("    }");
        this.out.println("    JavaCPP_limitFID = env->GetFieldID(JavaCPP_getClass(env, " + this.jclasses.register(Pointer.class) + "), \"limit\", \"I\");");
        this.out.println("    if (JavaCPP_limitFID == NULL || env->ExceptionCheck()) {");
        this.out.println("        JavaCPP_log(\"Error getting field ID of Pointer.limit.\");");
        this.out.println("        return JNI_ERR;");
        this.out.println("    }");
        this.out.println("    JavaCPP_capacityFID = env->GetFieldID(JavaCPP_getClass(env, " + this.jclasses.register(Pointer.class) + "), \"capacity\", \"I\");");
        this.out.println("    if (JavaCPP_capacityFID == NULL || env->ExceptionCheck()) {");
        this.out.println("        JavaCPP_log(\"Error getting field ID of Pointer.capacity.\");");
        this.out.println("        return JNI_ERR;");
        this.out.println("    }");
        this.out.println("#ifdef ANDROID");
        for (Class c : this.jclassesInit) {
            if (c == Pointer.class) continue;
            this.out.println("    if (JavaCPP_getClass(env, " + this.jclasses.indexOf(c) + ") == NULL) {");
            this.out.println("        return JNI_ERR;");
            this.out.println("    }");
        }
        this.out.println("#endif");
        this.out.println("    return env->GetVersion();");
        this.out.println("}");
        this.out.println();
        if (this.out2 != null) {
            this.out2.println("JNIIMPORT int JavaCPP_uninit();");
            this.out2.println();
            this.out.println("#ifndef ANDROID");
            this.out.println("JNIEXPORT int JavaCPP_uninit() {");
            this.out.println("    JavaVM *vm = JavaCPP_vm;");
            this.out.println("    JNI_OnUnload(JavaCPP_vm, NULL);");
            this.out.println("    return vm->DestroyJavaVM();");
            this.out.println("}");
            this.out.println("#endif");
        }
        this.out.println();
        this.out.println("JNIEXPORT void JNICALL JNI_OnUnload(JavaVM* vm, void* reserved) {");
        this.out.println("    JNIEnv* env;");
        this.out.println("    if (vm->GetEnv((void**)&env, JNI_VERSION_1_6) != JNI_OK) {");
        this.out.println("        JavaCPP_log(\"Could not get JNIEnv for JNI_VERSION_1_6 inside JNI_OnUnLoad().\");");
        this.out.println("        return;");
        this.out.println("    }");
        this.out.println("    for (int i = 0; i < " + this.jclasses.size() + "; i++) {");
        this.out.println("        env->DeleteWeakGlobalRef(JavaCPP_classes[i]);");
        this.out.println("        JavaCPP_classes[i] = NULL;");
        this.out.println("    }");
        this.out.println("    JavaCPP_vm = NULL;");
        this.out.println("}");
        this.out.println();
        for (Class cls : baseClasses) {
            this.doMethods(cls);
        }
        boolean didSomethingUseful = false;
        for (Class<?> cls : classes) {
            try {
                didSomethingUseful |= this.doMethods(cls);
            }
            catch (NoClassDefFoundError e) {
                logger.log(Level.WARNING, "Could not generate code for class " + cls.getCanonicalName() + ": " + e);
            }
        }
        this.out.println("}");
        this.out.println();
        if (this.out2 != null) {
            this.out2.println("#ifdef __cplusplus");
            this.out2.println("}");
            this.out2.println("#endif");
        }
        return didSomethingUseful;
    }

    private boolean doMethods(Class<?> cls) {
        Properties classProperties = cls.getAnnotation(Properties.class);
        boolean platformMatches = false;
        if (classProperties != null) {
            for (Platform p : classProperties.value()) {
                if (!this.checkPlatform(p)) continue;
                platformMatches = true;
            }
        } else if (this.checkPlatform(cls.getAnnotation(Platform.class))) {
            platformMatches = true;
        }
        if (!platformMatches) {
            return false;
        }
        LinkedList<String> memberList = this.members.get(cls);
        if (cls == Pointer.class || !cls.isAnnotationPresent(Opaque.class) && !FunctionPointer.class.isAssignableFrom(cls)) {
            if (memberList == null) {
                memberList = new LinkedList();
                this.members.put(cls, memberList);
            }
            if (!memberList.contains("sizeof")) {
                memberList.add("sizeof");
            }
        }
        boolean didSomething = false;
        Class<?>[] classes = cls.getDeclaredClasses();
        for (int i = 0; i < classes.length; ++i) {
            if (!Pointer.class.isAssignableFrom(classes[i]) && !Pointer.Deallocator.class.isAssignableFrom(classes[i])) continue;
            didSomething |= this.doMethods(classes[i]);
        }
        Method[] methods = cls.getDeclaredMethods();
        boolean[] callbackAllocators = new boolean[methods.length];
        Method functionMethod = Generator.getFunctionMethod(cls, callbackAllocators);
        if (functionMethod != null) {
            String[] typeName = Generator.getCPPTypeName(cls);
            String[] returnConvention = typeName[0].split("\\(");
            returnConvention[1] = Generator.getValueTypeName(returnConvention[1]);
            String parameterDeclaration = typeName[1].substring(1);
            String instanceTypeName = this.getFunctionClassName(cls);
            this.functionDefinitions.register("struct JavaCPP_hidden " + instanceTypeName + " {\n" + "    " + instanceTypeName + "() : ptr(NULL), obj(NULL) { }\n" + "    " + returnConvention[0] + "operator()" + parameterDeclaration + ";\n" + "    " + typeName[0] + "ptr" + typeName[1] + ";\n" + "    jobject obj; static jmethodID mid;\n" + "};\n" + "jmethodID " + instanceTypeName + "::mid = NULL;");
        }
        boolean firstCallback = true;
        for (int i = 0; i < methods.length; ++i) {
            String nativeName = Generator.mangle(cls.getName()) + "_" + Generator.mangle(methods[i].getName());
            if (!this.checkPlatform(methods[i].getAnnotation(Platform.class))) continue;
            MethodInformation methodInfo = Generator.getMethodInformation(methods[i]);
            String callbackName = "JavaCPP_" + nativeName + "_callback";
            if (callbackAllocators[i] && functionMethod == null) {
                logger.log(Level.WARNING, "No callback method call() or apply() has been not declared in \"" + cls.getCanonicalName() + "\". No code will be generated for callback allocator.");
                continue;
            }
            if (callbackAllocators[i] || methods[i].equals(functionMethod) && methodInfo == null) {
                Name name = methods[i].getAnnotation(Name.class);
                if (name != null && name.value().length > 0 && name.value()[0].length() > 0) {
                    callbackName = name.value()[0];
                }
                this.doCallback(cls, functionMethod, callbackName, firstCallback);
                firstCallback = false;
                didSomething = true;
            }
            if (methodInfo == null) continue;
            if (!(!methodInfo.memberGetter && !methodInfo.memberSetter || methodInfo.noOffset || memberList == null || Modifier.isStatic(methodInfo.modifiers) || memberList.contains(methodInfo.memberName[0]))) {
                memberList.add(methodInfo.memberName[0]);
            }
            didSomething = true;
            this.out.print("JNIEXPORT " + Generator.getJNITypeName(methodInfo.returnType) + " JNICALL Java_" + nativeName);
            if (methodInfo.overloaded) {
                this.out.print("__" + Generator.mangle(Generator.getSignature(methodInfo.parameterTypes)));
            }
            if (Modifier.isStatic(methodInfo.modifiers)) {
                this.out.print("(JNIEnv* env, jclass cls");
            } else {
                this.out.print("(JNIEnv* env, jobject obj");
            }
            for (int j = 0; j < methodInfo.parameterTypes.length; ++j) {
                this.out.print(", " + Generator.getJNITypeName(methodInfo.parameterTypes[j]) + " arg" + j);
            }
            this.out.println(") {");
            if (callbackAllocators[i]) {
                this.doCallbackAllocator(cls, callbackName);
                continue;
            }
            if (!(Modifier.isStatic(methodInfo.modifiers) || methodInfo.allocator || methodInfo.arrayAllocator || methodInfo.deallocator)) {
                String[] typeName = Generator.getCPPTypeName(cls);
                if (methodInfo.bufferGetter && "void*".equals(typeName[0])) {
                    typeName[0] = "char*";
                } else if (FunctionPointer.class.isAssignableFrom(cls)) {
                    typeName[0] = this.getFunctionClassName(cls) + "*";
                    typeName[1] = "";
                }
                this.out.println("    " + typeName[0] + " ptr" + typeName[1] + " = (" + typeName[0] + typeName[1] + ")jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));");
                this.out.println("    if (ptr == NULL) {");
                this.out.println("        env->ThrowNew(JavaCPP_getClass(env, " + this.jclasses.register(NullPointerException.class) + "), \"This pointer address is NULL.\");");
                this.out.println("        return" + (methodInfo.returnType == Void.TYPE ? ";" : " 0;"));
                this.out.println("    }");
                if (FunctionPointer.class.isAssignableFrom(cls)) {
                    this.out.println("    if (ptr->ptr == NULL) {");
                    this.out.println("        env->ThrowNew(JavaCPP_getClass(env, " + this.jclasses.register(NullPointerException.class) + "), \"This function pointer address is NULL.\");");
                    this.out.println("        return" + (methodInfo.returnType == Void.TYPE ? ";" : " 0;"));
                    this.out.println("    }");
                }
                if (!cls.isAnnotationPresent(Opaque.class) || methodInfo.bufferGetter) {
                    this.out.println("    jint position = env->GetIntField(obj, JavaCPP_positionFID);");
                    this.out.println("    ptr += position;");
                    if (methodInfo.bufferGetter) {
                        this.out.println("    jint size = env->GetIntField(obj, JavaCPP_limitFID);");
                        this.out.println("    size -= position;");
                    }
                }
            }
            this.doParametersBefore(methodInfo);
            String returnPrefix = this.doReturnBefore(methodInfo);
            this.doCall(methodInfo, returnPrefix);
            this.doReturnAfter(methodInfo);
            this.doParametersAfter(methodInfo);
            if (methodInfo.returnType != Void.TYPE) {
                this.out.println("    return rarg;");
            }
            this.out.println("}");
        }
        this.out.println();
        return didSomething;
    }

    private void doParametersBefore(MethodInformation methodInfo) {
        String adapterLine = "";
        AdapterInformation prevAdapterInfo = null;
        for (int j = 0; j < methodInfo.parameterTypes.length; ++j) {
            if (methodInfo.parameterTypes[j].isPrimitive()) continue;
            Annotation passBy = Generator.getParameterBy(methodInfo, j);
            String cast = Generator.getParameterCast(methodInfo, j);
            String[] typeName = Generator.getCPPTypeName(methodInfo.parameterTypes[j]);
            AdapterInformation adapterInfo = Generator.getParameterAdapterInformation(false, methodInfo, j);
            if (FunctionPointer.class.isAssignableFrom(methodInfo.parameterTypes[j])) {
                if (methodInfo.parameterTypes[j] == FunctionPointer.class) {
                    logger.log(Level.WARNING, "Method \"" + methodInfo.method + "\" has an abstract FunctionPointer parameter, " + "but a concrete subclass is required. Compilation will most likely fail.");
                }
                typeName[0] = this.getFunctionClassName(methodInfo.parameterTypes[j]) + "*";
                typeName[1] = "";
            }
            if (typeName[0].length() == 0 || methodInfo.parameterRaw[j]) {
                methodInfo.parameterRaw[j] = true;
                typeName[0] = Generator.getJNITypeName(methodInfo.parameterTypes[j]);
                this.out.println("    " + typeName[0] + " ptr" + j + " = arg" + j + ";");
                continue;
            }
            this.out.print("    " + typeName[0] + " ptr" + j + typeName[1] + " = ");
            if (Pointer.class.isAssignableFrom(methodInfo.parameterTypes[j])) {
                this.out.println("arg" + j + " == NULL ? NULL : (" + typeName[0] + typeName[1] + ")jlong_to_ptr(env->GetLongField(arg" + j + ", JavaCPP_addressFID));");
                if (j == 0 && FunctionPointer.class.isAssignableFrom(methodInfo.cls) && methodInfo.cls.isAnnotationPresent(Namespace.class) || passBy instanceof ByVal || passBy instanceof ByRef) {
                    this.out.println("    if (ptr" + j + " == NULL) {");
                    this.out.println("        env->ThrowNew(JavaCPP_getClass(env, " + this.jclasses.register(NullPointerException.class) + "), \"Pointer address of argument " + j + " is NULL.\");");
                    this.out.println("        return" + (methodInfo.returnType == Void.TYPE ? ";" : " 0;"));
                    this.out.println("    }");
                }
                if (adapterInfo != null || prevAdapterInfo != null) {
                    this.out.println("    jint size" + j + " = arg" + j + " == NULL ? 0 : env->GetIntField(arg" + j + ", JavaCPP_limitFID);");
                }
                if (!methodInfo.parameterTypes[j].isAnnotationPresent(Opaque.class)) {
                    this.out.println("    jint position" + j + " = arg" + j + " == NULL ? 0 : env->GetIntField(arg" + j + ", JavaCPP_positionFID);");
                    this.out.println("    ptr" + j + " += position" + j + ";");
                    if (adapterInfo != null || prevAdapterInfo != null) {
                        this.out.println("    size" + j + " -= position" + j + ";");
                    }
                }
            } else if (methodInfo.parameterTypes[j] == String.class) {
                this.out.println("arg" + j + " == NULL ? NULL : env->GetStringUTFChars(arg" + j + ", NULL);");
                if (adapterInfo != null || prevAdapterInfo != null) {
                    this.out.println("    jint size" + j + " = 0;");
                }
            } else if (methodInfo.parameterTypes[j].isArray() && methodInfo.parameterTypes[j].getComponentType().isPrimitive()) {
                this.out.print("arg" + j + " == NULL ? NULL : ");
                String s = methodInfo.parameterTypes[j].getComponentType().getName();
                if (methodInfo.valueGetter || methodInfo.valueSetter || methodInfo.memberGetter || methodInfo.memberSetter) {
                    this.out.println("(j" + s + "*)env->GetPrimitiveArrayCritical(arg" + j + ", NULL);");
                } else {
                    s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
                    this.out.println("env->Get" + s + "ArrayElements(arg" + j + ", NULL);");
                }
                if (adapterInfo != null || prevAdapterInfo != null) {
                    this.out.println("    jint size" + j + " = arg" + j + " == NULL ? 0 : env->GetArrayLength(arg" + j + ");");
                }
            } else if (Buffer.class.isAssignableFrom(methodInfo.parameterTypes[j])) {
                this.out.println("arg" + j + " == NULL ? NULL : (" + typeName[0] + typeName[1] + ")env->GetDirectBufferAddress(arg" + j + ");");
                if (adapterInfo != null || prevAdapterInfo != null) {
                    this.out.println("    jint size" + j + " = arg" + j + " == NULL ? 0 : env->GetDirectBufferCapacity(arg" + j + ");");
                }
            } else {
                this.out.println("arg" + j + ";");
                logger.log(Level.WARNING, "Method \"" + methodInfo.method + "\" has an unsupported parameter of type \"" + methodInfo.parameterTypes[j].getCanonicalName() + "\". Compilation will most likely fail.");
            }
            if (adapterInfo != null) {
                this.usesAdapters = true;
                adapterLine = "    " + adapterInfo.name + " adapter" + j + "(";
                prevAdapterInfo = adapterInfo;
            }
            if (prevAdapterInfo != null) {
                if (!FunctionPointer.class.isAssignableFrom(methodInfo.cls)) {
                    adapterLine = adapterLine + cast;
                }
                adapterLine = adapterLine + "ptr" + j + ", size" + j;
                if (--prevAdapterInfo.argc > 0) {
                    adapterLine = adapterLine + ", ";
                }
            }
            if (prevAdapterInfo == null || prevAdapterInfo.argc > 0) continue;
            this.out.println(adapterLine + ");");
            prevAdapterInfo = null;
        }
    }

    private String doReturnBefore(MethodInformation methodInfo) {
        String returnPrefix = "";
        if (methodInfo.returnType == Void.TYPE) {
            if (methodInfo.allocator || methodInfo.arrayAllocator) {
                if (methodInfo.cls != Pointer.class) {
                    this.out.println("    if (!env->IsSameObject(env->GetObjectClass(obj), JavaCPP_getClass(env, " + this.jclasses.register(methodInfo.cls) + "))) {");
                    this.out.println("        return;");
                    this.out.println("    }");
                }
                String[] typeName = Generator.getCPPTypeName(methodInfo.cls);
                returnPrefix = typeName[0] + " rptr" + typeName[1] + " = ";
            }
        } else {
            String[] typeName = Generator.getCastedCPPTypeName(methodInfo.annotations, methodInfo.returnType);
            if (methodInfo.valueSetter || methodInfo.memberSetter || methodInfo.noReturnGetter) {
                this.out.println("    jobject rarg = obj;");
            } else if (methodInfo.returnType.isPrimitive()) {
                this.out.println("    " + Generator.getJNITypeName(methodInfo.returnType) + " rarg = 0;");
                returnPrefix = typeName[0] + " rvalue" + typeName[1] + " = ";
            } else {
                Annotation returnBy = Generator.getBy(methodInfo.annotations);
                String valueTypeName = Generator.getValueTypeName(typeName);
                returnPrefix = "rptr = ";
                if (typeName[0].length() == 0 || methodInfo.returnRaw) {
                    methodInfo.returnRaw = true;
                    typeName[0] = Generator.getJNITypeName(methodInfo.returnType);
                    this.out.println("    " + typeName[0] + " rarg = NULL;");
                    this.out.println("    " + typeName[0] + " rptr;");
                } else if (Pointer.class.isAssignableFrom(methodInfo.returnType)) {
                    if (FunctionPointer.class.isAssignableFrom(methodInfo.returnType)) {
                        typeName[0] = this.getFunctionClassName(methodInfo.returnType) + "*";
                        typeName[1] = "";
                        valueTypeName = Generator.getValueTypeName(typeName);
                        returnPrefix = "if (rptr != NULL) rptr->ptr = ";
                    }
                    if (returnBy instanceof ByVal) {
                        returnPrefix = returnPrefix + (Generator.getNoException(methodInfo.returnType, methodInfo.method) ? "new (std::nothrow) " : "new ") + valueTypeName + typeName[1] + "(";
                    } else if (returnBy instanceof ByRef) {
                        returnPrefix = returnPrefix + "&";
                    } else if (returnBy instanceof ByPtrPtr) {
                        returnPrefix = returnPrefix + "JavaCPP_dereference(env, ";
                    }
                    this.out.println("    jobject rarg = NULL;");
                    this.out.println("    " + typeName[0] + " rptr" + typeName[1] + ";");
                    if (FunctionPointer.class.isAssignableFrom(methodInfo.returnType)) {
                        this.out.println("    rptr = new (std::nothrow) " + valueTypeName + ";");
                    }
                } else if (methodInfo.returnType == String.class) {
                    this.out.println("    jstring rarg = NULL;");
                    this.out.println("    const char* rptr;");
                    returnPrefix = returnBy instanceof ByRef ? "std::string rstr(" : returnPrefix + "(const char*)";
                } else if (methodInfo.bufferGetter) {
                    this.out.println("    jobject rarg = NULL;");
                    this.out.println("    char* rptr;");
                } else {
                    logger.log(Level.WARNING, "Method \"" + methodInfo.method + "\" has unsupported return type \"" + methodInfo.returnType.getCanonicalName() + "\". Compilation will most likely fail.");
                }
                AdapterInformation adapterInfo = Generator.getAdapterInformation(false, valueTypeName, methodInfo.annotations);
                if (adapterInfo != null) {
                    this.usesAdapters = true;
                    returnPrefix = adapterInfo.name + " radapter(";
                }
            }
        }
        if (methodInfo.mayThrowException) {
            this.out.println("    try {");
        }
        return returnPrefix;
    }

    private void doCall(MethodInformation methodInfo, String returnPrefix) {
        int j;
        boolean index;
        String indent = methodInfo.mayThrowException ? "        " : "    ";
        String prefix = "(";
        String suffix = ")";
        int skipParameters = 0;
        boolean bl = index = methodInfo.method.isAnnotationPresent(Index.class) || methodInfo.pairedMethod != null && methodInfo.pairedMethod.isAnnotationPresent(Index.class);
        if (methodInfo.deallocator) {
            this.out.println(indent + "void* allocatedAddress = jlong_to_ptr(arg0);");
            this.out.println(indent + "void (*deallocatorAddress)(void*) = (void(*)(void*))jlong_to_ptr(arg1);");
            this.out.println(indent + "if (deallocatorAddress != NULL && allocatedAddress != NULL) {");
            this.out.println(indent + "    (*deallocatorAddress)(allocatedAddress);");
            this.out.println(indent + "}");
            return;
        }
        if (methodInfo.valueGetter || methodInfo.valueSetter || methodInfo.memberGetter || methodInfo.memberSetter) {
            boolean wantsPointer = false;
            int k = methodInfo.parameterTypes.length - 1;
            if ((methodInfo.valueSetter || methodInfo.memberSetter) && !(Generator.getParameterBy(methodInfo, k) instanceof ByRef) && Generator.getParameterAdapterInformation(false, methodInfo, k) == null && methodInfo.parameterTypes[k] == String.class) {
                this.out.print(indent + "strcpy((char*)");
                wantsPointer = true;
                prefix = ", ";
            } else if (k >= 1 && methodInfo.parameterTypes[0].isArray() && methodInfo.parameterTypes[0].getComponentType().isPrimitive() && (methodInfo.parameterTypes[1] == Integer.TYPE || methodInfo.parameterTypes[1] == Long.TYPE)) {
                this.out.print(indent + "memcpy(");
                wantsPointer = true;
                prefix = ", ";
                if (methodInfo.memberGetter || methodInfo.valueGetter) {
                    this.out.print("ptr0 + arg1, ");
                } else {
                    prefix = prefix + "ptr0 + arg1, ";
                }
                skipParameters = 2;
                suffix = " * sizeof(*ptr0)" + suffix;
            } else {
                this.out.print(indent + returnPrefix);
                prefix = methodInfo.valueGetter || methodInfo.memberGetter ? "" : " = ";
                suffix = "";
            }
            if (Modifier.isStatic(methodInfo.modifiers)) {
                this.out.print(Generator.getCPPScopeName(methodInfo));
            } else if (methodInfo.memberGetter || methodInfo.memberSetter) {
                if (index) {
                    this.out.print("(*ptr)");
                    prefix = "." + methodInfo.memberName[0] + prefix;
                } else {
                    this.out.print("ptr->" + methodInfo.memberName[0]);
                }
            } else {
                this.out.print(index ? "(*ptr)" : (methodInfo.dim > 0 || wantsPointer ? "ptr" : "*ptr"));
            }
        } else if (methodInfo.bufferGetter) {
            this.out.print(indent + returnPrefix + "ptr");
            prefix = "";
            suffix = "";
        } else {
            this.out.print(indent + returnPrefix);
            if (FunctionPointer.class.isAssignableFrom(methodInfo.cls)) {
                if (methodInfo.cls.isAnnotationPresent(Namespace.class)) {
                    this.out.print("(ptr0->*(ptr->ptr))");
                    skipParameters = 1;
                } else {
                    this.out.print("(*ptr->ptr)");
                }
            } else if (methodInfo.allocator) {
                String[] typeName = Generator.getCPPTypeName(methodInfo.cls);
                String valueTypeName = Generator.getValueTypeName(typeName);
                if (methodInfo.cls == Pointer.class) {
                    prefix = "";
                    suffix = "";
                } else {
                    this.out.print((Generator.getNoException(methodInfo.cls, methodInfo.method) ? "new (std::nothrow) " : "new ") + valueTypeName + typeName[1]);
                    if (methodInfo.arrayAllocator) {
                        prefix = "[";
                        suffix = "]";
                    }
                }
            } else if (Modifier.isStatic(methodInfo.modifiers)) {
                this.out.print(Generator.getCPPScopeName(methodInfo));
            } else if (index) {
                this.out.print("(*ptr)");
                prefix = "." + methodInfo.memberName[0] + prefix;
            } else {
                this.out.print("ptr->" + methodInfo.memberName[0]);
            }
        }
        for (j = skipParameters; j < methodInfo.dim; ++j) {
            String cast = Generator.getParameterCast(methodInfo, j);
            this.out.print("[" + cast + (methodInfo.parameterTypes[j].isPrimitive() ? "arg" : "ptr") + j + "]");
        }
        if (methodInfo.memberName.length > 1) {
            this.out.print(methodInfo.memberName[1]);
        }
        this.out.print(prefix);
        if (methodInfo.withEnv) {
            this.out.print(Modifier.isStatic(methodInfo.modifiers) ? "env, cls" : "env, obj");
            if (methodInfo.parameterTypes.length - skipParameters - methodInfo.dim > 0) {
                this.out.print(", ");
            }
        }
        for (j = skipParameters + methodInfo.dim; j < methodInfo.parameterTypes.length; ++j) {
            Annotation passBy = Generator.getParameterBy(methodInfo, j);
            String cast = Generator.getParameterCast(methodInfo, j);
            AdapterInformation adapterInfo = Generator.getParameterAdapterInformation(false, methodInfo, j);
            if (("(void*)".equals(cast) || "(void *)".equals(cast)) && methodInfo.parameterTypes[j] == Long.TYPE) {
                this.out.print("jlong_to_ptr(arg" + j + ")");
            } else if (methodInfo.parameterTypes[j].isPrimitive()) {
                this.out.print(cast + "arg" + j);
            } else if (adapterInfo != null) {
                cast = adapterInfo.cast.trim();
                if (cast.length() > 0 && !cast.startsWith("(") && !cast.endsWith(")")) {
                    cast = "(" + cast + ")";
                }
                this.out.print(cast + "adapter" + j);
                j += adapterInfo.argc - 1;
            } else if (FunctionPointer.class.isAssignableFrom(methodInfo.parameterTypes[j]) && passBy == null) {
                this.out.print(cast + "(ptr" + j + " == NULL ? NULL : ptr" + j + "->ptr)");
            } else if (passBy instanceof ByVal || passBy instanceof ByRef && methodInfo.parameterTypes[j] != String.class) {
                this.out.print("*" + cast + "ptr" + j);
            } else if (passBy instanceof ByPtrPtr) {
                this.out.print(cast + "(arg" + j + " == NULL ? NULL : &ptr" + j + ")");
            } else {
                this.out.print(cast + "ptr" + j);
            }
            if (j >= methodInfo.parameterTypes.length - 1) continue;
            this.out.print(", ");
        }
        this.out.print(suffix);
        if (methodInfo.memberName.length > 2) {
            this.out.print(methodInfo.memberName[2]);
        }
        if (Generator.getBy(methodInfo.annotations) instanceof ByRef && methodInfo.returnType == String.class) {
            this.out.print(");\n" + indent + "rptr = rstr.c_str()");
        }
    }

    private void doReturnAfter(MethodInformation methodInfo) {
        String indent;
        String[] typeName = Generator.getCastedCPPTypeName(methodInfo.annotations, methodInfo.returnType);
        Annotation returnBy = Generator.getBy(methodInfo.annotations);
        String valueTypeName = Generator.getValueTypeName(typeName);
        AdapterInformation adapterInfo = Generator.getAdapterInformation(false, valueTypeName, methodInfo.annotations);
        if (!methodInfo.returnType.isPrimitive() && adapterInfo != null) {
            this.out.print(")");
        }
        if (Pointer.class.isAssignableFrom(methodInfo.returnType) && (returnBy instanceof ByVal || returnBy instanceof ByPtrPtr)) {
            this.out.print(")");
        }
        if (!methodInfo.deallocator) {
            this.out.println(";");
        }
        String string = indent = methodInfo.mayThrowException ? "        " : "    ";
        if (methodInfo.returnType == Void.TYPE) {
            if (methodInfo.allocator || methodInfo.arrayAllocator) {
                this.out.println(indent + "jint rcapacity = " + (methodInfo.arrayAllocator ? "arg0;" : "1;"));
                boolean noDeallocator = methodInfo.cls.isAnnotationPresent(NoDeallocator.class);
                for (Annotation a : methodInfo.annotations) {
                    if (!(a instanceof NoDeallocator)) continue;
                    noDeallocator = true;
                    break;
                }
                if (!noDeallocator) {
                    this.out.println(indent + "jvalue args[3];");
                    this.out.println(indent + "args[0].j = ptr_to_jlong(rptr);");
                    this.out.println(indent + "args[1].i = rcapacity;");
                    this.out.print(indent + "args[2].j = ptr_to_jlong(&JavaCPP_" + Generator.mangle(methodInfo.cls.getName()));
                    if (methodInfo.arrayAllocator) {
                        this.out.println("_deallocateArray);");
                        this.arrayDeallocators.register(methodInfo.cls);
                    } else {
                        this.out.println("_deallocate);");
                        this.deallocators.register(methodInfo.cls);
                    }
                    this.out.println(indent + "env->CallNonvirtualVoidMethodA(obj, JavaCPP_getClass(env, " + this.jclasses.register(Pointer.class) + "), JavaCPP_initMID, args);");
                } else {
                    this.out.println(indent + "env->SetLongField(obj, JavaCPP_addressFID, ptr_to_jlong(rptr));");
                    this.out.println(indent + "env->SetIntField(obj, JavaCPP_limitFID, rcapacity);");
                    this.out.println(indent + "env->SetIntField(obj, JavaCPP_capacityFID, rcapacity);");
                }
            }
        } else if (!(methodInfo.valueSetter || methodInfo.memberSetter || methodInfo.noReturnGetter)) {
            if (methodInfo.returnType.isPrimitive()) {
                this.out.println(indent + "rarg = (" + Generator.getJNITypeName(methodInfo.returnType) + ")rvalue;");
            } else if (methodInfo.returnRaw) {
                this.out.println(indent + "rarg = rptr;");
            } else {
                boolean needInit = false;
                if (adapterInfo != null) {
                    this.out.println(indent + "rptr = radapter;");
                    if (methodInfo.returnType != String.class) {
                        this.out.println(indent + "jint rcapacity = (jint)radapter.size;");
                        this.out.println(indent + "jlong deallocator = " + (adapterInfo.constant ? "0;" : "ptr_to_jlong(&(" + adapterInfo.name + "::deallocate));"));
                    }
                    needInit = true;
                } else if (returnBy instanceof ByVal || FunctionPointer.class.isAssignableFrom(methodInfo.returnType)) {
                    this.out.println(indent + "jint rcapacity = 1;");
                    this.out.println(indent + "jlong deallocator = ptr_to_jlong(&JavaCPP_" + Generator.mangle(methodInfo.returnType.getName()) + "_deallocate);");
                    this.deallocators.register(methodInfo.returnType);
                    needInit = true;
                }
                if (Pointer.class.isAssignableFrom(methodInfo.returnType)) {
                    this.out.print(indent);
                    if (!(returnBy instanceof ByVal)) {
                        if (Modifier.isStatic(methodInfo.modifiers) && methodInfo.parameterTypes.length > 0) {
                            for (int i = 0; i < methodInfo.parameterTypes.length; ++i) {
                                String cast = Generator.getParameterCast(methodInfo, i);
                                if (methodInfo.parameterTypes[i] != methodInfo.returnType) continue;
                                this.out.println("if (rptr == " + cast + "ptr" + i + ") {");
                                this.out.println(indent + "    rarg = arg" + i + ";");
                                this.out.print(indent + "} else ");
                            }
                        } else if (!Modifier.isStatic(methodInfo.modifiers) && methodInfo.cls == methodInfo.returnType) {
                            this.out.println("if (rptr == ptr) {");
                            this.out.println(indent + "    rarg = obj;");
                            this.out.print(indent + "} else ");
                        }
                    }
                    this.out.println("if (rptr != NULL) {");
                    this.out.println(indent + "    rarg = env->AllocObject(JavaCPP_getClass(env, " + this.jclasses.register(methodInfo.returnType) + "));");
                    if (needInit) {
                        this.out.println(indent + "    if (deallocator != 0) {");
                        this.out.println(indent + "        jvalue args[3];");
                        this.out.println(indent + "        args[0].j = ptr_to_jlong(rptr);");
                        this.out.println(indent + "        args[1].i = rcapacity;");
                        this.out.println(indent + "        args[2].j = deallocator;");
                        this.out.println(indent + "        env->CallNonvirtualVoidMethodA(rarg, JavaCPP_getClass(env, " + this.jclasses.register(Pointer.class) + "), JavaCPP_initMID, args);");
                        this.out.println(indent + "    } else {");
                        this.out.println(indent + "        env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));");
                        this.out.println(indent + "        env->SetIntField(rarg, JavaCPP_limitFID, rcapacity);");
                        this.out.println(indent + "        env->SetIntField(rarg, JavaCPP_capacityFID, rcapacity);");
                        this.out.println(indent + "    }");
                    } else {
                        this.out.println(indent + "    env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));");
                    }
                    this.out.println(indent + "}");
                } else if (methodInfo.returnType == String.class) {
                    this.out.println(indent + "if (rptr != NULL) {");
                    this.out.println(indent + "    rarg = env->NewStringUTF(rptr);");
                    this.out.println(indent + "}");
                } else if (methodInfo.bufferGetter) {
                    this.out.println(indent + "if (rptr != NULL) {");
                    this.out.println(indent + "    rarg = env->NewDirectByteBuffer(rptr, size);");
                    this.out.println(indent + "}");
                }
            }
        }
    }

    private void doParametersAfter(MethodInformation methodInfo) {
        String indent = methodInfo.mayThrowException ? "        " : "    ";
        for (int j = 0; j < methodInfo.parameterTypes.length; ++j) {
            if (methodInfo.parameterRaw[j]) continue;
            Annotation passBy = Generator.getParameterBy(methodInfo, j);
            String cast = Generator.getParameterCast(methodInfo, j);
            String[] typeName = Generator.getCastedCPPTypeName(methodInfo.parameterAnnotations[j], methodInfo.parameterTypes[j]);
            AdapterInformation adapterInfo = Generator.getParameterAdapterInformation(true, methodInfo, j);
            if (Pointer.class.isAssignableFrom(methodInfo.parameterTypes[j])) {
                if (adapterInfo != null) {
                    for (int k = 0; k < adapterInfo.argc; ++k) {
                        this.out.println(indent + typeName[0] + " rptr" + (j + k) + typeName[1] + " = " + cast + "adapter" + j + ";");
                        this.out.println(indent + "jint rsize" + (j + k) + " = (jint)adapter" + j + ".size" + (k > 0 ? k + 1 + ";" : ";"));
                        this.out.println(indent + "if (rptr" + (j + k) + " != " + cast + "ptr" + (j + k) + ") {");
                        this.out.println(indent + "    jvalue args[3];");
                        this.out.println(indent + "    args[0].j = ptr_to_jlong(rptr" + (j + k) + ");");
                        this.out.println(indent + "    args[1].i = rsize" + (j + k) + ";");
                        this.out.println(indent + "    args[2].j = ptr_to_jlong(&(" + adapterInfo.name + "::deallocate));");
                        this.out.println(indent + "    env->CallNonvirtualVoidMethodA(arg" + j + ", JavaCPP_getClass(env, " + this.jclasses.register(Pointer.class) + "), JavaCPP_initMID, args);");
                        this.out.println(indent + "} else {");
                        this.out.println(indent + "    env->SetIntField(arg" + j + ", JavaCPP_limitFID, rsize" + (j + k) + " + position" + (j + k) + ");");
                        this.out.println(indent + "}");
                    }
                    continue;
                }
                if (!(passBy instanceof ByPtrPtr) && !(passBy instanceof ByPtrRef) || methodInfo.valueSetter || methodInfo.memberSetter) continue;
                if (!methodInfo.parameterTypes[j].isAnnotationPresent(Opaque.class)) {
                    this.out.println(indent + "ptr" + j + " -= position" + j + ";");
                }
                this.out.println(indent + "if (arg" + j + " != NULL) env->SetLongField(arg" + j + ", JavaCPP_addressFID, ptr_to_jlong(ptr" + j + "));");
                continue;
            }
            if (methodInfo.parameterTypes[j] == String.class) {
                this.out.println(indent + "if (arg" + j + " != NULL) env->ReleaseStringUTFChars(arg" + j + ", ptr" + j + ");");
                continue;
            }
            if (!methodInfo.parameterTypes[j].isArray() || !methodInfo.parameterTypes[j].getComponentType().isPrimitive()) continue;
            this.out.print(indent + "if (arg" + j + " != NULL) ");
            String s = methodInfo.parameterTypes[j].getComponentType().getName();
            if (methodInfo.valueGetter || methodInfo.valueSetter || methodInfo.memberGetter || methodInfo.memberSetter) {
                this.out.println("env->ReleasePrimitiveArrayCritical(arg" + j + ", ptr" + j + ", 0);");
                continue;
            }
            s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
            this.out.println("env->Release" + s + "ArrayElements(arg" + j + ", ptr" + j + ", 0);");
        }
        if (methodInfo.mayThrowException) {
            this.mayThrowExceptions = true;
            this.out.println("    } catch (...) {");
            this.out.println("        JavaCPP_handleException(env);");
            this.out.println("    }");
        }
    }

    private void doCallback(Class<?> cls, Method callbackMethod, String callbackName, boolean needFunctor) {
        String[] typeName;
        Class<?> callbackReturnType = callbackMethod.getReturnType();
        Class<?>[] callbackParameterTypes = callbackMethod.getParameterTypes();
        Annotation[] callbackAnnotations = callbackMethod.getAnnotations();
        Annotation[][] callbackParameterAnnotations = callbackMethod.getParameterAnnotations();
        String instanceTypeName = this.getFunctionClassName(cls);
        String[] callbackTypeName = Generator.getCPPTypeName(cls);
        String[] returnConvention = callbackTypeName[0].split("\\(");
        returnConvention[1] = Generator.getValueTypeName(returnConvention[1]);
        String parameterDeclaration = callbackTypeName[1].substring(1);
        this.functionPointers.register("static " + instanceTypeName + " " + callbackName + "_instance;");
        this.jclassesInit.register(cls);
        if (this.out2 != null) {
            this.out2.println("JNIIMPORT " + returnConvention[0] + (returnConvention.length > 1 ? returnConvention[1] : "") + callbackName + parameterDeclaration + ";");
        }
        this.out.println("JNIEXPORT " + returnConvention[0] + (returnConvention.length > 1 ? returnConvention[1] : "") + callbackName + parameterDeclaration + " {");
        this.out.print((callbackReturnType != Void.TYPE ? "    return " : "    ") + callbackName + "_instance(");
        for (int j = 0; j < callbackParameterTypes.length; ++j) {
            this.out.print("arg" + j);
            if (j >= callbackParameterTypes.length - 1) continue;
            this.out.print(", ");
        }
        this.out.println(");");
        this.out.println("}");
        if (!needFunctor) {
            return;
        }
        this.out.println(returnConvention[0] + instanceTypeName + "::operator()" + parameterDeclaration + " {");
        String returnPrefix = "";
        if (callbackReturnType != Void.TYPE) {
            this.out.println("    " + Generator.getJNITypeName(callbackReturnType) + " rarg = 0;");
            returnPrefix = "rarg = ";
        }
        String callbackReturnCast = Generator.getCast(callbackAnnotations, callbackReturnType);
        Annotation returnBy = Generator.getBy(callbackAnnotations);
        String[] returnTypeName = Generator.getCPPTypeName(callbackReturnType);
        String returnValueTypeName = Generator.getValueTypeName(returnTypeName);
        AdapterInformation returnAdapterInfo = Generator.getAdapterInformation(false, returnValueTypeName, callbackAnnotations);
        this.out.println("    jthrowable exc = NULL;");
        this.out.println("    JNIEnv* env;");
        this.out.println("    int attached = JavaCPP_getEnv(&env);");
        this.out.println("    if (attached < 0) {");
        this.out.println("        goto end;");
        this.out.println("    }");
        this.out.println("{");
        if (callbackParameterTypes.length > 0) {
            this.out.println("    jvalue args[" + callbackParameterTypes.length + "];");
            for (int j = 0; j < callbackParameterTypes.length; ++j) {
                if (callbackParameterTypes[j].isPrimitive()) {
                    this.out.println("    args[" + j + "]." + Generator.getSignature(callbackParameterTypes[j]).toLowerCase() + " = (" + Generator.getJNITypeName(callbackParameterTypes[j]) + ")arg" + j + ";");
                    continue;
                }
                Annotation passBy = Generator.getBy(callbackParameterAnnotations[j]);
                typeName = Generator.getCPPTypeName(callbackParameterTypes[j]);
                String valueTypeName = Generator.getValueTypeName(typeName);
                AdapterInformation adapterInfo = Generator.getAdapterInformation(false, valueTypeName, callbackParameterAnnotations[j]);
                if (adapterInfo == null) {
                    typeName = Generator.getCastedCPPTypeName(callbackParameterAnnotations[j], callbackParameterTypes[j]);
                    valueTypeName = Generator.getValueTypeName(typeName);
                }
                boolean needInit = false;
                if (adapterInfo != null) {
                    this.usesAdapters = true;
                    this.out.println("    " + adapterInfo.name + " adapter" + j + "(arg" + j + ");");
                    this.out.println("    jint size" + j + " = (jint)adapter" + j + ".size;");
                    this.out.println("    jlong deallocator" + j + " = ptr_to_jlong(&(" + adapterInfo.name + "::deallocate));");
                    needInit = true;
                } else if (passBy instanceof ByVal && callbackParameterTypes[j] != Pointer.class || FunctionPointer.class.isAssignableFrom(callbackParameterTypes[j])) {
                    this.out.println("    jint size" + j + " = 1;");
                    this.out.println("    jlong deallocator" + j + " = ptr_to_jlong(&JavaCPP_" + Generator.mangle(callbackParameterTypes[j].getName()) + "_deallocate);");
                    this.deallocators.register(callbackParameterTypes[j]);
                    needInit = true;
                }
                if (Pointer.class.isAssignableFrom(callbackParameterTypes[j])) {
                    if (FunctionPointer.class.isAssignableFrom(callbackParameterTypes[j])) {
                        typeName[0] = this.getFunctionClassName(callbackParameterTypes[j]) + "*";
                        typeName[1] = "";
                        valueTypeName = Generator.getValueTypeName(typeName);
                    }
                    this.out.println("    jobject obj" + j + " = NULL;");
                    this.out.println("    " + typeName[0] + " ptr" + j + typeName[1] + " = NULL;");
                    if (FunctionPointer.class.isAssignableFrom(callbackParameterTypes[j])) {
                        this.out.println("    ptr" + j + " = new (std::nothrow) " + valueTypeName + ";");
                        this.out.println("    if (ptr" + j + " != NULL) {");
                        this.out.println("        ptr" + j + "->ptr = arg" + j + ";");
                        this.out.println("    }");
                    } else if (adapterInfo != null) {
                        this.out.println("    ptr" + j + " = adapter" + j + ";");
                    } else if (passBy instanceof ByVal && callbackParameterTypes[j] != Pointer.class) {
                        this.out.println("    ptr" + j + (Generator.getNoException(callbackParameterTypes[j], callbackMethod) ? " = new (std::nothrow) " : " = new ") + valueTypeName + typeName[1] + "(*(" + typeName[0] + typeName[1] + ")&arg" + j + ");");
                    } else if (passBy instanceof ByVal || passBy instanceof ByRef) {
                        this.out.println("    ptr" + j + " = (" + typeName[0] + typeName[1] + ")&arg" + j + ";");
                    } else if (passBy instanceof ByPtrPtr) {
                        this.out.println("    if (arg" + j + " == NULL) {");
                        this.out.println("        JavaCPP_log(\"Pointer address of argument " + j + " is NULL in callback for " + cls.getCanonicalName() + ".\");");
                        this.out.println("    } else {");
                        this.out.println("        ptr" + j + " = *arg" + j + ";");
                        this.out.println("    }");
                    } else {
                        this.out.println("    ptr" + j + " = arg" + j + ";");
                    }
                    String s = "    obj" + j + " = env->AllocObject(JavaCPP_getClass(env, " + this.jclasses.register(callbackParameterTypes[j]) + "));";
                    this.jclassesInit.register(callbackParameterTypes[j]);
                    adapterInfo = Generator.getAdapterInformation(true, valueTypeName, callbackParameterAnnotations[j]);
                    if (adapterInfo != null || passBy instanceof ByPtrPtr || passBy instanceof ByPtrRef) {
                        this.out.println(s);
                    } else {
                        this.out.println("    if (ptr" + j + " != NULL) { ");
                        this.out.println("    " + s);
                        this.out.println("    }");
                    }
                    this.out.println("    if (obj" + j + " != NULL) { ");
                    if (needInit) {
                        this.out.println("        if (deallocator" + j + " != 0) {");
                        this.out.println("            jvalue args[3];");
                        this.out.println("            args[0].j = ptr_to_jlong(ptr" + j + ");");
                        this.out.println("            args[1].i = size" + j + ";");
                        this.out.println("            args[2].j = deallocator" + j + ";");
                        this.out.println("            env->CallNonvirtualVoidMethodA(obj" + j + ", JavaCPP_getClass(env, " + this.jclasses.register(Pointer.class) + "), JavaCPP_initMID, args);");
                        this.out.println("        } else {");
                        this.out.println("            env->SetLongField(obj" + j + ", JavaCPP_addressFID, ptr_to_jlong(ptr" + j + "));");
                        this.out.println("            env->SetIntField(obj" + j + ", JavaCPP_limitFID, size" + j + ");");
                        this.out.println("            env->SetIntField(obj" + j + ", JavaCPP_capacityFID, size" + j + ");");
                        this.out.println("        }");
                    } else {
                        this.out.println("        env->SetLongField(obj" + j + ", JavaCPP_addressFID, ptr_to_jlong(ptr" + j + "));");
                    }
                    this.out.println("    }");
                    this.out.println("    args[" + j + "].l = obj" + j + ";");
                    continue;
                }
                if (callbackParameterTypes[j] == String.class) {
                    this.out.println("    jstring obj" + j + " = arg" + j + " == NULL ? NULL : env->NewStringUTF((const char*)" + (adapterInfo != null ? "adapter" : "arg") + j + ");");
                    this.out.println("    args[" + j + "].l = obj" + j + ";");
                    continue;
                }
                logger.log(Level.WARNING, "Callback \"" + callbackMethod + "\" has unsupported parameter type \"" + callbackParameterTypes[j].getCanonicalName() + "\". Compilation will most likely fail.");
            }
        }
        this.out.println("    if (obj == NULL) {");
        this.out.println("        obj = env->NewGlobalRef(env->AllocObject(JavaCPP_getClass(env, " + this.jclasses.register(cls) + ")));");
        this.out.println("        if (obj == NULL) {");
        this.out.println("            JavaCPP_log(\"Error creating global reference of " + cls.getCanonicalName() + " instance for callback.\");");
        this.out.println("        } else {");
        this.out.println("            env->SetLongField(obj, JavaCPP_addressFID, ptr_to_jlong(this));");
        this.out.println("        }");
        this.out.println("        ptr = &" + callbackName + ";");
        this.out.println("    }");
        this.out.println("    if (mid == NULL) {");
        this.out.println("        mid = env->GetMethodID(JavaCPP_getClass(env, " + this.jclasses.register(cls) + "), \"" + callbackMethod.getName() + "\", \"(" + Generator.getSignature(callbackMethod.getParameterTypes()) + ")" + Generator.getSignature(callbackMethod.getReturnType()) + "\");");
        this.out.println("    }");
        this.out.println("    if (env->IsSameObject(obj, NULL)) {");
        this.out.println("        JavaCPP_log(\"Function pointer object is NULL in callback for " + cls.getCanonicalName() + ".\");");
        this.out.println("    } else if (mid == NULL) {");
        this.out.println("        JavaCPP_log(\"Error getting method ID of function caller \\\"" + callbackMethod + "\\\" for callback.\");");
        this.out.println("    } else {");
        String s = "Object";
        if (callbackReturnType.isPrimitive()) {
            s = callbackReturnType.getName();
            s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
        }
        this.out.println("        " + returnPrefix + "env->Call" + s + "MethodA(obj, mid, " + (callbackParameterTypes.length == 0 ? "NULL);" : "args);"));
        this.out.println("        if ((exc = env->ExceptionOccurred()) != NULL) {");
        this.out.println("            env->ExceptionClear();");
        this.out.println("        }");
        this.out.println("    }");
        for (int j = 0; j < callbackParameterTypes.length; ++j) {
            if (Pointer.class.isAssignableFrom(callbackParameterTypes[j])) {
                typeName = Generator.getCastedCPPTypeName(callbackParameterAnnotations[j], callbackParameterTypes[j]);
                Annotation passBy = Generator.getBy(callbackParameterAnnotations[j]);
                String valueTypeName = Generator.getValueTypeName(typeName);
                AdapterInformation adapterInfo = Generator.getAdapterInformation(true, valueTypeName, callbackParameterAnnotations[j]);
                if (adapterInfo != null || passBy instanceof ByPtrPtr || passBy instanceof ByPtrRef) {
                    this.out.println("    " + typeName[0] + " rptr" + j + typeName[1] + " = (" + typeName[0] + typeName[1] + ")jlong_to_ptr(env->GetLongField(obj" + j + ", JavaCPP_addressFID));");
                    if (adapterInfo != null) {
                        this.out.println("    jint rsize" + j + " = env->GetIntField(obj" + j + ", JavaCPP_limitFID);");
                    }
                    if (!callbackParameterTypes[j].isAnnotationPresent(Opaque.class)) {
                        this.out.println("    jint rposition" + j + " = env->GetIntField(obj" + j + ", JavaCPP_positionFID);");
                        this.out.println("    rptr" + j + " += rposition" + j + ";");
                        if (adapterInfo != null) {
                            this.out.println("    rsize" + j + " -= rposition" + j + ";");
                        }
                    }
                    if (adapterInfo != null) {
                        this.out.println("    adapter" + j + ".assign(rptr" + j + ", rsize" + j + ");");
                    } else if (passBy instanceof ByPtrPtr) {
                        this.out.println("    *arg" + j + " = rptr" + j + ";");
                    } else if (passBy instanceof ByPtrRef) {
                        this.out.println("    arg" + j + " = rptr" + j + ";");
                    }
                }
            }
            if (callbackParameterTypes[j].isPrimitive()) continue;
            this.out.println("    env->DeleteLocalRef(obj" + j + ");");
        }
        this.out.println("}");
        this.out.println("end:");
        if (callbackReturnType != Void.TYPE) {
            if (Pointer.class.isAssignableFrom(callbackReturnType)) {
                this.out.println("    " + returnTypeName[0] + " rptr" + returnTypeName[1] + " = rarg == NULL ? NULL : (" + returnTypeName[0] + returnTypeName[1] + ")jlong_to_ptr(env->GetLongField(rarg, JavaCPP_addressFID));");
                if (returnAdapterInfo != null) {
                    this.out.println("    jint rsize = rarg == NULL ? 0 : env->GetIntField(rarg, JavaCPP_limitFID);");
                }
                if (!callbackReturnType.isAnnotationPresent(Opaque.class)) {
                    this.out.println("    jint rposition = rarg == NULL ? 0 : env->GetIntField(rarg, JavaCPP_positionFID);");
                    this.out.println("    rptr += rposition;");
                    if (returnAdapterInfo != null) {
                        this.out.println("    rsize -= rposition;");
                    }
                }
            } else if (Buffer.class.isAssignableFrom(callbackReturnType)) {
                this.out.println("    " + returnTypeName[0] + " rptr" + returnTypeName[1] + " = rarg == NULL ? NULL : env->GetDirectBufferAddress(rarg);");
                if (returnAdapterInfo != null) {
                    this.out.println("    jint rsize = rarg == NULL ? 0 : env->GetDirectBufferCapacity(rarg);");
                }
            } else if (!callbackReturnType.isPrimitive()) {
                logger.log(Level.WARNING, "Callback \"" + callbackMethod + "\" has unsupported return type \"" + callbackReturnType.getCanonicalName() + "\". Compilation will most likely fail.");
            }
        }
        this.out.println("    if (exc != NULL) {");
        this.out.println("        jclass cls = env->GetObjectClass(exc);");
        this.out.println("        jmethodID mid = env->GetMethodID(cls, \"toString\", \"()Ljava/lang/String;\");");
        this.out.println("        env->DeleteLocalRef(cls);");
        this.out.println("        jstring str = (jstring)env->CallObjectMethod(exc, mid);");
        this.out.println("        env->DeleteLocalRef(exc);");
        this.out.println("        const char *msg = env->GetStringUTFChars(str, NULL);");
        this.out.println("        JavaCPP_exception e(msg);");
        this.out.println("        env->ReleaseStringUTFChars(str, msg);");
        this.out.println("        env->DeleteLocalRef(str);");
        this.out.println("        JavaCPP_detach(attached);");
        this.out.println("        throw e;");
        this.out.println("    } else {");
        this.out.println("        JavaCPP_detach(attached);");
        this.out.println("    }");
        if (callbackReturnType != Void.TYPE) {
            if (callbackReturnType.isPrimitive()) {
                this.out.println("    return " + callbackReturnCast + "rarg;");
            } else if (returnAdapterInfo != null) {
                this.usesAdapters = true;
                this.out.println("    return " + returnAdapterInfo.name + "(" + callbackReturnCast + "rptr, rsize);");
            } else if (FunctionPointer.class.isAssignableFrom(callbackReturnType)) {
                this.out.println("    return " + callbackReturnCast + "(rptr == NULL ? NULL : rptr->ptr);");
            } else if (returnBy instanceof ByVal || returnBy instanceof ByRef) {
                this.out.println("    if (rptr == NULL) {");
                this.out.println("        JavaCPP_log(\"Return pointer address is NULL in callback for " + cls.getCanonicalName() + ".\");");
                this.out.println("        static " + returnValueTypeName + " empty" + returnTypeName[1] + ";");
                this.out.println("        return empty;");
                this.out.println("    } else {");
                this.out.println("        return *" + callbackReturnCast + "rptr;");
                this.out.println("    }");
            } else if (returnBy instanceof ByPtrPtr) {
                this.out.println("    return " + callbackReturnCast + "&rptr;");
            } else {
                this.out.println("    return " + callbackReturnCast + "rptr;");
            }
        }
        this.out.println("}");
    }

    private void doCallbackAllocator(Class cls, String callbackName) {
        String instanceTypeName = this.getFunctionClassName(cls);
        this.out.println("    obj = env->NewWeakGlobalRef(obj);");
        this.out.println("    if (obj == NULL) {");
        this.out.println("        JavaCPP_log(\"Error creating global reference of " + cls.getCanonicalName() + " instance for callback.\");");
        this.out.println("        return;");
        this.out.println("    }");
        this.out.println("    " + instanceTypeName + "* rptr = new (std::nothrow) " + instanceTypeName + ";");
        this.out.println("    if (rptr != NULL) {");
        this.out.println("        rptr->ptr = &" + callbackName + ";");
        this.out.println("        rptr->obj = obj;");
        this.out.println("        jvalue args[3];");
        this.out.println("        args[0].j = ptr_to_jlong(rptr);");
        this.out.println("        args[1].i = 1;");
        this.out.println("        args[2].j = ptr_to_jlong(&JavaCPP_" + Generator.mangle(cls.getName()) + "_deallocate);");
        this.deallocators.register(cls);
        this.out.println("        env->CallNonvirtualVoidMethodA(obj, JavaCPP_getClass(env, " + this.jclasses.register(Pointer.class) + "), JavaCPP_initMID, args);");
        this.out.println("        " + callbackName + "_instance = *rptr;");
        this.out.println("    }");
        this.out.println("}");
    }

    public boolean checkPlatform(Platform platform) {
        if (platform == null) {
            return true;
        }
        String platformName = this.properties.getProperty("platform.name");
        String[][] names = new String[][]{platform.value(), platform.not()};
        boolean[] matches = new boolean[]{false, false};
        block0: for (int i = 0; i < names.length; ++i) {
            for (String s : names[i]) {
                if (!platformName.startsWith(s)) continue;
                matches[i] = true;
                continue block0;
            }
        }
        return !(names[0].length != 0 && !matches[0] || names[1].length != 0 && matches[1]);
    }

    private String getFunctionClassName(Class<?> cls) {
        Name name = cls.getAnnotation(Name.class);
        return name != null ? name.value()[0] : "JavaCPP_" + Generator.mangle(cls.getName());
    }

    private static Method getFunctionMethod(Class<?> cls, boolean[] callbackAllocators) {
        if (!FunctionPointer.class.isAssignableFrom(cls)) {
            return null;
        }
        Method[] methods = cls.getDeclaredMethods();
        Method functionMethod = null;
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            int modifiers = methods[i].getModifiers();
            Class<?>[] parameterTypes = methods[i].getParameterTypes();
            Class<?> returnType = methods[i].getReturnType();
            if (Modifier.isStatic(modifiers)) continue;
            if (callbackAllocators != null && methodName.startsWith("allocate") && Modifier.isNative(modifiers) && returnType == Void.TYPE && parameterTypes.length == 0) {
                callbackAllocators[i] = true;
                continue;
            }
            if (!methodName.startsWith("call") && !methodName.startsWith("apply")) continue;
            functionMethod = methods[i];
        }
        return functionMethod;
    }

    public static MethodInformation getMethodInformation(Method method) {
        String[] stringArray;
        if (!Modifier.isNative(method.getModifiers())) {
            return null;
        }
        MethodInformation info = new MethodInformation();
        info.cls = method.getDeclaringClass();
        info.method = method;
        info.annotations = method.getAnnotations();
        info.modifiers = method.getModifiers();
        info.returnType = method.getReturnType();
        info.name = method.getName();
        Name name = method.getAnnotation(Name.class);
        if (name != null) {
            stringArray = name.value();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = info.name;
        }
        info.memberName = stringArray;
        Index index = method.getAnnotation(Index.class);
        info.dim = index != null ? index.value() : 0;
        info.parameterTypes = method.getParameterTypes();
        info.parameterAnnotations = method.getParameterAnnotations();
        info.returnRaw = method.isAnnotationPresent(Raw.class);
        info.withEnv = info.returnRaw ? method.getAnnotation(Raw.class).withEnv() : false;
        info.parameterRaw = new boolean[info.parameterAnnotations.length];
        for (int i = 0; i < info.parameterAnnotations.length; ++i) {
            for (int j = 0; j < info.parameterAnnotations[i].length; ++j) {
                if (!(info.parameterAnnotations[i][j] instanceof Raw)) continue;
                info.parameterRaw[i] = true;
                info.withEnv |= ((Raw)info.parameterAnnotations[i][j]).withEnv();
            }
        }
        boolean canBeGetter = info.returnType != Void.TYPE || info.parameterTypes.length > 0 && info.parameterTypes[0].isArray() && info.parameterTypes[0].getComponentType().isPrimitive();
        boolean canBeSetter = (info.returnType == Void.TYPE || info.returnType == info.cls) && info.parameterTypes.length > 0;
        boolean canBeAllocator = !Modifier.isStatic(info.modifiers) && info.returnType == Void.TYPE;
        boolean canBeArrayAllocator = canBeAllocator && info.parameterTypes.length == 1 && (info.parameterTypes[0] == Integer.TYPE || info.parameterTypes[0] == Long.TYPE);
        boolean valueGetter = false;
        boolean valueSetter = false;
        boolean memberGetter = false;
        boolean memberSetter = false;
        boolean noReturnGetter = false;
        Method pairedMethod = null;
        Method[] methods = info.cls.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            boolean parameterAsReturn2;
            Method method2 = methods[i];
            int modifiers2 = method2.getModifiers();
            Class<?> returnType2 = method2.getReturnType();
            String methodName2 = method2.getName();
            Class<?>[] parameterTypes2 = method2.getParameterTypes();
            if (method.equals(method2) || !Modifier.isNative(modifiers2)) continue;
            boolean canBeValueGetter = false;
            boolean canBeValueSetter = false;
            if (canBeGetter && "get".equals(info.name) && "put".equals(methodName2)) {
                canBeValueGetter = true;
            } else if (canBeSetter && "put".equals(info.name) && "get".equals(methodName2)) {
                canBeValueSetter = true;
            } else {
                if (!methodName2.equals(info.name)) continue;
                info.overloaded = true;
            }
            boolean sameIndexParameters = true;
            for (int j = 0; j < info.parameterTypes.length && j < parameterTypes2.length; ++j) {
                if (info.parameterTypes[j] == parameterTypes2[j]) continue;
                sameIndexParameters = false;
            }
            if (!sameIndexParameters) continue;
            boolean parameterAsReturn = canBeValueGetter && info.parameterTypes.length > 0 && info.parameterTypes[0].isArray() && info.parameterTypes[0].getComponentType().isPrimitive();
            boolean bl = parameterAsReturn2 = canBeValueSetter && parameterTypes2.length > 0 && parameterTypes2[0].isArray() && parameterTypes2[0].getComponentType().isPrimitive();
            if (canBeGetter && parameterTypes2.length - (parameterAsReturn ? 0 : 1) == info.parameterTypes.length && (parameterAsReturn ? info.parameterTypes[info.parameterTypes.length - 1] : info.returnType) == parameterTypes2[parameterTypes2.length - 1] && (returnType2 == Void.TYPE || returnType2 == info.cls)) {
                pairedMethod = method2;
                valueGetter = canBeValueGetter;
                memberGetter = !canBeValueGetter;
                noReturnGetter = parameterAsReturn;
                continue;
            }
            if (!canBeSetter || info.parameterTypes.length - (parameterAsReturn2 ? 0 : 1) != parameterTypes2.length || (parameterAsReturn2 ? parameterTypes2[parameterTypes2.length - 1] : returnType2) != info.parameterTypes[info.parameterTypes.length - 1]) continue;
            pairedMethod = method2;
            valueSetter = canBeValueSetter;
            memberSetter = !canBeValueSetter;
        }
        Annotation behavior = Generator.getBehavior(info.annotations);
        if (canBeGetter && behavior instanceof ValueGetter) {
            info.valueGetter = true;
            info.noReturnGetter = noReturnGetter;
        } else if (canBeSetter && behavior instanceof ValueSetter) {
            info.valueSetter = true;
        } else if (canBeGetter && behavior instanceof MemberGetter) {
            info.memberGetter = true;
            info.noReturnGetter = noReturnGetter;
        } else if (canBeSetter && behavior instanceof MemberSetter) {
            info.memberSetter = true;
        } else if (canBeAllocator && behavior instanceof Allocator) {
            info.allocator = true;
        } else if (canBeArrayAllocator && behavior instanceof ArrayAllocator) {
            info.arrayAllocator = true;
            info.allocator = true;
        } else if (behavior == null) {
            if (info.returnType == Void.TYPE && "deallocate".equals(info.name) && !Modifier.isStatic(info.modifiers) && info.parameterTypes.length == 2 && info.parameterTypes[0] == Long.TYPE && info.parameterTypes[1] == Long.TYPE) {
                info.deallocator = true;
            } else if (canBeAllocator && "allocate".equals(info.name)) {
                info.allocator = true;
            } else if (canBeArrayAllocator && "allocateArray".equals(info.name)) {
                info.arrayAllocator = true;
                info.allocator = true;
            } else if (info.returnType.isAssignableFrom(ByteBuffer.class) && "asDirectBuffer".equals(info.name) && !Modifier.isStatic(info.modifiers) && info.parameterTypes.length == 0) {
                info.bufferGetter = true;
            } else if (valueGetter) {
                info.valueGetter = true;
                info.noReturnGetter = noReturnGetter;
                info.pairedMethod = pairedMethod;
            } else if (valueSetter) {
                info.valueSetter = true;
                info.pairedMethod = pairedMethod;
            } else if (memberGetter) {
                info.memberGetter = true;
                info.noReturnGetter = noReturnGetter;
                info.pairedMethod = pairedMethod;
            } else if (memberSetter) {
                info.memberSetter = true;
                info.pairedMethod = pairedMethod;
            }
        } else {
            logger.log(Level.WARNING, "Method \"" + method + "\" cannot behave like a \"" + behavior + "\". No code will be generated.");
            return null;
        }
        if (name == null && info.pairedMethod != null && (name = info.pairedMethod.getAnnotation(Name.class)) != null) {
            info.memberName = name.value();
        }
        boolean bl = info.noOffset = info.cls.isAnnotationPresent(NoOffset.class) || method.isAnnotationPresent(NoOffset.class) || method.isAnnotationPresent(Index.class);
        if (!info.noOffset && info.pairedMethod != null) {
            boolean bl2 = info.noOffset = info.pairedMethod.isAnnotationPresent(NoOffset.class) || info.pairedMethod.isAnnotationPresent(Index.class);
        }
        if (info.parameterTypes.length == 0 || !info.parameterTypes[0].isArray()) {
            if (info.valueGetter || info.memberGetter) {
                info.dim = info.parameterTypes.length;
            } else if (info.memberSetter || info.valueSetter) {
                info.dim = info.parameterTypes.length - 1;
            }
        }
        if (!(Generator.getNoException(info.cls, method) || (!(Generator.getBy(info.annotations) instanceof ByVal) || Generator.getNoException(info.returnType, method)) && (info.deallocator || info.valueGetter || info.valueSetter || info.memberGetter || info.memberSetter || info.bufferGetter))) {
            info.mayThrowException = true;
        }
        return info;
    }

    public static boolean getNoException(Class<?> cls, Method method) {
        boolean noException;
        boolean bl = noException = baseClasses.contains(cls) || method.isAnnotationPresent(NoException.class);
        while (!noException && cls != null && !(noException = cls.isAnnotationPresent(NoException.class))) {
            cls = cls.getDeclaringClass();
        }
        return noException;
    }

    public static AdapterInformation getParameterAdapterInformation(boolean out, MethodInformation methodInfo, int j) {
        String valueTypeName;
        AdapterInformation adapter;
        if (out && (methodInfo.parameterTypes[j] == String.class || methodInfo.valueSetter || methodInfo.memberSetter)) {
            return null;
        }
        String typeName = Generator.getParameterCast(methodInfo, j);
        if (typeName != null && typeName.startsWith("(") && typeName.endsWith(")")) {
            typeName = typeName.substring(1, typeName.length() - 1);
        }
        if (typeName == null || typeName.length() == 0) {
            typeName = Generator.getCastedCPPTypeName(methodInfo.parameterAnnotations[j], methodInfo.parameterTypes[j])[0];
        }
        if ((adapter = Generator.getAdapterInformation(out, valueTypeName = Generator.getValueTypeName(typeName), methodInfo.parameterAnnotations[j])) == null && methodInfo.pairedMethod != null && (methodInfo.valueSetter || methodInfo.memberSetter)) {
            adapter = Generator.getAdapterInformation(out, valueTypeName, methodInfo.pairedMethod.getAnnotations());
        }
        return adapter;
    }

    public static AdapterInformation getAdapterInformation(boolean out, String valueTypeName, Annotation ... annotations) {
        AdapterInformation adapterInfo = null;
        boolean constant = false;
        String cast = "";
        for (Annotation a : annotations) {
            Cast c;
            Adapter adapter;
            Adapter adapter2 = adapter = a instanceof Adapter ? (Adapter)a : a.annotationType().getAnnotation(Adapter.class);
            if (adapter != null) {
                adapterInfo = new AdapterInformation();
                adapterInfo.name = adapter.value();
                adapterInfo.argc = adapter.argc();
                if (a == adapter) continue;
                try {
                    Class<? extends Annotation> cls = a.annotationType();
                    if (cls.isAnnotationPresent(Const.class)) {
                        constant = true;
                    }
                    try {
                        String value = cls.getDeclaredMethod("value", new Class[0]).invoke((Object)a, new Object[0]).toString();
                        if (value != null && value.length() > 0) {
                            valueTypeName = value;
                        }
                    }
                    catch (NoSuchMethodException e) {
                        valueTypeName = null;
                    }
                    Cast c2 = cls.getAnnotation(Cast.class);
                    if (c2 != null && cast.length() == 0) {
                        cast = c2.value()[0];
                        if (valueTypeName != null) {
                            cast = cast + "< " + valueTypeName + " >";
                        }
                        if (c2.value().length > 1) {
                            cast = cast + c2.value()[1];
                        }
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Could not invoke the value() method on annotation \"" + a + "\".", ex);
                }
                if (valueTypeName == null || valueTypeName.length() <= 0) continue;
                adapterInfo.name = adapterInfo.name + "< " + valueTypeName + " >";
                continue;
            }
            if (a instanceof Const) {
                constant = true;
                continue;
            }
            if (!(a instanceof Cast) || (c = (Cast)a).value().length <= 1) continue;
            cast = c.value()[1];
        }
        if (adapterInfo != null) {
            adapterInfo.cast = cast;
            adapterInfo.constant = constant;
        }
        return out && constant ? null : adapterInfo;
    }

    public static String getParameterCast(MethodInformation methodInfo, int j) {
        String cast = Generator.getCast(methodInfo.parameterAnnotations[j], methodInfo.parameterTypes[j]);
        if ((cast == null || cast.length() == 0) && j == methodInfo.parameterTypes.length - 1 && (methodInfo.valueSetter || methodInfo.memberSetter) && methodInfo.pairedMethod != null) {
            cast = Generator.getCast(methodInfo.pairedMethod.getAnnotations(), methodInfo.pairedMethod.getReturnType());
        }
        return cast;
    }

    public static String getCast(Annotation[] annotations, Class<?> type) {
        String[] typeName = null;
        Annotation by = Generator.getBy(annotations);
        for (Annotation a : annotations) {
            if (a instanceof Cast && ((Cast)a).value()[0].length() > 0 || a instanceof Const && (by instanceof ByVal || by instanceof ByRef)) {
                typeName = Generator.getCastedCPPTypeName(annotations, type);
                continue;
            }
            if (!(a instanceof Const)) continue;
            typeName = Generator.getAnnotatedCPPTypeName(annotations, type);
        }
        return typeName != null && typeName.length > 0 ? "(" + (String)typeName[0] + typeName[1] + ")" : "";
    }

    public static Annotation getParameterBy(MethodInformation methodInfo, int j) {
        Annotation passBy = Generator.getBy(methodInfo.parameterAnnotations[j]);
        if (passBy == null && methodInfo.pairedMethod != null && (methodInfo.valueSetter || methodInfo.memberSetter)) {
            passBy = Generator.getBy(methodInfo.pairedMethod.getAnnotations());
        }
        return passBy;
    }

    public static Annotation getBy(Annotation ... annotations) {
        Annotation byAnnotation = null;
        for (Annotation a : annotations) {
            if (!(a instanceof ByPtr) && !(a instanceof ByPtrPtr) && !(a instanceof ByPtrRef) && !(a instanceof ByRef) && !(a instanceof ByVal)) continue;
            if (byAnnotation != null) {
                logger.log(Level.WARNING, "\"By\" annotation \"" + byAnnotation + "\" already found. Ignoring superfluous annotation \"" + a + "\".");
                continue;
            }
            byAnnotation = a;
        }
        return byAnnotation;
    }

    public static Annotation getBehavior(Annotation ... annotations) {
        Annotation behaviorAnnotation = null;
        for (Annotation a : annotations) {
            if (!(a instanceof Function) && !(a instanceof Allocator) && !(a instanceof ArrayAllocator) && !(a instanceof ValueSetter) && !(a instanceof ValueGetter) && !(a instanceof MemberGetter) && !(a instanceof MemberSetter)) continue;
            if (behaviorAnnotation != null) {
                logger.log(Level.WARNING, "Behavior annotation \"" + behaviorAnnotation + "\" already found. Ignoring superfluous annotation \"" + a + "\".");
                continue;
            }
            behaviorAnnotation = a;
        }
        return behaviorAnnotation;
    }

    public static String getValueTypeName(String ... typeName) {
        String type = typeName[0];
        if (type.startsWith("const ")) {
            type = type.substring(6, type.length() - 1);
        } else if (type.length() != 0) {
            type = type.substring(0, type.length() - 1);
        }
        return type;
    }

    public static String[] getAnnotatedCPPTypeName(Annotation[] annotations, Class<?> type) {
        String[] typeName = Generator.getCastedCPPTypeName(annotations, type);
        String prefix = typeName[0];
        String suffix = typeName[1];
        Annotation by = Generator.getBy(annotations);
        if (by instanceof ByVal) {
            prefix = Generator.getValueTypeName(typeName);
        } else if (by instanceof ByRef) {
            prefix = Generator.getValueTypeName(typeName) + "&";
        } else if (by instanceof ByPtrPtr) {
            prefix = prefix + "*";
        } else if (by instanceof ByPtrRef) {
            prefix = prefix + "&";
        }
        typeName[0] = prefix;
        typeName[1] = suffix;
        return typeName;
    }

    public static String[] getCastedCPPTypeName(Annotation[] annotations, Class<?> type) {
        String[] typeName = null;
        boolean warning = false;
        boolean adapter = false;
        for (Annotation a : annotations) {
            if (a instanceof Cast) {
                String[] stringArray;
                warning = typeName != null;
                String prefix = ((Cast)a).value()[0];
                String suffix = "";
                int parenthesis = prefix.indexOf(41);
                if (parenthesis > 0) {
                    suffix = prefix.substring(parenthesis).trim();
                    prefix = prefix.substring(0, parenthesis).trim();
                }
                if (prefix.length() > 0) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = prefix;
                    stringArray = stringArray2;
                    stringArray2[1] = suffix;
                } else {
                    stringArray = null;
                }
                typeName = stringArray;
                continue;
            }
            if (a instanceof Const) {
                warning = typeName != null;
                if (warning) continue;
                typeName = Generator.getCPPTypeName(type);
                if (((Const)a).value()) {
                    typeName[0] = Generator.getValueTypeName(typeName) + " const *";
                    continue;
                }
                typeName[0] = "const " + typeName[0];
                continue;
            }
            if (!(a instanceof Adapter) && !a.annotationType().isAnnotationPresent(Adapter.class)) continue;
            adapter = true;
        }
        if (warning && !adapter) {
            logger.log(Level.WARNING, "Without \"Adapter\", \"Cast\" and \"Const\" annotations are mutually exclusive.");
        }
        if (typeName == null) {
            typeName = Generator.getCPPTypeName(type);
        }
        return typeName;
    }

    public static String[] getCPPTypeName(Class<?> type) {
        String prefix = "";
        String suffix = "";
        if (type == Buffer.class || type == Pointer.class) {
            prefix = "void*";
        } else if (type == byte[].class || type == ByteBuffer.class || type == BytePointer.class) {
            prefix = "signed char*";
        } else if (type == short[].class || type == ShortBuffer.class || type == ShortPointer.class) {
            prefix = "short*";
        } else if (type == int[].class || type == IntBuffer.class || type == IntPointer.class) {
            prefix = "int*";
        } else if (type == long[].class || type == LongBuffer.class || type == LongPointer.class) {
            prefix = "jlong*";
        } else if (type == float[].class || type == FloatBuffer.class || type == FloatPointer.class) {
            prefix = "float*";
        } else if (type == double[].class || type == DoubleBuffer.class || type == DoublePointer.class) {
            prefix = "double*";
        } else if (type == char[].class || type == CharBuffer.class || type == CharPointer.class) {
            prefix = "unsigned short*";
        } else if (type == boolean[].class) {
            prefix = "unsigned char*";
        } else if (type == PointerPointer.class) {
            prefix = "void**";
        } else if (type == String.class) {
            prefix = "const char*";
        } else if (type == Byte.TYPE) {
            prefix = "signed char";
        } else if (type == Long.TYPE) {
            prefix = "jlong";
        } else if (type == Character.TYPE) {
            prefix = "unsigned short";
        } else if (type == Boolean.TYPE) {
            prefix = "unsigned char";
        } else if (type.isPrimitive()) {
            prefix = type.getName();
        } else if (FunctionPointer.class.isAssignableFrom(type)) {
            Method functionMethod = Generator.getFunctionMethod(type, null);
            if (functionMethod != null) {
                int j;
                String spaceName;
                Convention convention = type.getAnnotation(Convention.class);
                String callingConvention = convention == null ? "" : convention.value() + " ";
                Namespace namespace = type.getAnnotation(Namespace.class);
                String string = spaceName = namespace == null ? "" : namespace.value();
                if (spaceName.length() > 0 && !spaceName.endsWith("::")) {
                    spaceName = spaceName + "::";
                }
                Class<?> returnType = functionMethod.getReturnType();
                Class<?>[] parameterTypes = functionMethod.getParameterTypes();
                Annotation[] annotations = functionMethod.getAnnotations();
                Annotation[][] parameterAnnotations = functionMethod.getParameterAnnotations();
                String[] returnTypeName = Generator.getAnnotatedCPPTypeName(annotations, returnType);
                prefix = returnTypeName[0] + returnTypeName[1] + " (" + callingConvention + spaceName + "*";
                suffix = ")(";
                if (namespace != null && !Pointer.class.isAssignableFrom(parameterTypes[0])) {
                    logger.log(Level.WARNING, "First parameter of caller method call() or apply() for member function pointer " + type.getCanonicalName() + " is not a Pointer. Compilation will most likely fail.");
                }
                int n = j = namespace == null ? 0 : 1;
                while (j < parameterTypes.length) {
                    String[] paramTypeName = Generator.getAnnotatedCPPTypeName(parameterAnnotations[j], parameterTypes[j]);
                    suffix = suffix + paramTypeName[0] + " arg" + j + paramTypeName[1];
                    if (j < parameterTypes.length - 1) {
                        suffix = suffix + ", ";
                    }
                    ++j;
                }
                suffix = suffix + ")";
                if (type.isAnnotationPresent(Const.class)) {
                    suffix = suffix + " const";
                }
            }
        } else {
            String scopedType = Generator.getCPPScopeName(type);
            if (scopedType.length() > 0) {
                prefix = scopedType + "*";
            } else {
                logger.log(Level.WARNING, "The class " + type.getCanonicalName() + " does not map to any C++ type. Compilation will most likely fail.");
            }
        }
        return new String[]{prefix, suffix};
    }

    public static String getCPPScopeName(MethodInformation methodInfo) {
        String spaceName;
        String scopeName = Generator.getCPPScopeName(methodInfo.cls);
        Namespace namespace = methodInfo.method.getAnnotation(Namespace.class);
        String string = spaceName = namespace == null ? "" : namespace.value();
        if (namespace != null && namespace.value().length() == 0 || spaceName.startsWith("::")) {
            scopeName = "";
        }
        if (scopeName.length() > 0 && !scopeName.endsWith("::")) {
            scopeName = scopeName + "::";
        }
        scopeName = scopeName + spaceName;
        if (spaceName.length() > 0 && !spaceName.endsWith("::")) {
            scopeName = scopeName + "::";
        }
        return scopeName + methodInfo.memberName[0];
    }

    public static String getCPPScopeName(Class<?> type) {
        String scopeName = "";
        while (type != null) {
            String spaceName;
            Namespace namespace = type.getAnnotation(Namespace.class);
            String string = spaceName = namespace == null ? "" : namespace.value();
            if (Pointer.class.isAssignableFrom(type) && type != Pointer.class) {
                String s;
                Name name = type.getAnnotation(Name.class);
                if (name == null) {
                    s = type.getName();
                    int i = s.lastIndexOf("$");
                    if (i < 0) {
                        i = s.lastIndexOf(".");
                    }
                    s = s.substring(i + 1);
                } else {
                    s = name.value()[0];
                }
                if (spaceName.length() > 0 && !spaceName.endsWith("::")) {
                    spaceName = spaceName + "::";
                }
                spaceName = spaceName + s;
            }
            if (scopeName.length() > 0 && !spaceName.endsWith("::")) {
                spaceName = spaceName + "::";
            }
            scopeName = spaceName + scopeName;
            if (namespace != null && namespace.value().length() == 0 || spaceName.startsWith("::")) break;
            type = type.getDeclaringClass();
        }
        return scopeName;
    }

    public static String getJNITypeName(Class type) {
        if (type == Byte.TYPE) {
            return "jbyte";
        }
        if (type == Short.TYPE) {
            return "jshort";
        }
        if (type == Integer.TYPE) {
            return "jint";
        }
        if (type == Long.TYPE) {
            return "jlong";
        }
        if (type == Float.TYPE) {
            return "jfloat";
        }
        if (type == Double.TYPE) {
            return "jdouble";
        }
        if (type == Character.TYPE) {
            return "jchar";
        }
        if (type == Boolean.TYPE) {
            return "jboolean";
        }
        if (type == byte[].class) {
            return "jbyteArray";
        }
        if (type == short[].class) {
            return "jshortArray";
        }
        if (type == int[].class) {
            return "jintArray";
        }
        if (type == long[].class) {
            return "jlongArray";
        }
        if (type == float[].class) {
            return "jfloatArray";
        }
        if (type == double[].class) {
            return "jdoubleArray";
        }
        if (type == char[].class) {
            return "jcharArray";
        }
        if (type == boolean[].class) {
            return "jbooleanArray";
        }
        if (type.isArray()) {
            return "jobjectArray";
        }
        if (type == String.class) {
            return "jstring";
        }
        if (type == Class.class) {
            return "jclass";
        }
        if (type == Void.TYPE) {
            return "void";
        }
        return "jobject";
    }

    public static String getSignature(Class ... types) {
        StringBuilder signature = new StringBuilder(2 * types.length);
        for (int i = 0; i < types.length; ++i) {
            signature.append(Generator.getSignature(types[i]));
        }
        return signature.toString();
    }

    public static String getSignature(Class type) {
        if (type == Byte.TYPE) {
            return "B";
        }
        if (type == Short.TYPE) {
            return "S";
        }
        if (type == Integer.TYPE) {
            return "I";
        }
        if (type == Long.TYPE) {
            return "J";
        }
        if (type == Float.TYPE) {
            return "F";
        }
        if (type == Double.TYPE) {
            return "D";
        }
        if (type == Boolean.TYPE) {
            return "Z";
        }
        if (type == Character.TYPE) {
            return "C";
        }
        if (type == Void.TYPE) {
            return "V";
        }
        if (type.isArray()) {
            return type.getName().replace(".", "/");
        }
        return "L" + type.getName().replace(".", "/") + ";";
    }

    public static String mangle(String name) {
        StringBuilder mangledName = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                mangledName.append(c);
                continue;
            }
            if (c == '_') {
                mangledName.append("_1");
                continue;
            }
            if (c == ';') {
                mangledName.append("_2");
                continue;
            }
            if (c == '[') {
                mangledName.append("_3");
                continue;
            }
            if (c == '.' || c == '/') {
                mangledName.append("_");
                continue;
            }
            String code = Integer.toHexString(c);
            mangledName.append("_0");
            switch (code.length()) {
                case 1: {
                    mangledName.append("0");
                }
                case 2: {
                    mangledName.append("0");
                }
                case 3: {
                    mangledName.append("0");
                }
            }
            mangledName.append(code);
        }
        return mangledName.toString();
    }

    public static class AdapterInformation {
        public String name;
        public int argc;
        public String cast;
        public boolean constant;
    }

    public static class MethodInformation {
        public Class<?> cls;
        public Method method;
        public Annotation[] annotations;
        public int modifiers;
        public Class<?> returnType;
        public String name;
        public String[] memberName;
        public int dim;
        public boolean[] parameterRaw;
        public Class<?>[] parameterTypes;
        public Annotation[][] parameterAnnotations;
        public boolean returnRaw;
        public boolean withEnv;
        public boolean overloaded;
        public boolean noOffset;
        public boolean deallocator;
        public boolean allocator;
        public boolean arrayAllocator;
        public boolean bufferGetter;
        public boolean valueGetter;
        public boolean valueSetter;
        public boolean memberGetter;
        public boolean memberSetter;
        public boolean noReturnGetter;
        public Method pairedMethod;
        public boolean mayThrowException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedListRegister<E>
    extends LinkedList<E> {
        public int register(E e) {
            int i = this.indexOf(e);
            if (i < 0) {
                this.add(e);
                i = this.size() - 1;
            }
            return i;
        }
    }
}

