/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.javascript;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.matrixweb.ne.NativeEngine;
import de.matrixweb.ne.StringFunctor;
import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.javascript.JavaScriptExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptExecutorV8
implements JavaScriptExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaScriptExecutorV8.class);
    private final NativeEngine engine;
    private String source;

    public JavaScriptExecutorV8(String name) {
        this(name, JavaScriptExecutorV8.class);
    }

    public JavaScriptExecutorV8(final String name, final Class<?> clazz) {
        this.engine = new NativeEngine(new StringFunctor("require"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String call(String require) {
                String string;
                String module = "/" + name + "/" + require + ".js";
                InputStream in = clazz.getResourceAsStream(module);
                if (in == null) {
                    throw new SmallerException("Failed to find required module: " + module);
                }
                try {
                    string = IOUtils.toString((InputStream)in);
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new SmallerException("Failed to find required module: " + module, (Throwable)e);
                    }
                }
                in.close();
                return string;
            }
        });
        this.addGlobalFunction("print", LOGGER, "info");
    }

    @Override
    public void addGlobalFunction(String name, Object object) {
        this.addGlobalFunction(name, object, name);
    }

    @Override
    public void addGlobalFunction(String name, final Object object, String method) {
        try {
            final Method javaMethod = object.getClass().getMethod(method, String.class);
            this.engine.addCallbackFunction(new StringFunctor(name){

                public String call(String input) {
                    try {
                        Object result = javaMethod.invoke(object, input);
                        return result == null ? null : result.toString();
                    }
                    catch (IllegalAccessException e) {
                        throw new SmallerException("Illegal access to callback method", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new SmallerException("Failed to execute callback method", e.getTargetException());
                    }
                }
            });
        }
        catch (NoSuchMethodException e) {
            throw new SmallerException("Failed to reflect global method", (Throwable)e);
        }
    }

    @Override
    public void addScriptSource(String source, String name) {
        this.engine.addScript(name, source);
    }

    @Override
    public void addScriptFile(String file) {
        InputStream script = this.getClass().getResourceAsStream(file);
        try {
            this.addScriptSource(IOUtils.toString((InputStream)script), file);
        }
        catch (IOException e) {
            throw new SmallerException("Failed to include script file", (Throwable)e);
        }
        finally {
            if (script != null) {
                IOUtils.closeQuietly((InputStream)script);
            }
        }
    }

    @Override
    public void addScriptFile(URL url) {
        try {
            this.addScriptSource(IOUtils.toString((URL)url), url.getFile());
        }
        catch (IOException e) {
            throw new SmallerException("Failed to include script file", (Throwable)e);
        }
    }

    @Override
    public void addCallScript(String source) {
        this.source = source;
    }

    @Override
    public void run(Reader input, Writer output) throws IOException {
        LOGGER.info("Executeing V8 engine");
        try {
            String data = new ObjectMapper().writeValueAsString((Object)IOUtils.toString((Reader)input));
            output.write(this.engine.execute(String.format(this.source, data)));
        }
        catch (NativeEngine.NativeEngineException e) {
            throw new SmallerException("Failed to execute javascript", (Throwable)e);
        }
    }

    @Override
    public void dispose() {
        this.engine.dispose();
    }
}

