/*
 * Decompiled with CFR 0.152.
 */
package de.maxbossing.maxapi.Builders;

import de.maxbossing.maxapi.UTils.StringUTils;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public class HologramBuilder {
    private final ArmorStand hologram;

    public HologramBuilder(@NotNull Location location, @NotNull String text) {
        this.hologram = (ArmorStand)Objects.requireNonNull(location.getWorld()).spawnEntity(location, EntityType.ARMOR_STAND);
        this.hologram.setVisible(false);
        this.hologram.setInvulnerable(false);
        this.hologram.setGravity(false);
        this.hologram.setCustomNameVisible(true);
        this.hologram.setSmall(false);
        this.hologram.setCustomName(StringUTils.format(text));
    }

    public void setText(@NotNull String text) {
        this.hologram.setCustomName(StringUTils.format(text));
    }

    public String getText() {
        return this.hologram.getCustomName();
    }

    public void setSmall(boolean b) {
        this.hologram.setSmall(b);
    }

    public boolean isSmall() {
        return this.hologram.isSmall();
    }

    public void setVisible(boolean visible) {
        this.hologram.setVisible(visible);
    }

    public boolean isVisible() {
        return this.hologram.isVisible();
    }

    public void setGravity(boolean gravity) {
        this.hologram.setGravity(gravity);
    }

    public boolean hasGravity() {
        return this.hologram.hasGravity();
    }

    public void remove() {
        this.hologram.remove();
    }
}

