/*
 * Decompiled with CFR 0.152.
 */
package de.maxbossing.maxapi.UTils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class WorldUTils {
    public static boolean deleteWord(String name, File file) {
        try {
            Bukkit.getServer().unloadWorld(name, false);
            FileUtils.deleteDirectory((File)file);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean deleteWorlds(Map<String, File> worlds) {
        try {
            for (Map.Entry<String, File> set : worlds.entrySet()) {
                WorldUTils.deleteWord(set.getKey(), set.getValue());
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean deleteStandardWorlds() {
        try {
            HashMap<String, File> worlds = new HashMap<String, File>();
            worlds.put("world", new File("world"));
            worlds.put("world_nether", new File("world_nether"));
            worlds.put("world_the_end", new File("world_the_ent"));
            WorldUTils.deleteWorlds(worlds);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean saveTo(String folder, String worldName) {
        File worldsFolder = Bukkit.getServer().getWorldContainer();
        String[] wfList = worldsFolder.list();
        if (wfList == null || !Arrays.asList(wfList).contains(worldName)) {
            return false;
        }
        World world = Bukkit.getServer().getWorld(worldName);
        if (world == null) {
            return false;
        }
        world.save();
        return WorldUTils.copyDirectory(new File(worldsFolder, worldName), new File(folder));
    }

    private static boolean copyDirectory(File path, File target) {
        boolean success = true;
        target.mkdir();
        String[] entries = path.list();
        if (entries == null) {
            return false;
        }
        for (String s : entries) {
            if (s.equals("uid.dat")) continue;
            File currentFile = new File(path.getPath(), s);
            if (currentFile.isDirectory()) {
                File newDirectory = new File(target, s);
                newDirectory.mkdir();
                WorldUTils.copyDirectory(currentFile, newDirectory);
                continue;
            }
            try {
                FileInputStream inputStream = new FileInputStream(currentFile);
                FileChannel inChannel = inputStream.getChannel();
                FileOutputStream outputStream = new FileOutputStream(new File(target, s));
                FileChannel outChannel = outputStream.getChannel();
                inChannel.transferTo(0L, currentFile.length(), outChannel);
                inputStream.close();
                outputStream.close();
            }
            catch (IOException e) {
                if (!success) continue;
                e.printStackTrace();
                success = false;
            }
        }
        return success;
    }
}

