/*
 * Decompiled with CFR 0.152.
 */
package de.maxbossing.maxapi.Builders;

import com.google.gson.Gson;
import de.maxbossing.maxapi.Enchantments.Glow;
import de.maxbossing.maxapi.MaxAPI;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;

public class ItemStackBuilder {
    private ItemStack item;
    private ItemMeta meta;
    private Material material = Material.STONE;
    private int amount = 1;
    private MaterialData data;
    private short damage = 0;
    private Map<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
    private String displayname;
    private List<String> lore = new ArrayList<String>();
    private List<ItemFlag> flags = new ArrayList<ItemFlag>();
    private int customModelData;
    private boolean andSymbol = true;
    private boolean unsafeStackSize = false;

    public ItemStackBuilder(Material material) {
        if (material == null) {
            material = Material.AIR;
        }
        this.item = new ItemStack(material);
        this.material = material;
    }

    public ItemStackBuilder(Material material, int amount) {
        if (material == null) {
            material = Material.AIR;
        }
        if (!(amount <= material.getMaxStackSize() && amount > 0 || this.unsafeStackSize)) {
            amount = 1;
        }
        this.amount = amount;
        this.item = new ItemStack(material, amount);
        this.material = material;
    }

    public ItemStackBuilder(Material material, int amount, String displayname) {
        if (material == null) {
            material = Material.AIR;
        }
        Validate.notNull((Object)displayname, (String)"The Displayname is null.", (Object[])new Object[0]);
        this.item = new ItemStack(material, amount);
        this.material = material;
        if (!(amount <= material.getMaxStackSize() && amount > 0 || this.unsafeStackSize)) {
            amount = 1;
        }
        this.amount = amount;
        this.displayname = displayname;
    }

    public ItemStackBuilder(Material material, String displayname) {
        if (material == null) {
            material = Material.AIR;
        }
        Validate.notNull((Object)displayname, (String)"The Displayname is null.", (Object[])new Object[0]);
        this.item = new ItemStack(material);
        this.material = material;
        this.displayname = displayname;
    }

    public ItemStackBuilder(ItemStack item) {
        Validate.notNull((Object)item, (String)"The Item is null.", (Object[])new Object[0]);
        this.item = item;
        if (item.hasItemMeta()) {
            this.meta = item.getItemMeta();
        }
        this.material = item.getType();
        this.amount = item.getAmount();
        this.data = item.getData();
        this.damage = item.getDurability();
        this.enchantments = item.getEnchantments();
        if (item.hasItemMeta()) {
            this.displayname = item.getItemMeta().getDisplayName();
        }
        if (item.hasItemMeta()) {
            this.lore = item.getItemMeta().getLore();
        }
        if (item.hasItemMeta()) {
            for (ItemFlag f : item.getItemMeta().getItemFlags()) {
                this.flags.add(f);
            }
        }
        if (item.hasItemMeta()) {
            this.customModelData = item.getItemMeta().getCustomModelData();
        }
    }

    public ItemStackBuilder(FileConfiguration cfg, String path) {
        this(cfg.getItemStack(path));
    }

    @Deprecated
    public ItemStackBuilder(ItemStackBuilder builder) {
        Validate.notNull((Object)builder, (String)"The ItemBuilder is null.", (Object[])new Object[0]);
        this.item = builder.item;
        this.meta = builder.meta;
        this.material = builder.material;
        this.amount = builder.amount;
        this.damage = builder.damage;
        this.data = builder.data;
        this.damage = builder.damage;
        this.enchantments = builder.enchantments;
        this.displayname = builder.displayname;
        this.lore = builder.lore;
        this.flags = builder.flags;
        this.customModelData = builder.customModelData;
    }

    public ItemStackBuilder amount(int amount) {
        if (!(amount <= this.material.getMaxStackSize() && amount > 0 || this.unsafeStackSize)) {
            amount = 1;
        }
        this.amount = amount;
        return this;
    }

    public ItemStackBuilder data(MaterialData data) {
        Validate.notNull((Object)data, (String)"The Data is null.", (Object[])new Object[0]);
        this.data = data;
        return this;
    }

    @Deprecated
    public ItemStackBuilder damage(short damage) {
        this.damage = damage;
        return this;
    }

    public ItemStackBuilder durability(short damage) {
        this.damage = damage;
        return this;
    }

    public ItemStackBuilder material(Material material) {
        Validate.notNull((Object)material, (String)"The Material is null.", (Object[])new Object[0]);
        this.material = material;
        return this;
    }

    public ItemStackBuilder meta(ItemMeta meta) {
        Validate.notNull((Object)meta, (String)"The Meta is null.", (Object[])new Object[0]);
        this.meta = meta;
        return this;
    }

    public ItemStackBuilder enchant(Enchantment enchant, int level) {
        Validate.notNull((Object)enchant, (String)"The Enchantment is null.", (Object[])new Object[0]);
        this.enchantments.put(enchant, level);
        return this;
    }

    public ItemStackBuilder enchant(Map<Enchantment, Integer> enchantments) {
        Validate.notNull(enchantments, (String)"enchantments cant be null", (Object[])new Object[0]);
        this.enchantments = enchantments;
        return this;
    }

    public ItemStackBuilder displayname(String displayname) {
        Validate.notNull((Object)displayname, (String)"The Displayname is null.", (Object[])new Object[0]);
        this.displayname = this.andSymbol ? ChatColor.translateAlternateColorCodes((char)'&', (String)displayname) : displayname;
        return this;
    }

    public ItemStackBuilder lore(String line) {
        Validate.notNull((Object)line, (String)"The Line is null.", (Object[])new Object[0]);
        this.lore.add(this.andSymbol ? ChatColor.translateAlternateColorCodes((char)'&', (String)line) : line);
        return this;
    }

    public ItemStackBuilder lore(List<String> lore) {
        Validate.notNull(lore, (String)"The Lores are null.", (Object[])new Object[0]);
        this.lore = lore;
        return this;
    }

    @Deprecated
    public ItemStackBuilder lores(String ... lines) {
        Validate.notNull((Object)lines, (String)"The Lines are null.", (Object[])new Object[0]);
        for (String line : lines) {
            this.lore(this.andSymbol ? ChatColor.translateAlternateColorCodes((char)'&', (String)line) : line);
        }
        return this;
    }

    public ItemStackBuilder lore(String ... lines) {
        Validate.notNull((Object)lines, (String)"The Lines are null.", (Object[])new Object[0]);
        for (String line : lines) {
            this.lore(this.andSymbol ? ChatColor.translateAlternateColorCodes((char)'&', (String)line) : line);
        }
        return this;
    }

    public ItemStackBuilder lore(String line, int index) {
        Validate.notNull((Object)line, (String)"The Line is null.", (Object[])new Object[0]);
        this.lore.set(index, this.andSymbol ? ChatColor.translateAlternateColorCodes((char)'&', (String)line) : line);
        return this;
    }

    public ItemStackBuilder customModelData(int customModelData) {
        Validate.notNull((Object)customModelData, (String)"The CustomModelData is null", (Object[])new Object[0]);
        this.customModelData = customModelData;
        return this;
    }

    public ItemStackBuilder flag(ItemFlag flag) {
        Validate.notNull((Object)flag, (String)"The Flag is null.", (Object[])new Object[0]);
        this.flags.add(flag);
        return this;
    }

    public ItemStackBuilder flag(List<ItemFlag> flags) {
        Validate.notNull(flags, (String)"The Flags are null.", (Object[])new Object[0]);
        this.flags = flags;
        return this;
    }

    public ItemStackBuilder unbreakable(boolean unbreakable) {
        this.meta.setUnbreakable(unbreakable);
        return this;
    }

    public ItemStackBuilder glow() {
        NamespacedKey key = new NamespacedKey((Plugin)MaxAPI.getInstance(), MaxAPI.getInstance().getDescription().getName());
        Glow glow = new Glow(key);
        this.enchant(glow, 1);
        return this;
    }

    public Unsafe unsafe() {
        return new Unsafe(this, this);
    }

    @Deprecated
    public ItemStackBuilder replaceAndSymbol() {
        this.replaceAndSymbol(!this.andSymbol);
        return this;
    }

    public ItemStackBuilder replaceAndSymbol(boolean replace) {
        this.andSymbol = replace;
        return this;
    }

    public ItemStackBuilder toggleReplaceAndSymbol() {
        this.replaceAndSymbol(!this.andSymbol);
        return this;
    }

    public ItemStackBuilder unsafeStackSize(boolean allow) {
        this.unsafeStackSize = allow;
        return this;
    }

    public ItemStackBuilder toggleUnsafeStackSize() {
        this.unsafeStackSize(!this.unsafeStackSize);
        return this;
    }

    public String getDisplayname() {
        return this.displayname;
    }

    public int getAmount() {
        return this.amount;
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    @Deprecated
    public short getDamage() {
        return this.damage;
    }

    public short getDurability() {
        return this.damage;
    }

    public List<String> getLores() {
        return this.lore;
    }

    public boolean getAndSymbol() {
        return this.andSymbol;
    }

    public List<ItemFlag> getFlags() {
        return this.flags;
    }

    public Material getMaterial() {
        return this.material;
    }

    public ItemMeta getMeta() {
        return this.meta;
    }

    @Deprecated
    public MaterialData getData() {
        return this.data;
    }

    @Deprecated
    public List<String> getLore() {
        return this.lore;
    }

    public ItemStackBuilder toConfig(FileConfiguration cfg, String path) {
        cfg.set(path, (Object)this.build());
        return this;
    }

    public ItemStackBuilder fromConfig(FileConfiguration cfg, String path) {
        return new ItemStackBuilder(cfg, path);
    }

    public static void toConfig(FileConfiguration cfg, String path, ItemStackBuilder builder) {
        cfg.set(path, (Object)builder.build());
    }

    public String toJson() {
        return new Gson().toJson((Object)this);
    }

    public static String toJson(ItemStackBuilder builder) {
        return new Gson().toJson((Object)builder);
    }

    public static ItemStackBuilder fromJson(String json) {
        return (ItemStackBuilder)new Gson().fromJson(json, ItemStackBuilder.class);
    }

    public ItemStackBuilder applyJson(String json, boolean overwrite) {
        ItemStackBuilder b = (ItemStackBuilder)new Gson().fromJson(json, ItemStackBuilder.class);
        if (overwrite) {
            return b;
        }
        if (b.displayname != null) {
            this.displayname = b.displayname;
        }
        if (b.data != null) {
            this.data = b.data;
        }
        if (b.material != null) {
            this.material = b.material;
        }
        if (b.lore != null) {
            this.lore = b.lore;
        }
        if (b.enchantments != null) {
            this.enchantments = b.enchantments;
        }
        if (b.item != null) {
            this.item = b.item;
        }
        if (b.flags != null) {
            this.flags = b.flags;
        }
        this.damage = b.damage;
        this.amount = b.amount;
        return this;
    }

    public ItemStack build() {
        this.item.setType(this.material);
        this.item.setAmount(this.amount);
        this.item.setDurability(this.damage);
        this.meta = this.item.getItemMeta();
        if (this.data != null) {
            this.item.setData(this.data);
        }
        if (this.enchantments.size() > 0) {
            this.item.addUnsafeEnchantments(this.enchantments);
        }
        if (this.displayname != null) {
            this.meta.setDisplayName(this.displayname);
        }
        if (this.lore.size() > 0) {
            this.meta.setLore(this.lore);
        }
        if (this.flags.size() > 0) {
            for (ItemFlag f : this.flags) {
                this.meta.addItemFlags(new ItemFlag[]{f});
            }
        }
        this.item.setItemMeta(this.meta);
        return this.item;
    }

    public class Unsafe {
        protected final ReflectionUtils utils = new ReflectionUtils(this);
        protected final ItemStackBuilder builder;

        public Unsafe(ItemStackBuilder this$0, ItemStackBuilder builder) {
            this.builder = builder;
        }

        public Unsafe setString(String key, String value) {
            this.builder.item = this.utils.setString(this.builder.item, key, value);
            return this;
        }

        public String getString(String key) {
            return this.utils.getString(this.builder.item, key);
        }

        public Unsafe setInt(String key, int value) {
            this.builder.item = this.utils.setInt(this.builder.item, key, value);
            return this;
        }

        public int getInt(String key) {
            return this.utils.getInt(this.builder.item, key);
        }

        public Unsafe setDouble(String key, double value) {
            this.builder.item = this.utils.setDouble(this.builder.item, key, value);
            return this;
        }

        public double getDouble(String key) {
            return this.utils.getDouble(this.builder.item, key);
        }

        public Unsafe setBoolean(String key, boolean value) {
            this.builder.item = this.utils.setBoolean(this.builder.item, key, value);
            return this;
        }

        public boolean getBoolean(String key) {
            return this.utils.getBoolean(this.builder.item, key);
        }

        public boolean containsKey(String key) {
            return this.utils.hasKey(this.builder.item, key);
        }

        public ItemStackBuilder builder() {
            return this.builder;
        }

        public class ReflectionUtils {
            public ReflectionUtils(Unsafe this$1) {
            }

            public String getString(ItemStack item, String key) {
                Object compound = this.getNBTTagCompound(this.getItemAsNMSStack(item));
                if (compound == null) {
                    compound = this.getNewNBTTagCompound();
                }
                try {
                    return (String)compound.getClass().getMethod("getString", String.class).invoke(compound, key);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }

            public ItemStack setString(ItemStack item, String key, String value) {
                Object nmsItem = this.getItemAsNMSStack(item);
                Object compound = this.getNBTTagCompound(nmsItem);
                if (compound == null) {
                    compound = this.getNewNBTTagCompound();
                }
                try {
                    compound.getClass().getMethod("setString", String.class, String.class).invoke(compound, key, value);
                    nmsItem = this.setNBTTag(compound, nmsItem);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    ex.printStackTrace();
                }
                return this.getItemAsBukkitStack(nmsItem);
            }

            public int getInt(ItemStack item, String key) {
                Object compound = this.getNBTTagCompound(this.getItemAsNMSStack(item));
                if (compound == null) {
                    compound = this.getNewNBTTagCompound();
                }
                try {
                    return (Integer)compound.getClass().getMethod("getInt", String.class).invoke(compound, key);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    ex.printStackTrace();
                    return -1;
                }
            }

            public ItemStack setInt(ItemStack item, String key, int value) {
                Object nmsItem = this.getItemAsNMSStack(item);
                Object compound = this.getNBTTagCompound(nmsItem);
                if (compound == null) {
                    compound = this.getNewNBTTagCompound();
                }
                try {
                    compound.getClass().getMethod("setInt", String.class, Integer.class).invoke(compound, key, value);
                    nmsItem = this.setNBTTag(compound, nmsItem);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    ex.printStackTrace();
                }
                return this.getItemAsBukkitStack(nmsItem);
            }

            public double getDouble(ItemStack item, String key) {
                Object compound = this.getNBTTagCompound(this.getItemAsNMSStack(item));
                if (compound == null) {
                    compound = this.getNewNBTTagCompound();
                }
                try {
                    return (Double)compound.getClass().getMethod("getDouble", String.class).invoke(compound, key);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    ex.printStackTrace();
                    return Double.NaN;
                }
            }

            public ItemStack setDouble(ItemStack item, String key, double value) {
                Object nmsItem = this.getItemAsNMSStack(item);
                Object compound = this.getNBTTagCompound(nmsItem);
                if (compound == null) {
                    compound = this.getNewNBTTagCompound();
                }
                try {
                    compound.getClass().getMethod("setDouble", String.class, Double.class).invoke(compound, key, value);
                    nmsItem = this.setNBTTag(compound, nmsItem);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    ex.printStackTrace();
                }
                return this.getItemAsBukkitStack(nmsItem);
            }

            public boolean getBoolean(ItemStack item, String key) {
                Object compound = this.getNBTTagCompound(this.getItemAsNMSStack(item));
                if (compound == null) {
                    compound = this.getNewNBTTagCompound();
                }
                try {
                    return (Boolean)compound.getClass().getMethod("getBoolean", String.class).invoke(compound, key);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    ex.printStackTrace();
                    return false;
                }
            }

            public ItemStack setBoolean(ItemStack item, String key, boolean value) {
                Object nmsItem = this.getItemAsNMSStack(item);
                Object compound = this.getNBTTagCompound(nmsItem);
                if (compound == null) {
                    compound = this.getNewNBTTagCompound();
                }
                try {
                    compound.getClass().getMethod("setBoolean", String.class, Boolean.class).invoke(compound, key, value);
                    nmsItem = this.setNBTTag(compound, nmsItem);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    ex.printStackTrace();
                }
                return this.getItemAsBukkitStack(nmsItem);
            }

            public boolean hasKey(ItemStack item, String key) {
                Object compound = this.getNBTTagCompound(this.getItemAsNMSStack(item));
                if (compound == null) {
                    compound = this.getNewNBTTagCompound();
                }
                try {
                    return (Boolean)compound.getClass().getMethod("hasKey", String.class).invoke(compound, key);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                    return false;
                }
            }

            public Object getNewNBTTagCompound() {
                String ver = Bukkit.getServer().getClass().getPackage().getName().split(".")[3];
                try {
                    return Class.forName("net.minecraft.server." + ver + ".NBTTagCompound").newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }

            public Object setNBTTag(Object tag, Object item) {
                try {
                    item.getClass().getMethod("setTag", item.getClass()).invoke(item, tag);
                    return item;
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }

            public Object getNBTTagCompound(Object nmsStack) {
                try {
                    return nmsStack.getClass().getMethod("getTag", new Class[0]).invoke(nmsStack, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }

            public Object getItemAsNMSStack(ItemStack item) {
                try {
                    Method m = this.getCraftItemStackClass().getMethod("asNMSCopy", ItemStack.class);
                    return m.invoke(this.getCraftItemStackClass(), item);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }

            public ItemStack getItemAsBukkitStack(Object nmsStack) {
                try {
                    Method m = this.getCraftItemStackClass().getMethod("asCraftMirror", nmsStack.getClass());
                    return (ItemStack)m.invoke(this.getCraftItemStackClass(), nmsStack);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }

            public Class<?> getCraftItemStackClass() {
                String ver = Bukkit.getServer().getClass().getPackage().getName().split(".")[3];
                try {
                    return Class.forName("org.bukkit.craftbukkit." + ver + ".inventory.CraftItemStack");
                }
                catch (ClassNotFoundException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
        }
    }
}

