/*
 * Decompiled with CFR 0.152.
 */
package de.strullerbaumann.telemeejavaclient.boundary;

import de.strullerbaumann.telemeejavaclient.entity.Channel;
import de.strullerbaumann.telemeejavaclient.entity.ChannelAttribute;
import de.strullerbaumann.telemeejavaclient.entity.LogEntry;
import de.strullerbaumann.telemeejavaclient.entity.TelemeeApp;
import de.strullerbaumann.telemeejavaclient.rest.RestClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TelemeeJavaClient
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(TelemeeJavaClient.class.getName());
    private final RestClient restClient = new RestClient();
    private int logLevel;
    public static final int OFF = 999;
    public static final int SEVERE = 600;
    public static final int WARNING = 500;
    public static final int INFO = 400;
    public static final int FINE = 300;
    public static final int FINER = 200;
    public static final int FINEST = 100;
    public static final int ALL = 0;
    private TelemeeApp currentApp;
    private Channel currentChannel;
    private ChannelAttribute currentChannelAttribute;
    private LogEntry currentLogEntry;
    private final ConcurrentHashMap<String, TelemeeApp> telemeeApps = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Channel> channels = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ChannelAttribute> channelAttributes = new ConcurrentHashMap();
    private final List<LogEntry> logEntries = new ArrayList<LogEntry>();

    public void init() {
        this.init("http://localhost:8080/");
    }

    public void init(String baseURI) {
        this.restClient.init(baseURI);
        for (TelemeeApp appFromServer : this.restClient.getTelemeeApps()) {
            this.telemeeApps.put(appFromServer.getName(), appFromServer);
        }
        for (Channel channelFromServer : this.restClient.getChannels()) {
            this.channels.put(channelFromServer.getName(), channelFromServer);
        }
        for (ChannelAttribute channelAttributeFromServer : this.restClient.getChannelAttributes()) {
            this.channelAttributes.put(channelAttributeFromServer.getName(), channelAttributeFromServer);
        }
    }

    public int getThreadPoolSize() {
        return this.restClient.getThreadPoolSize();
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.restClient.setThreadPoolSize(threadPoolSize);
    }

    public void destroy() {
        this.restClient.destroy();
    }

    public String getBaseURI() {
        return this.restClient.getBaseURI();
    }

    public void setBaseURI(String baseURI) {
        this.restClient.setBaseURI(baseURI);
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public void deleteTelemeeApp(TelemeeApp telemeeAppToDelete) {
        TelemeeApp telemeeApp = this.telemeeApps.get(telemeeAppToDelete.getName());
        if (telemeeApp != null) {
            this.restClient.deleteTelemeeApp(telemeeApp);
            this.telemeeApps.remove(telemeeApp.getName());
            telemeeApp.setId(Long.MIN_VALUE);
        }
    }

    public void deleteChannel(Channel channelToDelete) {
        Channel channel = this.channels.get(channelToDelete.getName());
        if (channel != null) {
            for (TelemeeApp telemeeApp : this.telemeeApps.values()) {
                if (!telemeeApp.getChannels().contains(channel)) continue;
                telemeeApp.getChannels().remove(channel);
            }
            this.channels.remove(channel.getName());
            this.restClient.deleteChannel(channel);
            channel.setId(Long.MIN_VALUE);
        }
    }

    public void deleteChannelAttribute(ChannelAttribute channelAttributeToDelete) {
        ChannelAttribute channelAttribute = this.channelAttributes.get(channelAttributeToDelete.getName());
        if (channelAttribute != null) {
            for (Channel channel : this.channels.values()) {
                if (!channel.getChannelAttributes().contains(channelAttributeToDelete)) continue;
                channel.getChannelAttributes().remove(channelAttributeToDelete);
            }
            this.restClient.deleteChannelAttribute(channelAttribute);
            this.channelAttributes.remove(channelAttribute.getName());
            channelAttribute.setId(Long.MIN_VALUE);
        }
    }

    public void deleteLogEntries(Channel channel) {
        if (channel != null) {
            this.restClient.deleteLogEntries(channel);
        }
    }

    public Collection<TelemeeApp> getTelemeeApps() {
        return this.telemeeApps.values();
    }

    public Collection<Channel> getChannels() {
        return this.channels.values();
    }

    public Collection<ChannelAttribute> getChannelAttributes() {
        return this.channelAttributes.values();
    }

    public TelemeeJavaClient forTelemeeApp(TelemeeApp telemeeApp) {
        this.telemeeApps.putIfAbsent(telemeeApp.getName(), telemeeApp);
        this.currentApp = telemeeApp = this.telemeeApps.get(telemeeApp.getName());
        return this;
    }

    public TelemeeJavaClient forChannel(Channel channel) {
        this.channels.putIfAbsent(channel.getName(), channel);
        channel = this.channels.get(channel.getName());
        if (this.currentApp == null) {
            throw new IllegalStateException("Please define a telemeeApp for channel " + channel);
        }
        this.currentApp.addChannel(channel);
        this.currentChannel = channel;
        return this;
    }

    public TelemeeJavaClient forChannelAttribute(ChannelAttribute channelAttribute) {
        this.channelAttributes.putIfAbsent(channelAttribute.getName(), channelAttribute);
        channelAttribute = this.channelAttributes.get(channelAttribute.getName());
        if (this.currentChannel == null) {
            throw new IllegalStateException("Please define a channel for channelattribute " + channelAttribute);
        }
        this.currentChannel.addChannelAttribute(channelAttribute);
        this.currentChannelAttribute = channelAttribute;
        return this;
    }

    public Long getLogEntriesCount(Channel channel) {
        return this.restClient.getLogEntriesCount(channel);
    }

    public TelemeeJavaClient startLogEntry(String description, int logLevel) {
        LogEntry newLogEntry;
        if (this.currentChannel == null) {
            throw new IllegalStateException("Please define a channel for logEntry " + description);
        }
        this.currentLogEntry = newLogEntry = new LogEntry(this.currentChannel, description, logLevel);
        return this;
    }

    public TelemeeJavaClient log(String value) {
        if (this.currentLogEntry == null) {
            throw new IllegalStateException("Please define a LogEntry with 'startLogEntry()' before using log()");
        }
        this.currentLogEntry.addLogValue(value, this.currentChannelAttribute);
        return this;
    }

    public TelemeeJavaClient log(Object value) {
        return this.log(String.valueOf(value));
    }

    public TelemeeJavaClient log(boolean value) {
        return this.log(String.valueOf(value));
    }

    public TelemeeJavaClient log(char value) {
        return this.log(String.valueOf(value));
    }

    public TelemeeJavaClient log(char[] value) {
        return this.log(String.valueOf(value));
    }

    public TelemeeJavaClient log(double value) {
        return this.log(String.valueOf(value));
    }

    public TelemeeJavaClient log(float value) {
        return this.log(String.valueOf(value));
    }

    public TelemeeJavaClient log(int value) {
        return this.log(String.valueOf(value));
    }

    public TelemeeJavaClient log(long value) {
        return this.log(String.valueOf(value));
    }

    public TelemeeJavaClient endLogEntry() {
        this.logEntries.add(this.currentLogEntry);
        return this;
    }

    public Channel getChannel(String name) {
        return this.channels.get(name);
    }

    public void clearCache() {
        this.currentApp = null;
        this.currentChannel = null;
        this.currentChannelAttribute = null;
        this.currentLogEntry = null;
        this.telemeeApps.clear();
        this.channels.clear();
        this.channelAttributes.clear();
        this.logEntries.clear();
    }

    public void waitTillAllIsDone() {
        this.restClient.waitTillAllIsDone();
    }

    public void send() {
        this.send(false);
    }

    public void sendAsync() {
        this.send(true);
    }

    private void send(boolean async) {
        this.sendTelemeeApps();
        this.sendChannels();
        this.sendBindChannelsToApps();
        this.sendChannelAttributes();
        this.sendBindChannelAttributesToChannels();
        if (async) {
            this.sendLogEntriesAsync();
        } else {
            this.sendLogEntries();
        }
        this.clearLogEntries();
    }

    private void sendTelemeeApps() {
        for (TelemeeApp telemeeApp : this.telemeeApps.values()) {
            this.restClient.createTelemeeApp(telemeeApp);
        }
    }

    private void sendChannels() {
        for (Channel channel : this.channels.values()) {
            this.restClient.createChannel(channel);
        }
    }

    private void sendBindChannelsToApps() {
        for (TelemeeApp telemeeApp : this.telemeeApps.values()) {
            for (Channel channel : telemeeApp.getChannels()) {
                this.restClient.bindChannelToApp(channel, telemeeApp);
            }
        }
    }

    private void sendChannelAttributes() {
        for (ChannelAttribute channelAttribute : this.channelAttributes.values()) {
            this.restClient.createChannelAttribute(channelAttribute);
        }
    }

    private void sendBindChannelAttributesToChannels() {
        for (Channel channel : this.channels.values()) {
            for (ChannelAttribute channelAttribute : channel.getChannelAttributes()) {
                this.restClient.bindChannelAttributeToChannel(channelAttribute, channel);
            }
        }
    }

    private void sendLogEntries() {
        for (LogEntry logEntry : this.logEntries) {
            if (logEntry.getLogLevel() < this.logLevel) continue;
            this.restClient.createLogEntry(logEntry);
        }
    }

    private void sendLogEntriesAsync() {
        for (LogEntry logEntry : this.logEntries) {
            if (logEntry.getLogLevel() < this.logLevel) continue;
            try {
                this.restClient.createLogEntryAsync(logEntry);
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
    }

    private void clearLogEntries() {
        this.logEntries.clear();
    }
}

