/*
 * Decompiled with CFR 0.152.
 */
package de.strullerbaumann.telemeejavaclient.rest;

import com.sun.jersey.api.client.AsyncWebResource;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import de.strullerbaumann.telemeejavaclient.boundary.TelemeeException;
import de.strullerbaumann.telemeejavaclient.entity.Channel;
import de.strullerbaumann.telemeejavaclient.entity.ChannelAttribute;
import de.strullerbaumann.telemeejavaclient.entity.LogEntry;
import de.strullerbaumann.telemeejavaclient.entity.LogValue;
import de.strullerbaumann.telemeejavaclient.entity.TelemeeApp;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;

public class RestClient {
    private Client client = null;
    public static final String DEFAULT_BASE_URI = "http://localhost:8080/";
    private String baseURI = "http://localhost:8080/";
    private static final int DEFAULT_THREADPOOLSIZE = 5;
    private int threadPoolSize = 5;
    private final List<Future> futureResponses = new ArrayList<Future>();
    private static final Logger LOGGER = Logger.getLogger(RestClient.class.getName());

    public RestClient() {
        DefaultClientConfig cc = new DefaultClientConfig();
        cc.getProperties().put("com.sun.jersey.client.property.threadpoolSize", this.threadPoolSize);
        this.client = Client.create((ClientConfig)cc);
    }

    public void init() {
        this.init(DEFAULT_BASE_URI);
    }

    public void init(String baseURI) {
        this.baseURI = baseURI;
        this.testConnectionToServer();
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public void destroy() {
        this.waitTillAllIsDone();
        this.client.getExecutorService().shutdown();
        this.client.destroy();
    }

    public boolean testConnectionToServer() {
        boolean serverRunning = true;
        try {
            this.client.resource(this.baseURI + "telemee/resources/monitor/alive");
        }
        catch (ClientHandlerException | UniformInterfaceException e) {
            LOGGER.log(Level.SEVERE, "Couldn't connect to telemeeserver(" + this.baseURI + "telemee)  - is telemeeserver running?", e);
            serverRunning = false;
        }
        return serverRunning;
    }

    public List<TelemeeApp> getTelemeeApps() {
        ArrayList<TelemeeApp> telemeeApps;
        block17: {
            telemeeApps = new ArrayList<TelemeeApp>();
            try {
                WebResource webResource = this.client.resource(this.baseURI + "telemee/resources/telemeeapps");
                String jsonTelemeeApps = (String)webResource.accept(new String[]{"application/json"}).get(String.class);
                if (jsonTelemeeApps.equals("null")) break block17;
                try (JsonReader readerArrayOrObject = Json.createReader((Reader)new StringReader(jsonTelemeeApps));){
                    JsonArray arrayTelemeeApps;
                    JsonObject jsonObject = readerArrayOrObject.readObject();
                    try {
                        arrayTelemeeApps = jsonObject.getJsonArray("telemeeApp");
                    }
                    catch (ClassCastException e) {
                        arrayTelemeeApps = Json.createArrayBuilder().add((JsonValue)jsonObject.getJsonObject("telemeeApp")).build();
                    }
                    for (JsonValue value : arrayTelemeeApps) {
                        JsonReader reader = Json.createReader((Reader)new StringReader(value.toString()));
                        JsonObject jsonObject2 = reader.readObject();
                        TelemeeApp telemeeAppFromServer = new TelemeeApp();
                        telemeeAppFromServer.setId(Long.valueOf(jsonObject2.getString("id")));
                        telemeeAppFromServer.setName(jsonObject2.getString("name"));
                        telemeeApps.add(telemeeAppFromServer);
                    }
                }
            }
            catch (ClientHandlerException | UniformInterfaceException e) {
                LOGGER.log(Level.SEVERE, "Couldn't get telemeeapps - is telemeeserver running?", e);
            }
        }
        return telemeeApps;
    }

    public List<Channel> getChannels() {
        ArrayList<Channel> channels;
        block17: {
            channels = new ArrayList<Channel>();
            try {
                WebResource webResource = this.client.resource(this.baseURI + "telemee/resources/channels");
                String jsonChannels = (String)webResource.accept(new String[]{"application/json"}).get(String.class);
                if (jsonChannels.equals("null")) break block17;
                try (JsonReader readerArrayOrObject = Json.createReader((Reader)new StringReader(jsonChannels));){
                    JsonArray arrayChannels;
                    JsonObject jsonObject = readerArrayOrObject.readObject();
                    try {
                        arrayChannels = jsonObject.getJsonArray("channel");
                    }
                    catch (ClassCastException e) {
                        arrayChannels = Json.createArrayBuilder().add((JsonValue)jsonObject.getJsonObject("channel")).build();
                    }
                    for (JsonValue value : arrayChannels) {
                        JsonReader reader = Json.createReader((Reader)new StringReader(value.toString()));
                        JsonObject jsonObject2 = reader.readObject();
                        Channel channelFromServer = new Channel();
                        channelFromServer.setId(Long.valueOf(jsonObject2.getString("id")));
                        channelFromServer.setName(jsonObject2.getString("name"));
                        channels.add(channelFromServer);
                    }
                }
            }
            catch (ClientHandlerException | UniformInterfaceException e) {
                LOGGER.log(Level.SEVERE, "Couldn't get channels - is telemeeserver running?", e);
            }
        }
        return channels;
    }

    public List<ChannelAttribute> getChannelAttributes() {
        ArrayList<ChannelAttribute> channelAttributes;
        block17: {
            channelAttributes = new ArrayList<ChannelAttribute>();
            try {
                WebResource webResource = this.client.resource(this.baseURI + "telemee/resources/channelattributes");
                String jsonChannelAttributes = (String)webResource.accept(new String[]{"application/json"}).get(String.class);
                if (jsonChannelAttributes.equals("null")) break block17;
                try (JsonReader readerArrayOrObject = Json.createReader((Reader)new StringReader(jsonChannelAttributes));){
                    JsonArray arrayChannelAttributes;
                    JsonObject jsonObject = readerArrayOrObject.readObject();
                    try {
                        arrayChannelAttributes = jsonObject.getJsonArray("channelAttribute");
                    }
                    catch (ClassCastException e) {
                        arrayChannelAttributes = Json.createArrayBuilder().add((JsonValue)jsonObject.getJsonObject("channelAttribute")).build();
                    }
                    for (JsonValue value : arrayChannelAttributes) {
                        JsonReader reader = Json.createReader((Reader)new StringReader(value.toString()));
                        JsonObject jsonObject2 = reader.readObject();
                        ChannelAttribute channelAttributeFromServer = new ChannelAttribute();
                        channelAttributeFromServer.setId(Long.valueOf(jsonObject2.getString("id")));
                        channelAttributeFromServer.setName(jsonObject2.getString("name"));
                        channelAttributes.add(channelAttributeFromServer);
                    }
                }
            }
            catch (ClientHandlerException | UniformInterfaceException e) {
                LOGGER.log(Level.SEVERE, "Couldn't get channelAttributes - is telemeeserver running?", e);
            }
        }
        return channelAttributes;
    }

    public void createTelemeeApp(TelemeeApp newTelemeeApp) {
        if (newTelemeeApp.getId() < 1L) {
            try {
                WebResource webResource = this.client.resource(this.baseURI + "telemee/resources/telemeeapps");
                String input = "{\"name\":\"" + newTelemeeApp.getName() + "\"}";
                ClientResponse response = (ClientResponse)webResource.type("application/json").post(ClientResponse.class, (Object)input);
                if (response.getStatus() != 201) {
                    throw new TelemeeException("Failed to create app '" + newTelemeeApp.getName() + "' - HTTP error code : " + response.getStatus());
                }
                String newJson = (String)response.getEntity(String.class);
                newTelemeeApp.setId(this.getIDFromJson(newJson));
            }
            catch (TelemeeException e) {
                LOGGER.log(Level.SEVERE, "Couldn't build app(s) - is telemeeserver running?", e);
            }
        }
    }

    public void createChannel(Channel newChannel) {
        if (newChannel.getId() < 1L) {
            try {
                WebResource webResource = this.client.resource(this.baseURI + "telemee/resources/channels");
                String input = "{\"name\":\"" + newChannel.getName() + "\"}";
                ClientResponse response = (ClientResponse)webResource.type("application/json").post(ClientResponse.class, (Object)input);
                if (response.getStatus() != 201) {
                    throw new TelemeeException("Failed to create channel '" + newChannel.getName() + "' - HTTP error code : " + response.getStatus());
                }
                String newJson = (String)response.getEntity(String.class);
                newChannel.setId(this.getIDFromJson(newJson));
            }
            catch (TelemeeException e) {
                LOGGER.log(Level.SEVERE, "Couldn't build channel(s) - is telemeeserver running?", e);
            }
        }
    }

    public void createChannelAttribute(ChannelAttribute newChannelAttribute) {
        if (newChannelAttribute.getId() < 1L) {
            try {
                WebResource webResource = this.client.resource(this.baseURI + "telemee/resources/channelattributes");
                String input = "{\"name\":\"" + newChannelAttribute.getName() + "\"}";
                ClientResponse response = (ClientResponse)webResource.type("application/json").post(ClientResponse.class, (Object)input);
                if (response.getStatus() != 201) {
                    throw new TelemeeException("Failed to create channelattribute '" + newChannelAttribute.getName() + "' - HTTP error code : " + response.getStatus());
                }
                String newJson = (String)response.getEntity(String.class);
                newChannelAttribute.setId(this.getIDFromJson(newJson));
            }
            catch (TelemeeException e) {
                LOGGER.log(Level.SEVERE, "Couldn't build channelattribute(s) - is telemeeserver running?", e);
            }
        }
    }

    public void bindChannelToApp(Channel channel, TelemeeApp telemeeApp) {
        if (!telemeeApp.getBoundedChannels().contains(channel)) {
            try {
                WebResource webResource = this.client.resource(this.baseURI + "telemee/resources/telemeeapps/" + telemeeApp.getId() + "/channel/" + channel.getId());
                ClientResponse response = (ClientResponse)webResource.type("application/json").post(ClientResponse.class);
                if (response.getStatus() != 201) {
                    throw new TelemeeException("Failed to bind Channel '" + channel.getName() + "' to app '" + telemeeApp.getName() + "' - HTTP error code : " + response.getStatus());
                }
                telemeeApp.getBoundedChannels().add(channel);
            }
            catch (TelemeeException e) {
                LOGGER.log(Level.SEVERE, "Couldn't bind channel(s) to app(s) - is telemeeserver running?", e);
            }
        }
    }

    public void bindChannelAttributeToChannel(ChannelAttribute channelAttribute, Channel channel) {
        if (!channel.getBoundedChannelAttributes().contains(channelAttribute)) {
            try {
                WebResource webResource = this.client.resource(this.baseURI + "telemee/resources/channels/" + channel.getId() + "/channelattribute/" + channelAttribute.getId());
                ClientResponse response = (ClientResponse)webResource.type("application/json").post(ClientResponse.class);
                if (response.getStatus() != 201) {
                    throw new TelemeeException("Failed to bind ChannelAttribute '" + channelAttribute.getName() + "' to channel '" + channel.getName() + "' - HTTP error code : " + response.getStatus());
                }
                channel.getBoundedChannelAttributes().add(channelAttribute);
            }
            catch (TelemeeException e) {
                LOGGER.log(Level.SEVERE, "Couldn't bind ChannelAttribute(s) to channel(s) - is telemeeserver running?", e);
            }
        }
    }

    public void createLogEntry(LogEntry newLogEntry) {
        try {
            WebResource webResource = this.client.resource(this.baseURI + "telemee/resources/logentries/");
            JsonObjectBuilder jsonLogEntry = Json.createObjectBuilder();
            jsonLogEntry.add("channelID", newLogEntry.getChannel().getId());
            jsonLogEntry.add("description", newLogEntry.getDescription());
            JsonArrayBuilder jsonLogValues = Json.createArrayBuilder();
            for (LogValue logValue : newLogEntry.getLogValues()) {
                JsonObjectBuilder jsonLogValue = Json.createObjectBuilder();
                jsonLogValue.add("value", logValue.getValue()).add("channelAttributeID", logValue.getChannelAttribute().getId());
                jsonLogValues.add(jsonLogValue);
            }
            jsonLogEntry.add("logValues", jsonLogValues);
            ClientResponse response = (ClientResponse)webResource.type("application/json").post(ClientResponse.class, (Object)jsonLogEntry.build().toString());
            if (response.getStatus() != 201) {
                throw new TelemeeException("Failed to send " + newLogEntry + " : HTTP error code : " + response.getStatus());
            }
        }
        catch (TelemeeException e) {
            LOGGER.log(Level.SEVERE, "Couldn't send logentry  - is telemeeserver running?" + newLogEntry, e);
        }
    }

    public void createLogEntryAsync(LogEntry newLogEntry) throws InterruptedException {
        JsonObjectBuilder jsonLogEntry = Json.createObjectBuilder();
        jsonLogEntry.add("channelID", newLogEntry.getChannel().getId());
        jsonLogEntry.add("description", newLogEntry.getDescription());
        JsonArrayBuilder jsonLogValues = Json.createArrayBuilder();
        for (LogValue logValue : newLogEntry.getLogValues()) {
            JsonObjectBuilder jsonLogValue = Json.createObjectBuilder();
            jsonLogValue.add("value", logValue.getValue()).add("channelAttributeID", logValue.getChannelAttribute().getId());
            jsonLogValues.add(jsonLogValue);
        }
        jsonLogEntry.add("logValues", jsonLogValues);
        AsyncWebResource webResource = this.client.asyncResource(this.baseURI + "telemee/resources/logentries/");
        Future futureResponse = webResource.type("application/json").post(ClientResponse.class, (Object)jsonLogEntry.build().toString());
        this.futureResponses.add(futureResponse);
    }

    public void waitTillAllIsDone() {
        for (Future future : this.futureResponses) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
    }

    public void deleteTelemeeApp(TelemeeApp telemeeApp) {
        try {
            WebResource webResource = this.client.resource(this.baseURI + "telemee/resources/telemeeapps/" + telemeeApp.getId());
            webResource.type("application/json").delete(ClientResponse.class);
        }
        catch (ClientHandlerException | UniformInterfaceException e) {
            LOGGER.log(Level.SEVERE, "Couldn't delete telemeeApp " + telemeeApp + " - is telemeeserver running?", e);
        }
    }

    public void deleteChannel(Channel channel) {
        try {
            WebResource webResource = this.client.resource(this.baseURI + "telemee/resources/channels/" + channel.getId());
            webResource.type("application/json").delete(ClientResponse.class);
        }
        catch (ClientHandlerException | UniformInterfaceException e) {
            LOGGER.log(Level.SEVERE, "Couldn't delete channel " + channel + " - is telemeeserver running?", e);
        }
    }

    public void deleteChannelAttribute(ChannelAttribute channelAttribute) {
        try {
            WebResource webResource = this.client.resource(this.baseURI + "telemee/resources/channelattributes/" + channelAttribute.getId());
            webResource.type("application/json").delete(ClientResponse.class);
        }
        catch (ClientHandlerException | UniformInterfaceException e) {
            LOGGER.log(Level.SEVERE, "Couldn't delete channelAttribute " + channelAttribute + " - is telemeeserver running?", e);
        }
    }

    public void deleteLogEntries(Channel channel) {
        try {
            WebResource webResource = this.client.resource(this.baseURI + "telemee/resources/logentries/deleteByChannelId/" + channel.getId());
            webResource.type("application/json").delete(ClientResponse.class);
        }
        catch (ClientHandlerException | UniformInterfaceException e) {
            LOGGER.log(Level.SEVERE, "Couldn't delete logentries of channel " + channel + " - is telemeeserver running?", e);
        }
    }

    long getIDFromJson(String json) {
        int start = json.indexOf("\"id\":") + "\"id\":".length() + 1;
        int end = json.indexOf(34, start);
        long id = Long.parseLong(json.substring(start, end));
        return id;
    }

    public long getLogEntriesCount(Channel channel) {
        long count = 0L;
        try {
            WebResource webResource = this.client.resource(this.baseURI + "telemee/resources/logentries/countByChannelId/" + channel.getId());
            String strCount = (String)webResource.accept(new String[]{"text/plain"}).get(String.class);
            count = Long.valueOf(strCount);
        }
        catch (ClientHandlerException | UniformInterfaceException e) {
            LOGGER.log(Level.SEVERE, "Couldn't get logentries count - is telemeeserver running?", e);
        }
        return count;
    }
}

