/*
 * Decompiled with CFR 0.152.
 */
package dev.acdcjunior.immutable;

import dev.acdcjunior.immutable.IListUtils;
import dev.acdcjunior.immutable.IOption;
import dev.acdcjunior.immutable.fn.IFunction;
import dev.acdcjunior.immutable.fn.IPredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IList<T>
implements Iterable<T> {
    public static final int ARRAYLIST_DEFAULT_CAPACITY = 10;
    public static final IList EMPTY_ILIST = new IList(Collections.emptyList());
    @NotNull
    private final List<T> immutableBackingList;

    @NotNull
    @Contract(pure=true)
    public static <T> IList<T> listOf(@Nullable Iterator<T> iterator) {
        if (iterator == null) {
            return IList.emptyList();
        }
        return new IList<T>(IListUtils.toArrayList(iterator));
    }

    @NotNull
    @Contract(pure=true)
    public static <T> IList<T> listOf(@Nullable Iterable<T> iterable) {
        return IList.listOf(iterable == null ? null : iterable.iterator());
    }

    private static <T> IList<T> listOfVarags(T ... items) {
        if (items == null || items.length == 0) {
            return IList.emptyList();
        }
        return new IList<T>(new ArrayList<T>(Arrays.asList(items)));
    }

    @NotNull
    @Contract(pure=true)
    public static <T> IList<T> listOf(T t1) {
        return IList.listOfVarags(t1);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> IList<T> listOf(T t1, T t2) {
        return IList.listOfVarags(t1, t2);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> IList<T> listOf(T t1, T t2, T t3) {
        return IList.listOfVarags(t1, t2, t3);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> IList<T> listOf(T t1, T t2, T t3, T t4) {
        return IList.listOfVarags(t1, t2, t3, t4);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> IList<T> listOf(T t1, T t2, T t3, T t4, T t5) {
        return IList.listOfVarags(t1, t2, t3, t4, t5);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> IList<T> listOf(T t1, T t2, T t3, T t4, T t5, T t6) {
        return IList.listOfVarags(t1, t2, t3, t4, t5, t6);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> IList<T> listOf(T t1, T t2, T t3, T t4, T t5, T t6, T t7) {
        return IList.listOfVarags(t1, t2, t3, t4, t5, t6, t7);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> IList<T> listOf(T t1, T t2, T t3, T t4, T t5, T t6, T t7, T t8) {
        return IList.listOfVarags(t1, t2, t3, t4, t5, t6, t7, t8);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> IList<T> listOf(T t1, T t2, T t3, T t4, T t5, T t6, T t7, T t8, T t9) {
        return IList.listOfVarags(t1, t2, t3, t4, t5, t6, t7, t8, t9);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> IList<T> listOf(T t1, T t2, T t3, T t4, T t5, T t6, T t7, T t8, T t9, T t10) {
        return IList.listOfVarags(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> IList<T> listOf(T ... items) {
        return IList.listOfVarags(items);
    }

    public static <T> IList<T> emptyList() {
        return EMPTY_ILIST;
    }

    private IList(@NotNull List<T> immutableBackingList) {
        this.immutableBackingList = immutableBackingList;
    }

    public boolean equals(Object o) {
        if (o instanceof IList) {
            return this.immutableBackingList.equals(((IList)o).immutableBackingList);
        }
        return this.immutableBackingList.equals(o);
    }

    public int hashCode() {
        return this.immutableBackingList.hashCode();
    }

    public String toString() {
        return this.immutableBackingList.toString();
    }

    @NotNull
    @Contract(pure=true)
    public List<T> toList() {
        return this.immutableBackingList;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.immutableBackingList.iterator();
    }

    @Contract(pure=true)
    public int size() {
        return this.immutableBackingList.size();
    }

    @NotNull
    @Contract(pure=true)
    public <R> IList<R> map(@NotNull IFunction<? super T, ? extends R> mapper) {
        ArrayList<R> rs = new ArrayList<R>(this.size());
        for (T item : this) {
            rs.add(mapper.apply(item));
        }
        return new IList(rs);
    }

    @NotNull
    @Contract(pure=true)
    public IList<T> filter(@NotNull IPredicate<? super T> predicate) {
        ArrayList<T> rs = new ArrayList<T>(this.size());
        for (T item : this) {
            if (!predicate.test(item)) continue;
            rs.add(item);
        }
        return new IList(rs);
    }

    private IList<T> concatVarargs(Iterable<? extends T> ... iterables) {
        ArrayList<T> ls = new ArrayList<T>(this.immutableBackingList.size() + iterables.length * 10);
        ls.addAll(this.immutableBackingList);
        for (Iterable<T> iterable : iterables) {
            for (T item : iterable) {
                ls.add(item);
            }
        }
        return new IList(ls);
    }

    @NotNull
    @Contract(pure=true)
    public final IList<T> concat(Iterable<? extends T> it1) {
        return this.concatVarargs(it1);
    }

    @NotNull
    @Contract(pure=true)
    public final IList<T> concat(Iterable<? extends T> it1, Iterable<? extends T> it2) {
        return this.concatVarargs(it1, it2);
    }

    @NotNull
    @Contract(pure=true)
    public final IList<T> concat(Iterable<? extends T> it1, Iterable<? extends T> it2, Iterable<? extends T> it3) {
        return this.concatVarargs(it1, it2, it3);
    }

    @NotNull
    @Contract(pure=true)
    public final IList<T> concat(Iterable<? extends T> it1, Iterable<? extends T> it2, Iterable<? extends T> it3, Iterable<? extends T> it4) {
        return this.concatVarargs(it1, it2, it3, it4);
    }

    @NotNull
    @Contract(pure=true)
    public final IList<T> concat(Iterable<? extends T> it1, Iterable<? extends T> it2, Iterable<? extends T> it3, Iterable<? extends T> it4, Iterable<? extends T> it5) {
        return this.concatVarargs(it1, it2, it3, it4, it5);
    }

    @NotNull
    @Contract(pure=true)
    public final IList<T> concat(Iterable<? extends T> ... iterables) {
        return this.concatVarargs(iterables);
    }

    @NotNull
    @Contract(pure=true)
    public IList<T> filterNonNull() {
        return this.filter(new IPredicate<T>(){

            @Override
            public boolean test(@Nullable T t) {
                return t != null;
            }
        });
    }

    @NotNull
    @Contract(pure=true)
    public IList<T> distinct() {
        return IList.listOf(new LinkedHashSet<T>(this.immutableBackingList).iterator());
    }

    @NotNull
    @Contract(pure=true)
    public IList<T> subtract(@NotNull Iterable<T> other) {
        final List<T> otherLs = IListUtils.toArrayList(other);
        return this.filter(new IPredicate<T>(){

            @Override
            public boolean test(@Nullable T t) {
                return !otherLs.contains(t);
            }
        });
    }

    private IList<T> subtractVarags(T ... c) {
        return this.subtract((T)IList.listOf(c));
    }

    @NotNull
    @Contract(pure=true)
    public IList<T> subtract(T t1) {
        return this.subtractVarags(t1);
    }

    @NotNull
    @Contract(pure=true)
    public IList<T> subtract(T t1, T t2) {
        return this.subtractVarags(t1, t2);
    }

    @NotNull
    @Contract(pure=true)
    public IList<T> subtract(T t1, T t2, T t3) {
        return this.subtractVarags(t1, t2, t3);
    }

    @NotNull
    @Contract(pure=true)
    public IList<T> subtract(T t1, T t2, T t3, T t4) {
        return this.subtractVarags(t1, t2, t3, t4);
    }

    @NotNull
    @Contract(pure=true)
    public IList<T> subtract(T t1, T t2, T t3, T t4, T t5) {
        return this.subtractVarags(t1, t2, t3, t4, t5);
    }

    @NotNull
    @Contract(pure=true)
    public IList<T> subtract(T ... c) {
        return this.subtractVarags(c);
    }

    private IList<T> plusVarargs(Iterable<? extends T> ... others) {
        return this.concat(others);
    }

    @NotNull
    @Contract(pure=true)
    public IList<T> plus(@NotNull Iterable<? extends T> it1) {
        return this.plusVarargs(it1);
    }

    @NotNull
    @Contract(pure=true)
    public IList<T> plus(@NotNull Iterable<? extends T> it1, @NotNull Iterable<? extends T> it2) {
        return this.plusVarargs(it1, it2);
    }

    @NotNull
    @Contract(pure=true)
    public IList<T> plus(@NotNull Iterable<? extends T> it1, @NotNull Iterable<? extends T> it2, @NotNull Iterable<? extends T> it3) {
        return this.plusVarargs(it1, it2, it3);
    }

    @NotNull
    @Contract(pure=true)
    public IList<T> plus(@NotNull Iterable<? extends T> it1, @NotNull Iterable<? extends T> it2, @NotNull Iterable<? extends T> it3, @NotNull Iterable<? extends T> it4) {
        return this.plusVarargs(it1, it2, it3, it4);
    }

    @NotNull
    @Contract(pure=true)
    public IList<T> plus(@NotNull Iterable<? extends T> it1, @NotNull Iterable<? extends T> it2, @NotNull Iterable<? extends T> it3, @NotNull Iterable<? extends T> it4, @NotNull Iterable<? extends T> it5) {
        return this.plusVarargs(it1, it2, it3, it4, it5);
    }

    @NotNull
    @Contract(pure=true)
    public IList<T> plus(Iterable<? extends T> ... others) {
        return this.plusVarargs(others);
    }

    private IList<T> plusVarargs(T ... c) {
        return this.plusVarargs(new Iterable[]{IList.listOf(c)});
    }

    @NotNull
    @Contract(pure=true)
    public IList<T> plus(T t1) {
        return this.plusVarargs(t1);
    }

    @NotNull
    @Contract(pure=true)
    public IList<T> plus(T t1, T t2) {
        return this.plusVarargs(t1, t2);
    }

    @NotNull
    @Contract(pure=true)
    public IList<T> plus(T t1, T t2, T t3) {
        return this.plusVarargs(t1, t2, t3);
    }

    @NotNull
    @Contract(pure=true)
    public IList<T> plus(T t1, T t2, T t3, T t4) {
        return this.plusVarargs(t1, t2, t3, t4);
    }

    @NotNull
    @Contract(pure=true)
    public IList<T> plus(T t1, T t2, T t3, T t4, T t5) {
        return this.plusVarargs(t1, t2, t3, t4, t5);
    }

    @NotNull
    @Contract(pure=true)
    public IList<T> plus(T ... c) {
        return this.plusVarargs(c);
    }

    @Contract(pure=true)
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Contract(pure=true)
    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @Contract(pure=true)
    public IOption<T> first() {
        if (this.isEmpty()) {
            return IOption.none();
        }
        return IOption.some(this.immutableBackingList.get(0));
    }
}

