/*
 * Decompiled with CFR 0.152.
 */
package e.java;

import e.java.E;
import e.java.Encoder;
import java.util.Map;
import java.util.StringJoiner;

public final class JsonStringEncoder
implements Encoder<String> {
    private static JsonStringEncoder instance;

    private JsonStringEncoder() {
    }

    public static JsonStringEncoder get() {
        if (instance == null) {
            instance = new JsonStringEncoder();
        }
        return instance;
    }

    public String encode(E e) {
        StringJoiner stringJoiner = new StringJoiner(",", "{", "}");
        if (e.hasName()) {
            stringJoiner.add(String.format("\"name\":\"%s\"", this.escape(e.name())));
        }
        if (e.hasMessage()) {
            stringJoiner.add(String.format("\"message\":\"%s\"", this.escape(e.message())));
        }
        if (e.hasCode()) {
            stringJoiner.add(String.format("\"code\":%d", e.code()));
        }
        if (e.hasCause()) {
            stringJoiner.add(String.format("\"cause\":%s", this.encodeCause(e)));
        }
        if (e.hasData()) {
            stringJoiner.add(String.format("\"data\":%s", this.encodeData(e)));
        }
        return stringJoiner.toString();
    }

    private String encodeData(E e) {
        StringJoiner stringJoiner = new StringJoiner(",", "{", "}");
        for (Map.Entry entry : e.data().entrySet()) {
            stringJoiner.add(String.format("\"%s\":\"%s\"", this.escape((String)entry.getKey()), this.escape((String)entry.getValue())));
        }
        return stringJoiner.toString();
    }

    private String encodeCause(E e) {
        return e.cause() == null ? "null" : String.format("\"%s\"", this.escape(((Throwable)e.cause()).getMessage()));
    }

    private String escape(String string) {
        return string.replace("\"", "\\\"");
    }
}

