/*
 * Decompiled with CFR 0.152.
 */
package e.java;

import e.java.EException;
import e.java.EOr;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Supplier;

public final class E {
    private final Integer code;
    private final String name;
    private final String message;
    private final List<E> causes;
    private final Map<String, String> data;
    private final Long time;
    public static final E empty = new E(null, null, null, null, null, null);

    public E(Integer n, String string, String string2, List<E> linkedList, Map<String, String> linkedHashMap, Long l) {
        this.code = n;
        this.name = string;
        this.message = string2;
        this.causes = linkedList == null ? new LinkedList() : linkedList;
        this.data = linkedHashMap == null ? new LinkedHashMap() : linkedHashMap;
        this.time = l;
    }

    public Optional<Integer> code() {
        return Optional.ofNullable(this.code);
    }

    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    public Optional<String> message() {
        return Optional.ofNullable(this.message);
    }

    public List<E> causes() {
        return Collections.unmodifiableList(this.causes);
    }

    public Map<String, String> data() {
        return this.data;
    }

    public Optional<Long> time() {
        return Optional.ofNullable(this.time);
    }

    public E code(int n) {
        return new E(n, this.name, this.message, this.causes, this.data, this.time);
    }

    public E name(String string) {
        return new E(this.code, string, this.message, this.causes, this.data, this.time);
    }

    public E message(String string) {
        return new E(this.code, this.name, string, this.causes, this.data, this.time);
    }

    public E causes(List<E> list) {
        LinkedList<E> linkedList = new LinkedList<E>(this.causes);
        linkedList.addAll(list);
        return new E(this.code, this.name, this.message, linkedList, this.data, this.time);
    }

    public E causes(E ... eArray) {
        LinkedList<E> linkedList = new LinkedList<E>(this.causes);
        linkedList.addAll(Arrays.asList(eArray));
        return new E(this.code, this.name, this.message, linkedList, this.data, this.time);
    }

    public E cause(E e) {
        LinkedList<E> linkedList = new LinkedList<E>(this.causes);
        linkedList.add(e);
        return new E(this.code, this.name, this.message, linkedList, this.data, this.time);
    }

    public E data(Map<String, String> map) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(this.data);
        linkedHashMap.putAll(map);
        return new E(this.code, this.name, this.message, this.causes, linkedHashMap, this.time);
    }

    public <V> E data(String string, V v) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(this.data);
        linkedHashMap.put(string, String.valueOf(v));
        return new E(this.code, this.name, this.message, this.causes, linkedHashMap, this.time);
    }

    public E time(long l) {
        return new E(this.code, this.name, this.message, this.causes, this.data, l);
    }

    public E now() {
        return new E(this.code, this.name, this.message, this.causes, this.data, System.currentTimeMillis());
    }

    public E causeIf(boolean bl, Supplier<E> supplier) {
        if (bl) {
            LinkedList<E> linkedList = new LinkedList<E>(this.causes);
            linkedList.add(supplier.get());
            return new E(this.code, this.name, this.message, linkedList, this.data, this.time);
        }
        return this;
    }

    public boolean hasCode() {
        return this.code != null;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public boolean hasCause() {
        return !this.causes.isEmpty();
    }

    public boolean hasData() {
        return !this.data.isEmpty();
    }

    public boolean hasTime() {
        return this.time != null;
    }

    public <A> EOr<A> toEOr() {
        return EOr.from(this);
    }

    public EException toException() {
        return new EException(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof E)) {
            return false;
        }
        E e = (E)object;
        return Objects.equals(this.code, e.code) && Objects.equals(this.name, e.name) && Objects.equals(this.message, e.message) && this.causes.equals(e.causes) && this.data.equals(e.data) && Objects.equals(this.time, e.time);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.name, this.message, this.causes, this.data, this.time);
    }

    public String toString() {
        class Quoter {
            Quoter(E e) {
            }

            public String quote(String string) {
                return string.replaceAll("\"", "\\\"");
            }
        }
        Quoter quoter = new Quoter(this);
        StringJoiner stringJoiner = new StringJoiner(",", "{", "}");
        StringJoiner stringJoiner2 = new StringJoiner(",", "[", "]");
        StringJoiner stringJoiner3 = new StringJoiner(",", "{", "}");
        if (this.hasCode()) {
            stringJoiner.add(String.format("\"code\":%d", this.code));
        }
        if (this.hasName()) {
            stringJoiner.add(String.format("\"name\":\"%s\"", quoter.quote(this.name)));
        }
        if (this.hasMessage()) {
            stringJoiner.add(String.format("\"message\":\"%s\"", quoter.quote(this.message)));
        }
        if (this.hasCause()) {
            this.causes.forEach(e -> stringJoiner2.add(e.toString()));
            stringJoiner.add(String.format("\"causes\":%s", stringJoiner2.toString()));
        }
        if (this.hasData()) {
            this.data.forEach((string, string2) -> stringJoiner3.add(String.format("\"%s\":\"%s\"", quoter.quote((String)string), quoter.quote((String)string2))));
            stringJoiner.add(String.format("\"data\":%s", stringJoiner3.toString()));
        }
        if (this.hasTime()) {
            stringJoiner.add(String.format("\"time\":%d", this.time));
        }
        return stringJoiner.toString();
    }

    public static E fromCode(int n) {
        return new E(n, null, null, null, null, null);
    }

    public static E fromName(String string) {
        return new E(null, string, null, null, null, null);
    }

    public static E fromMessage(String string) {
        return new E(null, null, string, null, null, null);
    }

    public static E fromCauses(List<E> list) {
        return new E(null, null, null, list, null, null);
    }

    public static E fromCauses(E ... eArray) {
        return new E(null, null, null, Arrays.asList(eArray), null, null);
    }

    public static E fromCause(E e) {
        return new E(null, null, null, Collections.singletonList(e), null, null);
    }

    public static E fromData(Map<String, String> map) {
        return new E(null, null, null, null, map, null);
    }

    public static <V> E fromData(String string, V v) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put(string, String.valueOf(v));
        return new E(null, null, null, null, linkedHashMap, null);
    }

    public static E fromTime(Long l) {
        return new E(null, null, null, null, null, l);
    }

    public static E fromNow() {
        return new E(null, null, null, null, null, System.currentTimeMillis());
    }

    public static E fromCauseIf(boolean bl, Supplier<E> supplier) {
        if (bl) {
            LinkedList<E> linkedList = new LinkedList<E>();
            linkedList.add(supplier.get());
            return new E(null, null, null, linkedList, null, null);
        }
        return empty;
    }

    public static E fromThrowable(Throwable throwable) {
        if (throwable instanceof EException) {
            return ((EException)throwable).e;
        }
        return E.fromMessage(throwable.getMessage());
    }
}

