/*
 * Decompiled with CFR 0.152.
 */
package dev.bpmcrafters.processengineapi.impl.task;

import dev.bpmcrafters.processengineapi.Empty;
import dev.bpmcrafters.processengineapi.impl.task.AbstractTaskSubscriptionApiImplKt;
import dev.bpmcrafters.processengineapi.impl.task.SubscriptionRepository;
import dev.bpmcrafters.processengineapi.impl.task.TaskSubscriptionHandle;
import dev.bpmcrafters.processengineapi.task.SubscribeForTaskCmd;
import dev.bpmcrafters.processengineapi.task.TaskHandler;
import dev.bpmcrafters.processengineapi.task.TaskSubscription;
import dev.bpmcrafters.processengineapi.task.TaskSubscriptionApi;
import dev.bpmcrafters.processengineapi.task.TaskTerminationHandler;
import dev.bpmcrafters.processengineapi.task.TaskType;
import dev.bpmcrafters.processengineapi.task.UnsubscribeFromTaskCmd;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\u0006\u0010\u000e\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/bpmcrafters/processengineapi/impl/task/AbstractTaskSubscriptionApiImpl;", "Ldev/bpmcrafters/processengineapi/task/TaskSubscriptionApi;", "subscriptionRepository", "Ldev/bpmcrafters/processengineapi/impl/task/SubscriptionRepository;", "(Ldev/bpmcrafters/processengineapi/impl/task/SubscriptionRepository;)V", "ensure", "Ldev/bpmcrafters/processengineapi/impl/task/TaskSubscriptionHandle;", "subscription", "Ldev/bpmcrafters/processengineapi/task/TaskSubscription;", "getSupportedRestrictions", "", "", "subscribeForTask", "Ljava/util/concurrent/Future;", "cmd", "Ldev/bpmcrafters/processengineapi/task/SubscribeForTaskCmd;", "unsubscribe", "Ldev/bpmcrafters/processengineapi/Empty;", "Ldev/bpmcrafters/processengineapi/task/UnsubscribeFromTaskCmd;", "process-engine-api-impl"})
public abstract class AbstractTaskSubscriptionApiImpl
implements TaskSubscriptionApi {
    @NotNull
    private final SubscriptionRepository subscriptionRepository;

    public AbstractTaskSubscriptionApiImpl(@NotNull SubscriptionRepository subscriptionRepository) {
        Intrinsics.checkNotNullParameter((Object)subscriptionRepository, (String)"subscriptionRepository");
        this.subscriptionRepository = subscriptionRepository;
    }

    @NotNull
    public Future<TaskSubscription> subscribeForTask(@NotNull SubscribeForTaskCmd cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        String string = cmd.getTaskDescriptionKey();
        Set set = cmd.getPayloadDescription();
        Map map = cmd.getRestrictions();
        TaskHandler taskHandler = cmd.getAction();
        TaskType taskType = cmd.getTaskType();
        TaskTerminationHandler taskTerminationHandler = cmd.getTermination();
        TaskSubscriptionHandle it = new TaskSubscriptionHandle(taskType, set, map, string, taskHandler, taskTerminationHandler);
        boolean bl = false;
        this.subscriptionRepository.createTaskSubscription(it);
        AbstractTaskSubscriptionApiImplKt.access$getLogger$p().info((Function0)new Function0<Object>(it){
            final /* synthetic */ TaskSubscriptionHandle $it;
            {
                this.$it = $it;
                super(0);
            }

            public final Object invoke() {
                return "PROCESS-ENGINE-API-001: Registered new task subscription " + this.$it;
            }
        });
        CompletableFuture<TaskSubscriptionHandle> completableFuture = CompletableFuture.completedFuture(it);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"let(...)");
        return completableFuture;
    }

    @NotNull
    public Future<Empty> unsubscribe(@NotNull UnsubscribeFromTaskCmd cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        this.subscriptionRepository.deleteTaskSubscription(this.ensure(cmd.getSubscription()));
        AbstractTaskSubscriptionApiImplKt.access$getLogger$p().info((Function0)new Function0<Object>(cmd){
            final /* synthetic */ UnsubscribeFromTaskCmd $cmd;
            {
                this.$cmd = $cmd;
                super(0);
            }

            public final Object invoke() {
                return "PROCESS-ENGINE-API-002: Un-registered new task subscription " + this.$cmd.getSubscription();
            }
        });
        CompletableFuture<Empty> completableFuture = CompletableFuture.completedFuture(Empty.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @NotNull
    public Set<String> getSupportedRestrictions() {
        return SetsKt.emptySet();
    }

    private final TaskSubscriptionHandle ensure(TaskSubscription subscription) {
        if (!(subscription instanceof TaskSubscriptionHandle)) {
            boolean bl = false;
            String string = "Only subscriptions of type " + TaskSubscriptionHandle.class.getName() + " are supported, but got " + subscription.getClass().getName() + ".";
            throw new IllegalArgumentException(string.toString());
        }
        return (TaskSubscriptionHandle)subscription;
    }

    public boolean areSupported(@NotNull Map<String, String> restrictions) {
        return TaskSubscriptionApi.DefaultImpls.areSupported((TaskSubscriptionApi)this, restrictions);
    }

    @NotNull
    public Map<String, String> ensureSupported(@NotNull Map<String, String> restrictions) {
        return TaskSubscriptionApi.DefaultImpls.ensureSupported((TaskSubscriptionApi)this, restrictions);
    }
}

