/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.types.HttpOptions;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import lombok.Generated;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BraintrustApiClient
extends ApiClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BraintrustApiClient.class);
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private final ApiClient delegate;
    private final Tracer tracer;

    public BraintrustApiClient(ApiClient delegate, OpenTelemetry openTelemetry) {
        super(delegate.apiKey != null ? delegate.apiKey : Optional.empty(), delegate.project != null ? delegate.project : Optional.empty(), delegate.location != null ? delegate.location : Optional.empty(), delegate.credentials != null ? delegate.credentials : Optional.empty(), delegate.httpOptions != null ? Optional.of(delegate.httpOptions) : Optional.empty(), delegate.clientOptions != null ? delegate.clientOptions : Optional.empty());
        this.delegate = delegate;
        this.tracer = openTelemetry.getTracer("io.opentelemetry.gemini-java-1.20");
    }

    private void tagSpan(Span span, @Nullable String genAIEndpoint, @Nullable String requestMethod, @Nullable String requestBody, @Nullable String responseBody) {
        try {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("provider", "gemini");
            if (requestBody != null) {
                Map requestJson = (Map)JSON_MAPPER.readValue(requestBody, Map.class);
                for (String string : List.of("model", "systemInstruction", "tools", "toolConfig", "safetySettings", "cachedContent")) {
                    if (!requestJson.containsKey(string)) continue;
                    metadata.put(string, (String)requestJson.get(string));
                }
                if (requestJson.get("generationConfig") instanceof Map) {
                    Map genConfig = (Map)requestJson.get("generationConfig");
                    for (String field : List.of("temperature", "topP", "topK", "candidateCount", "maxOutputTokens", "stopSequences", "responseMimeType", "responseSchema")) {
                        if (!genConfig.containsKey(field)) continue;
                        metadata.put(field, (String)genConfig.get(field));
                    }
                }
                HashMap inputJson = new HashMap();
                String string = BraintrustApiClient.getModel(genAIEndpoint);
                if (requestJson.containsKey("model")) {
                    inputJson.put("model", requestJson.get("model"));
                } else if (string != null) {
                    inputJson.put("model", string);
                }
                if (requestJson.containsKey("contents")) {
                    inputJson.put("contents", requestJson.get("contents"));
                }
                if (requestJson.containsKey("generationConfig")) {
                    inputJson.put("config", requestJson.get("generationConfig"));
                }
                span.setAttribute("braintrust.input_json", JSON_MAPPER.writeValueAsString(inputJson));
            }
            if (responseBody != null) {
                Map responseJson = (Map)JSON_MAPPER.readValue(responseBody, Map.class);
                if (responseJson.containsKey("modelVersion")) {
                    metadata.put("model", (String)responseJson.get("modelVersion"));
                }
                span.setAttribute("braintrust.output_json", JSON_MAPPER.writeValueAsString((Object)responseJson));
                if (responseJson.get("usageMetadata") instanceof Map) {
                    Map usage = (Map)responseJson.get("usageMetadata");
                    HashMap<String, Number> hashMap = new HashMap<String, Number>();
                    if (usage.containsKey("promptTokenCount")) {
                        hashMap.put("prompt_tokens", (Number)usage.get("promptTokenCount"));
                    }
                    if (usage.containsKey("candidatesTokenCount")) {
                        hashMap.put("completion_tokens", (Number)usage.get("candidatesTokenCount"));
                    }
                    if (usage.containsKey("totalTokenCount")) {
                        hashMap.put("tokens", (Number)usage.get("totalTokenCount"));
                    }
                    if (usage.containsKey("cachedContentTokenCount")) {
                        hashMap.put("prompt_cached_tokens", (Number)usage.get("cachedContentTokenCount"));
                    }
                    span.setAttribute("braintrust.metrics", JSON_MAPPER.writeValueAsString(hashMap));
                }
            }
            span.setAttribute("braintrust.metadata", JSON_MAPPER.writeValueAsString(metadata));
            span.setAttribute("braintrust.span_attributes", JSON_MAPPER.writeValueAsString(Map.of("type", "llm")));
        }
        catch (Throwable t) {
            log.warn("failed to tag gemini span", t);
        }
    }

    public boolean vertexAI() {
        return this.delegate.vertexAI();
    }

    public String project() {
        return this.delegate.project();
    }

    public String location() {
        return this.delegate.location();
    }

    public String apiKey() {
        return this.delegate.apiKey();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ApiResponse request(String requestMethod, String genAIUrl, String requestBody, Optional<HttpOptions> options) {
        Span span = this.tracer.spanBuilder(BraintrustApiClient.getOperation(genAIUrl)).setSpanKind(SpanKind.CLIENT).startSpan();
        try {
            BufferedApiResponse bufferedApiResponse;
            block13: {
                Scope scope = span.makeCurrent();
                try {
                    ApiResponse response = this.delegate.request(requestMethod, genAIUrl, requestBody, options);
                    BufferedApiResponse bufferedResponse = new BufferedApiResponse(response);
                    span.setStatus(StatusCode.OK);
                    this.tagSpan(span, genAIUrl, requestMethod, requestBody, bufferedResponse.getBodyAsString());
                    bufferedApiResponse = bufferedResponse;
                    if (scope == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.setStatus(StatusCode.ERROR, t.getMessage());
                        span.recordException(t);
                        throw t;
                    }
                }
                scope.close();
            }
            return bufferedApiResponse;
        }
        finally {
            span.end();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ApiResponse request(String requestMethod, String genAIUrl, byte[] requestBodyBytes, Optional<HttpOptions> options) {
        Span span = this.tracer.spanBuilder(BraintrustApiClient.getOperation(genAIUrl)).setSpanKind(SpanKind.CLIENT).startSpan();
        try {
            BufferedApiResponse bufferedApiResponse;
            block13: {
                Scope scope = span.makeCurrent();
                try {
                    ApiResponse response = this.delegate.request(requestMethod, genAIUrl, requestBodyBytes, options);
                    BufferedApiResponse bufferedResponse = new BufferedApiResponse(response);
                    span.setStatus(StatusCode.OK);
                    this.tagSpan(span, genAIUrl, requestMethod, new String(requestBodyBytes), bufferedResponse.getBodyAsString());
                    bufferedApiResponse = bufferedResponse;
                    if (scope == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.setStatus(StatusCode.ERROR, t.getMessage());
                        span.recordException(t);
                        throw t;
                    }
                }
                scope.close();
            }
            return bufferedApiResponse;
        }
        finally {
            span.end();
        }
    }

    public CompletableFuture<ApiResponse> asyncRequest(String method, String url, String body, Optional<HttpOptions> options) {
        Span span = this.tracer.spanBuilder(BraintrustApiClient.getOperation(url)).setSpanKind(SpanKind.CLIENT).startSpan();
        Context context = Context.current().with((ImplicitContextKeyed)span);
        return this.delegate.asyncRequest(method, url, body, options).handle((response, throwable) -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public CompletableFuture<ApiResponse> asyncRequest(String method, String url, byte[] body, Optional<HttpOptions> options) {
        Span span = this.tracer.spanBuilder(BraintrustApiClient.getOperation(url)).setSpanKind(SpanKind.CLIENT).startSpan();
        Context context = Context.current().with((ImplicitContextKeyed)span);
        return this.delegate.asyncRequest(method, url, body, options).handle((response, throwable) -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    private static String getModel(String genAIEndpoint) {
        try {
            String[] segments = genAIEndpoint.split("/");
            String[] lastSegment = segments[segments.length - 1].split(":");
            return lastSegment[0];
        }
        catch (Exception e) {
            log.debug("unable to determine model name", (Throwable)e);
            return "gemini";
        }
    }

    private static String getOperation(String genAIEndpoint) {
        try {
            String[] segments = genAIEndpoint.split("/");
            String[] lastSegment = segments[segments.length - 1].split(":");
            return BraintrustApiClient.toSnakeCase(lastSegment[1]);
        }
        catch (Exception e) {
            log.debug("unable to determine operation name", (Throwable)e);
            return "gemini.api.call";
        }
    }

    private static String toSnakeCase(String camelCase) {
        if (camelCase == null || camelCase.isEmpty()) {
            return camelCase;
        }
        StringBuilder sb = new StringBuilder(camelCase.length() + 5);
        for (int i = 0; i < camelCase.length(); ++i) {
            char c = camelCase.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    sb.append('_');
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static class BufferedApiResponse
    extends ApiResponse {
        private final ApiResponse delegate;
        private final byte[] bufferedBody;

        public BufferedApiResponse(ApiResponse delegate) throws Exception {
            this.delegate = delegate;
            ResponseBody body = delegate.getBody();
            this.bufferedBody = body != null ? body.bytes() : null;
        }

        public ResponseBody getBody() {
            if (this.bufferedBody == null) {
                return null;
            }
            MediaType contentType = null;
            try {
                ResponseBody originalBody = this.delegate.getBody();
                if (originalBody != null) {
                    contentType = originalBody.contentType();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ResponseBody.create((byte[])this.bufferedBody, contentType);
        }

        public Headers getHeaders() {
            return this.delegate.getHeaders();
        }

        public void close() {
            this.delegate.close();
        }

        public String getBodyAsString() {
            return this.bufferedBody != null ? new String(this.bufferedBody) : null;
        }
    }
}

