/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.google.genai.ApiClient;
import com.google.genai.BraintrustApiClient;
import com.google.genai.Client;
import io.opentelemetry.api.OpenTelemetry;
import java.lang.reflect.Field;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BraintrustInstrumentation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BraintrustInstrumentation.class);

    public static Client wrapClient(Client client, OpenTelemetry openTelemetry) throws Exception {
        Field clientApiClientField = Client.class.getDeclaredField("apiClient");
        clientApiClientField.setAccessible(true);
        ApiClient originalApiClient = (ApiClient)clientApiClientField.get(client);
        BraintrustApiClient instrumentedApiClient = new BraintrustApiClient(originalApiClient, openTelemetry);
        BraintrustInstrumentation.setFinalField(client, clientApiClientField, (Object)instrumentedApiClient);
        BraintrustInstrumentation.replaceApiClientInService(client.models, instrumentedApiClient);
        BraintrustInstrumentation.replaceApiClientInService(client.batches, instrumentedApiClient);
        BraintrustInstrumentation.replaceApiClientInService(client.caches, instrumentedApiClient);
        BraintrustInstrumentation.replaceApiClientInService(client.operations, instrumentedApiClient);
        BraintrustInstrumentation.replaceApiClientInService(client.chats, instrumentedApiClient);
        BraintrustInstrumentation.replaceApiClientInService(client.files, instrumentedApiClient);
        BraintrustInstrumentation.replaceApiClientInService(client.tunings, instrumentedApiClient);
        if (client.async != null) {
            BraintrustInstrumentation.replaceApiClientInService(client.async.models, instrumentedApiClient);
            BraintrustInstrumentation.replaceApiClientInService(client.async.batches, instrumentedApiClient);
            BraintrustInstrumentation.replaceApiClientInService(client.async.caches, instrumentedApiClient);
            BraintrustInstrumentation.replaceApiClientInService(client.async.operations, instrumentedApiClient);
            BraintrustInstrumentation.replaceApiClientInService(client.async.chats, instrumentedApiClient);
            BraintrustInstrumentation.replaceApiClientInService(client.async.files, instrumentedApiClient);
            BraintrustInstrumentation.replaceApiClientInService(client.async.tunings, instrumentedApiClient);
        }
        log.debug("Successfully instrumented Gemini client");
        return client;
    }

    private static void replaceApiClientInService(Object service, ApiClient instrumentedApiClient) throws Exception {
        if (service == null) {
            return;
        }
        try {
            Field apiClientField = service.getClass().getDeclaredField("apiClient");
            apiClientField.setAccessible(true);
            BraintrustInstrumentation.setFinalField(service, apiClientField, instrumentedApiClient);
        }
        catch (NoSuchFieldException e) {
            log.info("No apiClient field found in " + service.getClass().getSimpleName());
        }
    }

    private static void setFinalField(Object target, Field field, Object value) throws Exception {
        field.setAccessible(true);
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        field.set(target, value);
    }
}

