/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust;

import dev.braintrust.BraintrustUtils;
import dev.braintrust.SDKMain;
import dev.braintrust.api.BraintrustApiClient;
import dev.braintrust.config.BraintrustConfig;
import dev.braintrust.eval.Dataset;
import dev.braintrust.eval.Eval;
import dev.braintrust.prompt.BraintrustPromptLoader;
import dev.braintrust.trace.BraintrustTracing;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.logs.SdkLoggerProviderBuilder;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Braintrust {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Braintrust.class);
    private static final String SDK_VERSION = SDKMain.loadVersionFromProperties();
    private static final AtomicReference<Braintrust> INSTANCE = new AtomicReference();
    private final BraintrustConfig config;
    private final BraintrustApiClient apiClient;
    private final BraintrustPromptLoader promptLoader;

    public static Braintrust get() {
        Braintrust current = INSTANCE.get();
        if (null == current) {
            return Braintrust.get(BraintrustConfig.fromEnvironment());
        }
        return current;
    }

    public static Braintrust get(BraintrustConfig config) {
        Braintrust current = INSTANCE.get();
        if (null == current) {
            return Braintrust.set(Braintrust.of(config));
        }
        return current;
    }

    static Braintrust set(Braintrust braintrust) {
        Braintrust current = INSTANCE.get();
        if (null == current) {
            boolean success = INSTANCE.compareAndSet(null, braintrust);
            if (!success) {
                throw new RuntimeException("set must only be called once");
            }
            log.info("initialized global Braintrust sdk {}", (Object)SDK_VERSION);
            return braintrust;
        }
        return current;
    }

    static void resetForTest() {
        INSTANCE.set(null);
    }

    public static Braintrust of(BraintrustConfig config) {
        BraintrustApiClient apiClient = BraintrustApiClient.of(config);
        BraintrustPromptLoader promptLoader = BraintrustPromptLoader.of(config, apiClient);
        return new Braintrust(config, apiClient, promptLoader);
    }

    Braintrust(BraintrustConfig config, BraintrustApiClient apiClient, BraintrustPromptLoader promptLoader) {
        this.config = config;
        this.apiClient = apiClient;
        this.promptLoader = promptLoader;
    }

    public URI projectUri() {
        return BraintrustUtils.createProjectURI(this.config.appUrl(), this.apiClient().getOrCreateProjectAndOrgInfo(this.config()));
    }

    public OpenTelemetry openTelemetryCreate() {
        return this.openTelemetryCreate(true);
    }

    public OpenTelemetry openTelemetryCreate(boolean registerGlobal) {
        return BraintrustTracing.of(this.config, registerGlobal);
    }

    public void openTelemetryEnable(@Nonnull SdkTracerProviderBuilder tracerProviderBuilder, @Nonnull SdkLoggerProviderBuilder loggerProviderBuilder, @Nonnull SdkMeterProviderBuilder meterProviderBuilder) {
        BraintrustTracing.enable(this.config, tracerProviderBuilder, loggerProviderBuilder, meterProviderBuilder);
    }

    public <INPUT, OUTPUT> Eval.Builder<INPUT, OUTPUT> evalBuilder() {
        return Eval.builder().config(this.config).apiClient(this.apiClient);
    }

    public <INPUT, OUTPUT> Dataset<INPUT, OUTPUT> fetchDataset(String datasetName) {
        return this.fetchDataset(datasetName, null);
    }

    public <INPUT, OUTPUT> Dataset<INPUT, OUTPUT> fetchDataset(String datasetName, @Nullable String datasetVersion) {
        String projectName = this.apiClient.getOrCreateProjectAndOrgInfo(this.config).project().name();
        return Dataset.fetchFromBraintrust(this.apiClient(), projectName, datasetName, datasetVersion);
    }

    @Generated
    public BraintrustConfig config() {
        return this.config;
    }

    @Generated
    public BraintrustApiClient apiClient() {
        return this.apiClient;
    }

    @Generated
    public BraintrustPromptLoader promptLoader() {
        return this.promptLoader;
    }
}

