/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dev.braintrust.api.ApiException;
import dev.braintrust.api.LoginException;
import dev.braintrust.config.BraintrustConfig;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface BraintrustApiClient {
    public LoginResponse login() throws LoginException;

    public Project getOrCreateProject(String var1);

    public Optional<Project> getProject(String var1);

    public Experiment getOrCreateExperiment(CreateExperimentRequest var1);

    public Optional<OrganizationAndProjectInfo> getProjectAndOrgInfo();

    public Optional<OrganizationAndProjectInfo> getProjectAndOrgInfo(String var1);

    public OrganizationAndProjectInfo getOrCreateProjectAndOrgInfo(BraintrustConfig var1);

    public Optional<Prompt> getPrompt(@Nonnull String var1, @Nonnull String var2, @Nullable String var3);

    public DatasetFetchResponse fetchDatasetEvents(String var1, DatasetFetchRequest var2);

    public Optional<Dataset> getDataset(String var1);

    public List<Dataset> queryDatasets(String var1, String var2);

    public static BraintrustApiClient of(BraintrustConfig config) {
        return new HttpImpl(config);
    }

    public static class HttpImpl
    implements BraintrustApiClient {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(HttpImpl.class);
        private final BraintrustConfig config;
        private final HttpClient httpClient;
        private final ObjectMapper objectMapper;

        HttpImpl(BraintrustConfig config) {
            this(config, HttpImpl.createDefaultHttpClient(config));
        }

        private HttpImpl(BraintrustConfig config, HttpClient httpClient) {
            this.config = config;
            this.httpClient = httpClient;
            this.objectMapper = HttpImpl.createObjectMapper();
        }

        @Override
        public Project getOrCreateProject(String projectName) {
            try {
                CreateProjectRequest request = new CreateProjectRequest(projectName);
                return this.postAsync("/v1/project", request, Project.class).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Optional<Project> getProject(String projectId) {
            try {
                return (Optional)((CompletableFuture)this.getAsync("/v1/project/" + projectId, Project.class).handle((project, error) -> {
                    if (error != null && this.isNotFound((Throwable)error)) {
                        return Optional.empty();
                    }
                    if (error != null) {
                        throw new CompletionException((Throwable)error);
                    }
                    return Optional.of(project);
                })).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Experiment getOrCreateExperiment(CreateExperimentRequest request) {
            try {
                return this.postAsync("/v1/experiment", request, Experiment.class).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new ApiException(e);
            }
        }

        @Override
        public LoginResponse login() throws LoginException {
            try {
                return this.postAsync("/api/apikey/login", new LoginRequest(this.config.apiKey()), LoginResponse.class).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new LoginException("Failed to login to Braintrust", e);
            }
        }

        @Override
        public Optional<OrganizationAndProjectInfo> getProjectAndOrgInfo() {
            String projectId = this.config.defaultProjectId().orElse(null);
            if (null == projectId) {
                projectId = this.getOrCreateProject(this.config.defaultProjectName().orElseThrow()).id();
            }
            return this.getProjectAndOrgInfo(projectId);
        }

        @Override
        public Optional<OrganizationAndProjectInfo> getProjectAndOrgInfo(String projectId) {
            Project project = this.getProject(projectId).orElse(null);
            if (null == project) {
                return Optional.empty();
            }
            OrganizationInfo orgInfo = null;
            for (OrganizationInfo org : this.login().orgInfo()) {
                if (!project.orgId().equalsIgnoreCase(org.id())) continue;
                orgInfo = org;
                break;
            }
            if (null == orgInfo) {
                throw new ApiException("Should not happen. Unable to find project's org: " + project.orgId());
            }
            return Optional.of(new OrganizationAndProjectInfo(orgInfo, project));
        }

        @Override
        public OrganizationAndProjectInfo getOrCreateProjectAndOrgInfo(BraintrustConfig config) {
            Project project;
            if (config.defaultProjectId().isPresent()) {
                String projectId = config.defaultProjectId().get();
                project = this.getProject(projectId).orElseThrow(() -> new ApiException("Project with ID '" + projectId + "' not found"));
            } else if (config.defaultProjectName().isPresent()) {
                String projectName = config.defaultProjectName().get();
                project = this.getOrCreateProject(projectName);
            } else {
                throw new ApiException("Either project ID or project name must be provided in config");
            }
            OrganizationInfo orgInfo = null;
            for (OrganizationInfo org : this.login().orgInfo()) {
                if (!project.orgId().equalsIgnoreCase(org.id())) continue;
                orgInfo = org;
                break;
            }
            if (null == orgInfo) {
                throw new ApiException("Unable to find organization for project: " + project.id());
            }
            return new OrganizationAndProjectInfo(orgInfo, project);
        }

        @Override
        public Optional<Prompt> getPrompt(@Nonnull String projectName, @Nonnull String slug, @Nullable String version) {
            Objects.requireNonNull(projectName, slug);
            try {
                PromptListResponse response;
                StringBuilder uriBuilder = new StringBuilder(this.config.apiUrl() + "/v1/prompt?");
                if (!slug.isEmpty()) {
                    uriBuilder.append("slug=").append(slug);
                }
                if (!projectName.isEmpty()) {
                    if (uriBuilder.charAt(uriBuilder.length() - 1) != '?') {
                        uriBuilder.append("&");
                    }
                    uriBuilder.append("project_name=").append(projectName);
                }
                if (version != null && !version.isEmpty()) {
                    if (uriBuilder.charAt(uriBuilder.length() - 1) != '?') {
                        uriBuilder.append("&");
                    }
                    uriBuilder.append("version=").append(version);
                }
                if ((response = this.getAsync(uriBuilder.toString().replace(this.config.apiUrl(), ""), PromptListResponse.class).get()).objects() == null || response.objects().isEmpty()) {
                    return Optional.empty();
                }
                if (response.objects().size() > 1) {
                    throw new ApiException("Multiple objects found for slug: " + slug + ", projectName: " + projectName);
                }
                return Optional.of(response.objects().get(0));
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public DatasetFetchResponse fetchDatasetEvents(String datasetId, DatasetFetchRequest request) {
            try {
                String path = "/v1/dataset/" + datasetId + "/fetch";
                return this.postAsync(path, request, DatasetFetchResponse.class).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new ApiException(e);
            }
        }

        @Override
        public Optional<Dataset> getDataset(String datasetId) {
            try {
                return (Optional)((CompletableFuture)this.getAsync("/v1/dataset/" + datasetId, Dataset.class).handle((dataset, error) -> {
                    if (error != null && this.isNotFound((Throwable)error)) {
                        return Optional.empty();
                    }
                    if (error != null) {
                        throw new CompletionException((Throwable)error);
                    }
                    return Optional.of(dataset);
                })).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public List<Dataset> queryDatasets(String projectName, String datasetName) {
            try {
                String path = "/v1/dataset?project_name=" + projectName + "&dataset_name=" + datasetName;
                DatasetList response = this.getAsync(path, DatasetList.class).get();
                return response.objects();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        private <T> CompletableFuture<T> getAsync(String path, Class<T> responseType) {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.config.apiUrl() + path)).header("Authorization", "Bearer " + this.config.apiKey()).header("Accept", "application/json").timeout(this.config.requestTimeout()).GET().build();
            return this.sendAsync(request, responseType);
        }

        private <T> CompletableFuture<T> postAsync(String path, Object body, Class<T> responseType) {
            try {
                String jsonBody = this.objectMapper.writeValueAsString(body);
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.config.apiUrl() + path)).header("Authorization", "Bearer " + this.config.apiKey()).header("Content-Type", "application/json").header("Accept", "application/json").timeout(this.config.requestTimeout()).POST(HttpRequest.BodyPublishers.ofString(jsonBody)).build();
                return this.sendAsync(request, responseType);
            }
            catch (IOException e) {
                return CompletableFuture.failedFuture(new ApiException("Failed to serialize request body", e));
            }
        }

        private <T> CompletableFuture<T> sendAsync(HttpRequest request, Class<T> responseType) {
            log.debug("API Request: {} {}", (Object)request.method(), (Object)request.uri());
            return this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> this.handleResponse((HttpResponse<String>)response, responseType));
        }

        private <T> T handleResponse(HttpResponse<String> response, Class<T> responseType) {
            log.debug("API Response: {} - {}", (Object)response.statusCode(), (Object)response.body());
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                try {
                    return (T)this.objectMapper.readValue(response.body(), responseType);
                }
                catch (IOException e) {
                    log.warn("Failed to parse response body", (Throwable)e);
                    throw new ApiException("Failed to parse response body", e);
                }
            }
            log.warn("API request failed with status {}: {}", (Object)response.statusCode(), (Object)response.body());
            throw new ApiException(String.format("API request failed with status %d: %s", response.statusCode(), response.body()));
        }

        private boolean isNotFound(Throwable error) {
            Throwable cause = error;
            if (error instanceof CompletionException && error.getCause() != null) {
                cause = error.getCause();
            }
            if (cause instanceof ApiException) {
                return ((ApiException)cause).getMessage().contains("404");
            }
            return false;
        }

        private static HttpClient createDefaultHttpClient(BraintrustConfig config) {
            return HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
        }

        private static ObjectMapper createObjectMapper() {
            return new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module()).setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_ABSENT).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
    }

    public record PromptListResponse(List<Prompt> objects) {
    }

    public record Prompt(String id, String projectId, String orgId, String name, String slug, Optional<String> description, String created, PromptData promptData, Optional<List<String>> tags, Optional<Object> metadata) {
    }

    public record PromptData(Object prompt, Object options) {
    }

    public record OrganizationAndProjectInfo(OrganizationInfo orgInfo, Project project) {
    }

    public record LoginResponse(List<OrganizationInfo> orgInfo) {
    }

    public record LoginRequest(String token) {
    }

    public record OrganizationInfo(String id, String name) {
    }

    public record DatasetFetchResponse(List<Map<String, Object>> events, @Nullable String cursor) {
    }

    public record DatasetFetchRequest(int limit, @Nullable String cursor, @Nullable String version) {
        public DatasetFetchRequest(int limit) {
            this(limit, null, null);
        }

        public DatasetFetchRequest(int limit, @Nullable String cursor) {
            this(limit, cursor, null);
        }
    }

    public record InsertEventsResponse(int insertedCount) {
    }

    public record InsertEventsRequest(List<DatasetEvent> events) {
    }

    public record DatasetEvent(Object input, Optional<Object> output, Optional<Object> metadata) {
        public DatasetEvent(Object input) {
            this(input, Optional.empty(), Optional.empty());
        }

        public DatasetEvent(Object input, Object output) {
            this(input, Optional.of(output), Optional.empty());
        }
    }

    public record DatasetList(List<Dataset> objects) {
    }

    public record Dataset(String id, String projectId, String name, Optional<String> description, String createdAt, String updatedAt) {
    }

    public record CreateDatasetRequest(String projectId, String name, Optional<String> description) {
        public CreateDatasetRequest(String projectId, String name) {
            this(projectId, name, Optional.empty());
        }
    }

    public record Experiment(String id, String projectId, String name, Optional<String> description, String createdAt, String updatedAt) {
    }

    public record CreateExperimentRequest(String projectId, String name, Optional<String> description, Optional<String> baseExperimentId) {
        public CreateExperimentRequest(String projectId, String name) {
            this(projectId, name, Optional.empty(), Optional.empty());
        }
    }

    public record ExperimentList(List<Experiment> experiments) {
    }

    public record ProjectList(List<Project> projects) {
    }

    public record Project(String id, String name, String orgId, String createdAt, String updatedAt) {
    }

    public record CreateProjectRequest(String name) {
    }

    public static class InMemoryImpl
    implements BraintrustApiClient {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(InMemoryImpl.class);
        private final List<OrganizationAndProjectInfo> organizationAndProjectInfos;
        private final Set<Experiment> experiments = Collections.newSetFromMap(new ConcurrentHashMap());
        private final List<Prompt> prompts = new ArrayList<Prompt>();

        public InMemoryImpl(OrganizationAndProjectInfo ... organizationAndProjectInfos) {
            this.organizationAndProjectInfos = new ArrayList<OrganizationAndProjectInfo>(List.of(organizationAndProjectInfos));
        }

        public InMemoryImpl(List<OrganizationAndProjectInfo> organizationAndProjectInfos, List<Prompt> prompts) {
            this.organizationAndProjectInfos = new ArrayList<OrganizationAndProjectInfo>(organizationAndProjectInfos);
            this.prompts.addAll(prompts);
        }

        @Override
        public LoginResponse login() {
            return new LoginResponse(this.organizationAndProjectInfos.stream().map(o -> o.orgInfo).toList());
        }

        @Override
        public Project getOrCreateProject(String projectName) {
            for (OrganizationAndProjectInfo orgAndProject : this.organizationAndProjectInfos) {
                if (!orgAndProject.project().name().equals(projectName)) continue;
                return orgAndProject.project();
            }
            OrganizationInfo defaultOrgInfo = this.organizationAndProjectInfos.isEmpty() ? new OrganizationInfo("default-org-id", "Default Organization") : this.organizationAndProjectInfos.get(0).orgInfo();
            Project newProject = new Project("project-" + UUID.randomUUID().toString(), projectName, defaultOrgInfo.id(), Instant.now().toString(), Instant.now().toString());
            this.organizationAndProjectInfos.add(new OrganizationAndProjectInfo(defaultOrgInfo, newProject));
            return newProject;
        }

        @Override
        public Optional<Project> getProject(String projectId) {
            return this.organizationAndProjectInfos.stream().map(OrganizationAndProjectInfo::project).filter(project -> project.id().equals(projectId)).findFirst();
        }

        @Override
        public Experiment getOrCreateExperiment(CreateExperimentRequest request) {
            Optional<Experiment> existing = this.experiments.stream().filter(exp -> exp.name().equals(request.name())).findFirst();
            return existing.orElseGet(() -> new Experiment("" + request.name().hashCode(), request.projectId(), request.name(), request.description(), "notused", "notused"));
        }

        @Override
        public Optional<OrganizationAndProjectInfo> getProjectAndOrgInfo() {
            return this.organizationAndProjectInfos.isEmpty() ? Optional.empty() : Optional.of(this.organizationAndProjectInfos.get(0));
        }

        @Override
        public Optional<OrganizationAndProjectInfo> getProjectAndOrgInfo(String projectId) {
            return this.organizationAndProjectInfos.stream().filter(orgAndProject -> orgAndProject.project().id().equals(projectId)).findFirst();
        }

        @Override
        public OrganizationAndProjectInfo getOrCreateProjectAndOrgInfo(BraintrustConfig config) {
            Project project;
            if (config.defaultProjectId().isPresent()) {
                String projectId = config.defaultProjectId().get();
                project = this.getProject(projectId).orElseThrow(() -> new ApiException("Project with ID '" + projectId + "' not found"));
            } else if (config.defaultProjectName().isPresent()) {
                String projectName = config.defaultProjectName().get();
                project = this.getOrCreateProject(projectName);
            } else {
                throw new ApiException("Either project ID or project name must be provided in config");
            }
            return this.organizationAndProjectInfos.stream().filter(info -> info.project().id().equals(project.id())).findFirst().orElseThrow(() -> new ApiException("Unable to find organization for project: " + project.id()));
        }

        @Override
        public Optional<Prompt> getPrompt(@Nonnull String projectName, @Nonnull String slug, @Nullable String version) {
            Objects.requireNonNull(projectName, slug);
            List<Prompt> matchingPrompts = this.prompts.stream().filter(prompt -> {
                if (slug != null && !slug.isEmpty() && !prompt.slug().equals(slug)) {
                    return false;
                }
                if (projectName != null && !projectName.isEmpty()) {
                    Project project = this.getOrCreateProject(projectName);
                    if (!prompt.projectId().equals(project.id())) {
                        return false;
                    }
                }
                return true;
            }).toList();
            if (matchingPrompts.isEmpty()) {
                return Optional.empty();
            }
            if (matchingPrompts.size() > 1) {
                throw new ApiException("Multiple objects found for slug: " + slug + ", projectName: " + projectName);
            }
            return Optional.of(matchingPrompts.get(0));
        }

        @Override
        public DatasetFetchResponse fetchDatasetEvents(String datasetId, DatasetFetchRequest request) {
            return new DatasetFetchResponse(List.of(), null);
        }

        @Override
        public Optional<Dataset> getDataset(String datasetId) {
            return Optional.empty();
        }

        @Override
        public List<Dataset> queryDatasets(String projectName, String datasetName) {
            return List.of();
        }
    }
}

