/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.config;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

class BaseConfig {
    static final String NULL_OVERRIDE = "BRAINTRUST_NULL_SENTINAL_" + System.currentTimeMillis();
    protected final Map<String, String> envOverrides;

    BaseConfig(Map<String, String> envOverrides) {
        this.envOverrides = Map.copyOf(envOverrides);
    }

    @Nonnull
    protected <T> T getConfig(@Nonnull String settingName, @Nonnull T defaultValue) {
        Objects.requireNonNull(defaultValue);
        return Objects.requireNonNull(this.getConfig(settingName, defaultValue, defaultValue.getClass()));
    }

    @Nullable
    protected <T> T getConfig(@Nonnull String settingName, @Nullable T defaultValue, @Nonnull Class<T> settingClass) {
        String rawVal = this.getEnvValue(settingName);
        if (rawVal == null) {
            return defaultValue;
        }
        return this.cast(rawVal, settingClass);
    }

    @Nonnull
    protected String getRequiredConfig(@Nonnull String settingName) {
        return this.getRequiredConfig(settingName, String.class);
    }

    @Nonnull
    protected <T> T getRequiredConfig(String settingName, Class<T> settingClass) {
        T value = this.getConfig(settingName, null, settingClass);
        if (null == value) {
            throw new RuntimeException("%s is required".formatted(settingName));
        }
        return value;
    }

    protected <T> T cast(@Nonnull String value, @Nonnull Class<T> clazz) {
        if (clazz.equals(String.class)) {
            return (T)value;
        }
        if (List.of(Boolean.class, Boolean.TYPE).contains(clazz)) {
            return (T)Boolean.valueOf(value);
        }
        if (List.of(Integer.class, Integer.TYPE).contains(clazz)) {
            return (T)Integer.valueOf(value);
        }
        if (List.of(Long.class, Long.TYPE).contains(clazz)) {
            return (T)Long.valueOf(value);
        }
        if (List.of(Float.class, Float.TYPE).contains(clazz)) {
            return (T)Float.valueOf(value);
        }
        if (List.of(Double.class, Double.TYPE).contains(clazz)) {
            return (T)Double.valueOf(value);
        }
        throw new RuntimeException("Unsupported default class: %s -- please implement or use a different default".formatted(clazz));
    }

    @Nullable
    protected String getEnvValue(@Nonnull String settingName) {
        String settingValue = this.envOverrides.get(settingName);
        if (settingValue == null) {
            settingValue = System.getenv(settingName);
        }
        return NULL_OVERRIDE.equals(settingValue) ? null : settingValue;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseConfig)) {
            return false;
        }
        BaseConfig other = (BaseConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$envOverrides = this.envOverrides;
        Map<String, String> other$envOverrides = other.envOverrides;
        return !(this$envOverrides == null ? other$envOverrides != null : !((Object)this$envOverrides).equals(other$envOverrides));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $envOverrides = this.envOverrides;
        result = result * 59 + ($envOverrides == null ? 43 : ((Object)$envOverrides).hashCode());
        return result;
    }
}

