/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.config;

import dev.braintrust.BraintrustUtils;
import dev.braintrust.api.BraintrustApiClient;
import dev.braintrust.config.BaseConfig;
import java.net.URI;
import java.security.KeyStore;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;

public final class BraintrustConfig
extends BaseConfig {
    private final String apiKey = this.getRequiredConfig("BRAINTRUST_API_KEY");
    private final String apiUrl = this.getConfig("BRAINTRUST_API_URL", "https://api.braintrust.dev");
    private final String appUrl = this.getConfig("BRAINTRUST_APP_URL", "https://www.braintrust.dev");
    private final String tracesPath = this.getConfig("BRAINTRUST_TRACES_PATH", "/otel/v1/traces");
    private final String logsPath = this.getConfig("BRAINTRUST_LOGS_PATH", "/otel/v1/logs");
    private final Optional<String> defaultProjectId = Optional.ofNullable(this.getConfig("BRAINTRUST_DEFAULT_PROJECT_ID", null, String.class));
    private final Optional<String> defaultProjectName = Optional.of(this.getConfig("BRAINTRUST_DEFAULT_PROJECT_NAME", "default-java-project"));
    private final boolean enableTraceConsoleLog = this.getConfig("BRAINTRUST_ENABLE_TRACE_CONSOLE_LOG", false);
    private final boolean debug = this.getConfig("BRAINTRUST_DEBUG", false);
    private final boolean experimentalOtelLogs = this.getConfig("BRAINTRUST_X_OTEL_LOGS", false);
    private final Duration requestTimeout = Duration.ofSeconds(this.getConfig("BRAINTRUST_REQUEST_TIMEOUT", 30).intValue());
    private final SSLContext sslContext;
    private final X509TrustManager x509TrustManager;
    private final boolean exportSpansInMemoryForUnitTest = this.getConfig("BRAINTRUST_JAVA_EXPORT_SPANS_IN_MEMORY_FOR_UNIT_TEST", false);
    private final String devserverCorsOriginWhitelistCsv = this.getConfig("BRAINTRUST_DEVSERVER_CORS_ORIGIN_WHITELIST_CSV", "https://www.braintrust.dev,https://www.braintrustdata.com,http://localhost:3000");

    public static BraintrustConfig fromEnvironment() {
        return BraintrustConfig.of(new String[0]);
    }

    public static BraintrustConfig of(String ... envOverrides) {
        if (envOverrides.length % 2 != 0) {
            throw new RuntimeException("config overrides require key-value pairs. Found dangling key: %s".formatted(envOverrides[envOverrides.length - 1]));
        }
        HashMap<String, String> overridesMap = new HashMap<String, String>();
        for (int i = 0; i < envOverrides.length - 1; i += 2) {
            overridesMap.put(envOverrides[i], envOverrides[i + 1]);
        }
        return new BraintrustConfig(overridesMap, null, null);
    }

    private BraintrustConfig(Map<String, String> envOverrides, SSLContext sslContext, X509TrustManager x509TrustManager) {
        super(envOverrides);
        if (this.defaultProjectId.isEmpty() && this.defaultProjectName.isEmpty()) {
            throw new RuntimeException("A project name or ID is required.");
        }
        SSLContext sSLContext = this.sslContext = sslContext != null ? sslContext : SSLContext.getDefault();
        if (x509TrustManager != null) {
            this.x509TrustManager = x509TrustManager;
        } else {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            this.x509TrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
        }
    }

    public Optional<String> getBraintrustParentValue() {
        if (this.defaultProjectId.isPresent()) {
            return Optional.of("project_id:" + this.defaultProjectId.orElseThrow());
        }
        if (this.defaultProjectName.isPresent()) {
            return Optional.of("project_name:" + this.defaultProjectName.orElseThrow());
        }
        return Optional.empty();
    }

    @Deprecated
    public URI fetchProjectURI() {
        BraintrustApiClient client = BraintrustApiClient.of(this);
        BraintrustApiClient.OrganizationAndProjectInfo orgAndProject = client.getProjectAndOrgInfo().orElseThrow();
        return BraintrustUtils.createProjectURI(this.appUrl(), orgAndProject);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public String apiKey() {
        return this.apiKey;
    }

    @Generated
    public String apiUrl() {
        return this.apiUrl;
    }

    @Generated
    public String appUrl() {
        return this.appUrl;
    }

    @Generated
    public String tracesPath() {
        return this.tracesPath;
    }

    @Generated
    public String logsPath() {
        return this.logsPath;
    }

    @Generated
    public Optional<String> defaultProjectId() {
        return this.defaultProjectId;
    }

    @Generated
    public Optional<String> defaultProjectName() {
        return this.defaultProjectName;
    }

    @Generated
    public boolean enableTraceConsoleLog() {
        return this.enableTraceConsoleLog;
    }

    @Generated
    public boolean debug() {
        return this.debug;
    }

    @Generated
    public boolean experimentalOtelLogs() {
        return this.experimentalOtelLogs;
    }

    @Generated
    public Duration requestTimeout() {
        return this.requestTimeout;
    }

    @Generated
    public SSLContext sslContext() {
        return this.sslContext;
    }

    @Generated
    public X509TrustManager x509TrustManager() {
        return this.x509TrustManager;
    }

    @Generated
    public boolean exportSpansInMemoryForUnitTest() {
        return this.exportSpansInMemoryForUnitTest;
    }

    @Generated
    public String devserverCorsOriginWhitelistCsv() {
        return this.devserverCorsOriginWhitelistCsv;
    }

    public static class Builder {
        private final Map<String, String> envOverrides = new HashMap<String, String>();
        private SSLContext sslContext;
        private X509TrustManager x509TrustManager;

        public Builder apiKey(String value) {
            this.envOverrides.put("BRAINTRUST_API_KEY", value);
            return this;
        }

        public Builder apiUrl(String value) {
            this.envOverrides.put("BRAINTRUST_API_URL", value);
            return this;
        }

        public Builder appUrl(String value) {
            this.envOverrides.put("BRAINTRUST_APP_URL", value);
            return this;
        }

        public Builder tracesPath(String value) {
            this.envOverrides.put("BRAINTRUST_TRACES_PATH", value);
            return this;
        }

        public Builder logsPath(String value) {
            this.envOverrides.put("BRAINTRUST_LOGS_PATH", value);
            return this;
        }

        public Builder defaultProjectId(String value) {
            if (value != null) {
                this.envOverrides.put("BRAINTRUST_DEFAULT_PROJECT_ID", value);
            } else {
                this.envOverrides.put("BRAINTRUST_DEFAULT_PROJECT_ID", BaseConfig.NULL_OVERRIDE);
            }
            return this;
        }

        public Builder defaultProjectName(String value) {
            if (value != null) {
                this.envOverrides.put("BRAINTRUST_DEFAULT_PROJECT_NAME", value);
            } else {
                this.envOverrides.put("BRAINTRUST_DEFAULT_PROJECT_NAME", BaseConfig.NULL_OVERRIDE);
            }
            return this;
        }

        public Builder enableTraceConsoleLog(boolean value) {
            this.envOverrides.put("BRAINTRUST_ENABLE_TRACE_CONSOLE_LOG", String.valueOf(value));
            return this;
        }

        public Builder debug(boolean value) {
            this.envOverrides.put("BRAINTRUST_DEBUG", String.valueOf(value));
            return this;
        }

        public Builder requestTimeout(Duration value) {
            this.envOverrides.put("BRAINTRUST_REQUEST_TIMEOUT", String.valueOf(value.getSeconds()));
            return this;
        }

        Builder experimentalOtelLogs(boolean value) {
            this.envOverrides.put("BRAINTRUST_X_OTEL_LOGS", String.valueOf(value));
            return this;
        }

        public Builder exportSpansInMemoryForUnitTest(boolean value) {
            this.envOverrides.put("BRAINTRUST_JAVA_EXPORT_SPANS_IN_MEMORY_FOR_UNIT_TEST", String.valueOf(value));
            return this;
        }

        public Builder sslContext(SSLContext value) {
            this.sslContext = value;
            return this;
        }

        public Builder x509TrustManager(X509TrustManager value) {
            this.x509TrustManager = value;
            return this;
        }

        public Builder devserverCorsOriginWhitelistCsv(String csv) {
            this.envOverrides.put("BRAINTRUST_DEVSERVER_CORS_ORIGIN_WHITELIST_CSV", csv);
            return this;
        }

        public BraintrustConfig build() {
            return new BraintrustConfig(this.envOverrides, this.sslContext, this.x509TrustManager);
        }
    }
}

