/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.devserver;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import dev.braintrust.Braintrust;
import dev.braintrust.BraintrustUtils;
import dev.braintrust.Origin;
import dev.braintrust.api.BraintrustApiClient;
import dev.braintrust.config.BraintrustConfig;
import dev.braintrust.devserver.EvalRequest;
import dev.braintrust.devserver.EvalResponse;
import dev.braintrust.devserver.LRUCache;
import dev.braintrust.devserver.RemoteEval;
import dev.braintrust.devserver.RequestContext;
import dev.braintrust.eval.Dataset;
import dev.braintrust.eval.DatasetCase;
import dev.braintrust.eval.Score;
import dev.braintrust.eval.Scorer;
import dev.braintrust.eval.Task;
import dev.braintrust.eval.TaskResult;
import dev.braintrust.trace.BraintrustContext;
import dev.braintrust.trace.BraintrustTracing;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Devserver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Devserver.class);
    private static final Pattern PREVIEW_DOMAIN_PATTERN = Pattern.compile("^https://[^/]+\\.preview\\.braintrust\\.dev$");
    private static final String ALLOWED_HEADERS = String.join((CharSequence)", ", "Content-Type", "X-Amz-Date", "Authorization", "X-Api-Key", "X-Amz-Security-Token", "X-Bt-Auth-Token", "X-Bt-Parent", "X-Bt-Org-Name", "X-Bt-Project-Id", "X-Bt-Stream-Fmt", "X-Bt-Use-Cache", "X-Stainless-Os", "X-Stainless-Lang", "X-Stainless-Package-Version", "X-Stainless-Runtime", "X-Stainless-Runtime-Version", "X-Stainless-Arch");
    private static final String EXPOSED_HEADERS = "x-bt-cursor, x-bt-found-existing-experiment, x-bt-span-id, x-bt-span-export";
    private static final AttributeKey<String> PARENT = AttributeKey.stringKey((String)"braintrust.parent");
    private final List<String> corsOriginWhitelist;
    private final BraintrustConfig config;
    private final String host;
    private final int port;
    @Nullable
    private final String orgName;
    private final Map<String, RemoteEval<?, ?>> evals;
    @Nullable
    private HttpServer server;
    @Nullable
    private final Consumer<SdkTracerProviderBuilder> traceBuilderHook;
    @Nullable
    private final Consumer<BraintrustConfig.Builder> configBuilderHook;
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper().enable(new JsonParser.Feature[]{JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION});
    private final LRUCache<String, Braintrust> authCache = new LRUCache(32);

    private Devserver(Builder builder) {
        this.config = Objects.requireNonNull(builder.config);
        this.host = builder.host;
        this.port = builder.port;
        this.orgName = builder.orgName;
        this.traceBuilderHook = builder.traceBuilderHook;
        this.configBuilderHook = builder.configBuilderHook;
        HashMap evalMap = new HashMap();
        for (RemoteEval<?, ?> eval : builder.evals) {
            if (evalMap.containsKey(eval.getName())) {
                throw new IllegalArgumentException("Duplicate evaluator name: " + eval.getName());
            }
            evalMap.put(eval.getName(), eval);
        }
        this.evals = Collections.unmodifiableMap(evalMap);
        if (this.orgName != null) {
            throw new NotSupportedYetException("org name filtering");
        }
        this.corsOriginWhitelist = List.copyOf(BraintrustUtils.append(BraintrustUtils.parseCsv(this.config.devserverCorsOriginWhitelistCsv()), this.config.appUrl()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public synchronized void start() throws IOException {
        if (this.server != null) {
            throw new IllegalStateException("Server is already running");
        }
        this.server = HttpServer.create(new InetSocketAddress(this.host, this.port), 0);
        this.server.setExecutor(Executors.newCachedThreadPool());
        this.server.createContext("/", this.withCors(this::handleHealthCheck));
        this.server.createContext("/list", this.withCors(this::handleList));
        this.server.createContext("/eval", this.withCors(this::handleEval));
        this.server.start();
        log.info("Braintrust dev server started on http://{}:{}", (Object)this.host, (Object)this.port);
        log.info("Registered {} evaluator(s): {}", (Object)this.evals.size(), this.evals.keySet());
    }

    public synchronized void stop() {
        if (this.server != null) {
            this.server.stop(0);
            this.server = null;
            log.info("Braintrust dev server stopped");
        }
    }

    private void handleHealthCheck(HttpExchange exchange) throws IOException {
        if (!"GET".equals(exchange.getRequestMethod())) {
            this.sendResponse(exchange, 405, "text/plain", "Method Not Allowed");
            return;
        }
        this.sendResponse(exchange, 200, "text/plain", "Hello, world!");
    }

    private void handleList(HttpExchange exchange) throws IOException {
        if (!"GET".equals(exchange.getRequestMethod())) {
            this.sendResponse(exchange, 405, "text/plain", "Method Not Allowed");
            return;
        }
        RequestContext context = this.createRequestContext(exchange);
        String apiKey = this.extractApiKey(exchange, context);
        if (apiKey == null) {
            this.sendErrorResponse(exchange, 401, "Missing authentication token");
            return;
        }
        try {
            LinkedHashMap response = new LinkedHashMap();
            for (Map.Entry<String, RemoteEval<?, ?>> entry : this.evals.entrySet()) {
                String evalName = entry.getKey();
                RemoteEval<?, ?> eval = entry.getValue();
                LinkedHashMap<String, Cloneable> metadata = new LinkedHashMap<String, Cloneable>();
                LinkedHashMap parametersMap = new LinkedHashMap();
                for (Map.Entry<String, RemoteEval.Parameter> paramEntry : eval.getParameters().entrySet()) {
                    String paramName = paramEntry.getKey();
                    RemoteEval.Parameter param = paramEntry.getValue();
                    LinkedHashMap<String, Object> paramMetadata = new LinkedHashMap<String, Object>();
                    paramMetadata.put("type", param.getType().getValue());
                    if (param.getDescription() != null) {
                        paramMetadata.put("description", param.getDescription());
                    }
                    if (param.getDefaultValue() != null) {
                        paramMetadata.put("default", param.getDefaultValue());
                    }
                    if (param.getType() == RemoteEval.ParameterType.DATA && param.getSchema() != null) {
                        paramMetadata.put("schema", param.getSchema());
                    }
                    parametersMap.put(paramName, paramMetadata);
                }
                metadata.put("parameters", parametersMap);
                ArrayList scores = new ArrayList();
                for (Scorer<?, ?> scorer : eval.getScorers()) {
                    LinkedHashMap<String, String> scoreInfo = new LinkedHashMap<String, String>();
                    scoreInfo.put("name", scorer.getName());
                    scores.add(scoreInfo);
                }
                metadata.put("scores", scores);
                response.put(evalName, metadata);
            }
            String jsonResponse = JSON_MAPPER.writeValueAsString(response);
            this.sendResponse(exchange, 200, "application/json", jsonResponse);
        }
        catch (Exception e) {
            log.error("Error generating /list response", (Throwable)e);
            this.sendResponse(exchange, 500, "text/plain", "Internal Server Error");
        }
    }

    private void handleEval(HttpExchange exchange) throws IOException {
        if (!"POST".equals(exchange.getRequestMethod())) {
            this.sendResponse(exchange, 405, "text/plain", "Method Not Allowed");
            return;
        }
        RequestContext context = this.createRequestContext(exchange);
        if ((context = this.getBraintrust(exchange, context)) == null) {
            this.sendErrorResponse(exchange, 401, "Missing required authentication headers");
            return;
        }
        try {
            boolean isStreaming;
            boolean hasById;
            boolean hasByName;
            InputStream requestBody = exchange.getRequestBody();
            String requestBodyString = new String(requestBody.readAllBytes(), StandardCharsets.UTF_8);
            EvalRequest request = (EvalRequest)JSON_MAPPER.readValue(requestBodyString, EvalRequest.class);
            RemoteEval<?, ?> eval = this.evals.get(request.getName());
            if (eval == null) {
                this.sendResponse(exchange, 404, "text/plain", "Evaluator not found: " + request.getName());
                return;
            }
            if (request.getData() == null) {
                this.sendResponse(exchange, 400, "text/plain", "Missing 'data' field in request body");
                return;
            }
            EvalRequest.DataSpec dataSpec = request.getData();
            boolean hasInlineData = dataSpec.getData() != null && !dataSpec.getData().isEmpty();
            int specCount = (hasInlineData ? 1 : 0) + ((hasByName = dataSpec.getProjectName() != null && dataSpec.getDatasetName() != null) ? 1 : 0) + ((hasById = dataSpec.getDatasetId() != null) ? 1 : 0);
            if (specCount == 0) {
                this.sendResponse(exchange, 400, "text/plain", "Dataset must be specified using one of: inline data (data.data), by name (data.project_name + data.dataset_name), or by ID (data.dataset_id)");
                return;
            }
            if (specCount > 1) {
                this.sendResponse(exchange, 400, "text/plain", "Only one dataset specification method should be provided");
                return;
            }
            String datasetDescription = hasInlineData ? dataSpec.getData().size() + " inline cases" : (hasByName ? "dataset '" + dataSpec.getProjectName() + "/" + dataSpec.getDatasetName() + "'" : "dataset ID '" + dataSpec.getDatasetId() + "'");
            log.debug("Executing evaluator '{}' with {}", (Object)request.getName(), (Object)datasetDescription);
            boolean bl = isStreaming = request.getStream() != null && request.getStream() != false;
            if (!isStreaming) {
                throw new NotSupportedYetException("non-streaming responses");
            }
            log.debug("Starting streaming evaluation for '{}'", (Object)request.getName());
            this.handleStreamingEval(exchange, eval, request, context);
        }
        catch (NotSupportedYetException e) {
            this.sendResponse(exchange, 400, "text/plain", "TODO: feature not supported: " + e.description);
        }
        catch (Exception e) {
            log.error("Error executing eval", (Throwable)e);
            this.sendResponse(exchange, 500, "text/plain", "Internal Server Error: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStreamingEval(HttpExchange exchange, RemoteEval eval, EvalRequest request, RequestContext context) throws Exception {
        exchange.getResponseHeaders().set("Content-Type", "text/event-stream");
        exchange.getResponseHeaders().set("Cache-Control", "no-cache");
        exchange.getResponseHeaders().set("Connection", "keep-alive");
        exchange.sendResponseHeaders(200, 0L);
        try (OutputStream os = exchange.getResponseBody();){
            try {
                Braintrust braintrust = context.getBraintrust();
                BraintrustApiClient apiClient = braintrust.apiClient();
                BraintrustApiClient.OrganizationAndProjectInfo orgAndProject = apiClient.getOrCreateProjectAndOrgInfo(braintrust.config());
                String projectName = orgAndProject.project().name();
                String projectId = orgAndProject.project().id();
                String experimentName = request.getExperimentName() != null ? request.getExperimentName() : eval.getName();
                String experimentUrl = BraintrustUtils.createProjectURI(braintrust.config().appUrl(), orgAndProject).toASCIIString() + "/experiments/" + experimentName;
                String projectUrl = BraintrustUtils.createProjectURI(braintrust.config().appUrl(), orgAndProject).toASCIIString();
                Tracer tracer = BraintrustTracing.getTracer();
                ConcurrentHashMap scoresByName = new ConcurrentHashMap();
                ParentInfo parentInfo = Devserver.extractParentInfo(request);
                BraintrustUtils.Parent braintrustParent = parentInfo.braintrustParent();
                String braintrustGeneration = parentInfo.generation();
                Devserver.extractDataset(request, apiClient).forEach(datasetCase -> {
                    Span evalSpan = tracer.spanBuilder("eval").setNoParent().setSpanKind(SpanKind.CLIENT).setAttribute(PARENT, (Object)braintrustParent.toParentValue()).startSpan();
                    Context evalContext = Context.current().with((ImplicitContextKeyed)evalSpan);
                    evalContext = BraintrustContext.setParentInBaggage(evalContext, braintrustParent.type(), braintrustParent.id());
                    try (Scope rootScope = evalContext.makeCurrent();){
                        TaskResult taskResult;
                        Span taskSpan = tracer.spanBuilder("task").startSpan();
                        try (Scope unused = Context.current().with((ImplicitContextKeyed)taskSpan).makeCurrent();){
                            Task task = eval.getTask();
                            taskResult = task.apply(datasetCase);
                            this.sendProgressEvent(os, evalSpan.getSpanContext().getSpanId(), datasetCase.origin(), eval.getName(), taskResult.result());
                            this.setTaskSpanAttributes(taskSpan, braintrustParent, braintrustGeneration, (DatasetCase<?, ?>)datasetCase, taskResult);
                        }
                        finally {
                            taskSpan.end();
                        }
                        this.setEvalSpanAttributes(evalSpan, braintrustParent, braintrustGeneration, (DatasetCase<?, ?>)datasetCase, taskResult);
                        for (Scorer scorer : eval.getScorers()) {
                            Span scoreSpan = tracer.spanBuilder("score").startSpan();
                            try {
                                Scope unused = Context.current().with((ImplicitContextKeyed)scoreSpan).makeCurrent();
                                try {
                                    List<Score> scores = scorer.score(taskResult);
                                    LinkedHashMap<String, Double> scorerScores = new LinkedHashMap<String, Double>();
                                    for (Score score : scores) {
                                        scoresByName.computeIfAbsent(score.name(), k -> new ArrayList()).add(score.value());
                                        scorerScores.put(score.name(), score.value());
                                    }
                                    this.setScoreSpanAttributes(scoreSpan, braintrustParent, braintrustGeneration, scorer.getName(), scorerScores);
                                }
                                finally {
                                    if (unused == null) continue;
                                    unused.close();
                                }
                            }
                            finally {
                                scoreSpan.end();
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to send progress event", e);
                    }
                    finally {
                        evalSpan.end();
                    }
                });
                LinkedHashMap<String, EvalResponse.ScoreSummary> scoreSummaries = new LinkedHashMap<String, EvalResponse.ScoreSummary>();
                for (Map.Entry entry : scoresByName.entrySet()) {
                    String scoreName = (String)entry.getKey();
                    List values = (List)entry.getValue();
                    double avgScore = values.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
                    scoreSummaries.put(scoreName, EvalResponse.ScoreSummary.builder().name(scoreName).score(avgScore).improvements(0).regressions(0).build());
                }
                this.sendSummaryEvent(os, projectName, projectId, experimentName, projectUrl, experimentUrl, scoreSummaries);
                this.sendDoneEvent(os);
            }
            catch (Exception e) {
                log.error("Error during streaming evaluation", (Throwable)e);
                try {
                    this.sendSSEEvent(os, "error", e.getMessage() != null ? e.getMessage() : "Unknown error");
                }
                catch (IOException ioException) {
                    log.error("Failed to send error event", (Throwable)ioException);
                }
            }
            finally {
                try {
                    os.flush();
                    os.close();
                }
                catch (IOException e) {
                    log.error("Failed to close output stream", (Throwable)e);
                }
            }
        }
    }

    private void setEvalSpanAttributes(Span evalSpan, BraintrustUtils.Parent braintrustParent, String braintrustGeneration, DatasetCase<?, ?> datasetCase, TaskResult<?, ?> taskResult) {
        LinkedHashMap<String, String> spanAttrs = new LinkedHashMap<String, String>();
        spanAttrs.put("type", "eval");
        spanAttrs.put("name", "eval");
        if (braintrustGeneration != null) {
            spanAttrs.put("generation", braintrustGeneration);
        }
        evalSpan.setAttribute(PARENT, (Object)braintrustParent.toParentValue()).setAttribute("braintrust.span_attributes", this.json(spanAttrs)).setAttribute("braintrust.input_json", this.json(Map.of("input", datasetCase.input()))).setAttribute("braintrust.expected_json", this.json(datasetCase.expected()));
        if (datasetCase.origin().isPresent()) {
            evalSpan.setAttribute("braintrust.origin", this.json(datasetCase.origin().get()));
        }
        if (!datasetCase.tags().isEmpty()) {
            evalSpan.setAttribute(AttributeKey.stringArrayKey((String)"braintrust.tags"), datasetCase.tags());
        }
        if (!datasetCase.metadata().isEmpty()) {
            evalSpan.setAttribute("braintrust.metadata", this.json(datasetCase.metadata()));
        }
        evalSpan.setAttribute("braintrust.output_json", this.json(Map.of("output", taskResult.result())));
    }

    private void setTaskSpanAttributes(Span taskSpan, BraintrustUtils.Parent braintrustParent, String braintrustGeneration, DatasetCase<?, ?> datasetCase, TaskResult<?, ?> taskResult) {
        LinkedHashMap<String, String> taskSpanAttrs = new LinkedHashMap<String, String>();
        taskSpanAttrs.put("type", "task");
        taskSpanAttrs.put("name", "task");
        if (braintrustGeneration != null) {
            taskSpanAttrs.put("generation", braintrustGeneration);
        }
        taskSpan.setAttribute(PARENT, (Object)braintrustParent.toParentValue()).setAttribute("braintrust.span_attributes", this.json(taskSpanAttrs)).setAttribute("braintrust.input_json", this.json(Map.of("input", datasetCase.input()))).setAttribute("braintrust.output_json", this.json(Map.of("output", taskResult.result())));
    }

    private void setScoreSpanAttributes(Span scoreSpan, BraintrustUtils.Parent braintrustParent, String braintrustGeneration, String scorerName, Map<String, Double> scorerScores) {
        LinkedHashMap<String, String> scoreSpanAttrs = new LinkedHashMap<String, String>();
        scoreSpanAttrs.put("type", "score");
        scoreSpanAttrs.put("name", scorerName);
        if (braintrustGeneration != null) {
            scoreSpanAttrs.put("generation", braintrustGeneration);
        }
        scoreSpan.setAttribute(PARENT, (Object)braintrustParent.toParentValue()).setAttribute("braintrust.span_attributes", this.json(scoreSpanAttrs)).setAttribute("braintrust.output_json", this.json(scorerScores));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSSEEvent(OutputStream os, String eventType, String data) throws IOException {
        String event = "event: " + eventType + "\ndata: " + data + "\n\n";
        Devserver devserver = this;
        synchronized (devserver) {
            os.write(event.getBytes(StandardCharsets.UTF_8));
        }
    }

    private void sendProgressEvent(OutputStream os, String spanId, Optional<Origin> origin, String evalName, Object taskResult) throws IOException {
        LinkedHashMap<String, String> progressData = new LinkedHashMap<String, String>();
        progressData.put("id", spanId);
        progressData.put("object_type", "task");
        origin.ifPresent(value -> progressData.put("origin", (String)value));
        progressData.put("name", evalName);
        progressData.put("format", "code");
        progressData.put("output_type", "completion");
        progressData.put("event", "json_delta");
        progressData.put("data", JSON_MAPPER.writeValueAsString(taskResult));
        String progressJson = JSON_MAPPER.writeValueAsString(progressData);
        this.sendSSEEvent(os, "progress", progressJson);
    }

    private void sendSummaryEvent(OutputStream os, String projectName, String projectId, String experimentName, String projectUrl, String experimentUrl, Map<String, EvalResponse.ScoreSummary> scoreSummaries) throws IOException {
        LinkedHashMap<String, Object> summary = new LinkedHashMap<String, Object>();
        summary.put("projectName", projectName);
        summary.put("projectId", projectId);
        summary.put("experimentId", null);
        summary.put("experimentName", experimentName);
        summary.put("projectUrl", projectUrl);
        summary.put("experimentUrl", null);
        summary.put("comparisonExperimentName", null);
        LinkedHashMap scoresWithMeta = new LinkedHashMap();
        for (Map.Entry<String, EvalResponse.ScoreSummary> entry : scoreSummaries.entrySet()) {
            LinkedHashMap<String, Object> scoreData = new LinkedHashMap<String, Object>();
            scoreData.put("name", entry.getValue().getName());
            scoreData.put("_longest_score_name", entry.getKey().length());
            scoreData.put("score", entry.getValue().getScore());
            scoreData.put("improvements", entry.getValue().getImprovements());
            scoreData.put("regressions", entry.getValue().getRegressions());
            scoreData.put("diff", null);
            scoresWithMeta.put(entry.getKey(), scoreData);
        }
        summary.put("scores", scoresWithMeta);
        summary.put("metrics", Map.of());
        this.sendSSEEvent(os, "summary", JSON_MAPPER.writeValueAsString(summary));
    }

    private void sendDoneEvent(OutputStream os) throws IOException {
        this.sendSSEEvent(os, "done", "");
    }

    private String json(Object o) {
        try {
            return JSON_MAPPER.writeValueAsString(o);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize to JSON", e);
        }
    }

    private void sendResponse(HttpExchange exchange, int statusCode, String contentType, String body) throws IOException {
        byte[] responseBytes = body.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", contentType);
        exchange.sendResponseHeaders(statusCode, responseBytes.length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(responseBytes);
        }
    }

    private boolean isOriginAllowed(@Nullable String origin) {
        if (origin == null || origin.isEmpty()) {
            return true;
        }
        for (String allowedOrigin : this.corsOriginWhitelist) {
            if (allowedOrigin == null || !allowedOrigin.equals(origin)) continue;
            return true;
        }
        return PREVIEW_DOMAIN_PATTERN.matcher(origin).matches();
    }

    private void applyCorsHeaders(HttpExchange exchange) {
        String origin = exchange.getRequestHeaders().getFirst("Origin");
        if (this.isOriginAllowed(origin)) {
            Headers headers = exchange.getResponseHeaders();
            if (origin != null && !origin.isEmpty()) {
                headers.set("Access-Control-Allow-Origin", origin);
            }
            headers.set("Access-Control-Allow-Credentials", "true");
            headers.set("Access-Control-Expose-Headers", EXPOSED_HEADERS);
        }
    }

    private void handlePreflightRequest(HttpExchange exchange) throws IOException {
        String origin = exchange.getRequestHeaders().getFirst("Origin");
        if (!this.isOriginAllowed(origin)) {
            exchange.sendResponseHeaders(403, -1L);
            return;
        }
        Headers headers = exchange.getResponseHeaders();
        if (origin != null && !origin.isEmpty()) {
            headers.set("Access-Control-Allow-Origin", origin);
        }
        headers.set("Access-Control-Allow-Methods", "GET, PATCH, POST, PUT, DELETE, OPTIONS");
        headers.set("Access-Control-Allow-Headers", ALLOWED_HEADERS);
        headers.set("Access-Control-Allow-Credentials", "true");
        headers.set("Access-Control-Max-Age", "86400");
        String requestPrivateNetwork = exchange.getRequestHeaders().getFirst("Access-Control-Request-Private-Network");
        if ("true".equals(requestPrivateNetwork)) {
            headers.set("Access-Control-Allow-Private-Network", "true");
        }
        exchange.sendResponseHeaders(204, -1L);
    }

    private HttpHandler withCors(HttpHandler handler) {
        return exchange -> {
            if ("OPTIONS".equals(exchange.getRequestMethod())) {
                this.handlePreflightRequest(exchange);
                return;
            }
            this.applyCorsHeaders(exchange);
            handler.handle(exchange);
        };
    }

    @Nullable
    private String extractApiKey(HttpExchange exchange, RequestContext context) {
        Headers headers = exchange.getRequestHeaders();
        String token = headers.getFirst("x-bt-auth-token");
        if (token != null && !token.isEmpty()) {
            return token;
        }
        String authHeader = headers.getFirst("Authorization");
        if (authHeader != null && !authHeader.isEmpty()) {
            if (authHeader.startsWith("Bearer ")) {
                return authHeader.substring(7).trim();
            }
            return authHeader.trim();
        }
        return null;
    }

    private RequestContext createRequestContext(HttpExchange exchange) {
        String origin = exchange.getRequestHeaders().getFirst("Origin");
        if (origin == null) {
            origin = "";
        }
        return RequestContext.builder().appOrigin(origin).build();
    }

    @Nullable
    private RequestContext getBraintrust(HttpExchange exchange, RequestContext context) {
        String apiKey = this.extractApiKey(exchange, context);
        if (apiKey == null || apiKey.isEmpty()) {
            return null;
        }
        String orgName = exchange.getRequestHeaders().getFirst("x-bt-org-name");
        if (orgName == null || orgName.isEmpty()) {
            return null;
        }
        String projectId = exchange.getRequestHeaders().getFirst("x-bt-project-id");
        if (projectId == null || projectId.isEmpty()) {
            return null;
        }
        String cacheKey = orgName + ":" + projectId + ":" + apiKey;
        Braintrust braintrust = this.authCache.getOrCompute(cacheKey, () -> {
            log.debug("Cached login state for org='{}', projectId='{}' (cache size={})", new Object[]{orgName, projectId, this.authCache.size()});
            BraintrustConfig.Builder configBuilder = BraintrustConfig.builder().apiKey(apiKey).defaultProjectId(projectId).apiUrl(this.config.apiUrl()).appUrl(this.config.appUrl());
            if (this.configBuilderHook != null) {
                this.configBuilderHook.accept(configBuilder);
            }
            Braintrust bt = Braintrust.of(configBuilder.build());
            bt.apiClient().login();
            return bt;
        });
        log.debug("Retrieved login state for org='{}', projectId='{}' (cache size={})", new Object[]{orgName, projectId, this.authCache.size()});
        return RequestContext.builder().appOrigin(context.getAppOrigin()).token(apiKey).braintrust(braintrust).build();
    }

    private void sendErrorResponse(HttpExchange exchange, int statusCode, String message) throws IOException {
        Map<String, String> error = Map.of("error", message);
        String json = JSON_MAPPER.writeValueAsString(error);
        this.sendResponse(exchange, statusCode, "application/json", json);
    }

    private static ParentInfo extractParentInfo(EvalRequest request) {
        String parentSpec = null;
        String generation = null;
        if (request.getParent() != null && request.getParent() instanceof Map) {
            Map propEvent;
            Object spanAttrsObj;
            Map parentMap = (Map)request.getParent();
            String objectType = (String)parentMap.get("object_type");
            String objectId = (String)parentMap.get("object_id");
            Object propEventObj = parentMap.get("propagated_event");
            if (propEventObj instanceof Map && (spanAttrsObj = (propEvent = (Map)propEventObj).get("span_attributes")) instanceof Map) {
                Map spanAttrs = (Map)spanAttrsObj;
                generation = (String)spanAttrs.get("generation");
            }
            if (objectType != null && objectId != null) {
                parentSpec = "playground_id:" + objectId;
            }
        }
        if (parentSpec == null) {
            throw new IllegalArgumentException("braintrust parent (playground_id) not found");
        }
        return new ParentInfo(BraintrustUtils.parseParent(parentSpec), generation);
    }

    private static Dataset<?, ?> extractDataset(EvalRequest request, BraintrustApiClient apiClient) {
        EvalRequest.DataSpec dataSpec = request.getData();
        if (dataSpec.getData() != null && !dataSpec.getData().isEmpty()) {
            ArrayList<DatasetCase<Object, Object>> cases = new ArrayList<DatasetCase<Object, Object>>();
            for (EvalRequest.EvalCaseData caseData : dataSpec.getData()) {
                DatasetCase<Object, Object> datasetCase = DatasetCase.of(caseData.getInput(), caseData.getExpected(), caseData.getTags() != null ? caseData.getTags() : List.of(), caseData.getMetadata() != null ? caseData.getMetadata() : Map.of());
                cases.add(datasetCase);
            }
            return Dataset.of(cases.toArray(new DatasetCase[0]));
        }
        if (dataSpec.getProjectName() != null && dataSpec.getDatasetName() != null) {
            log.debug("Fetching dataset from Braintrust: project={}, dataset={}", (Object)dataSpec.getProjectName(), (Object)dataSpec.getDatasetName());
            return Dataset.fetchFromBraintrust(apiClient, dataSpec.getProjectName(), dataSpec.getDatasetName(), null);
        }
        if (dataSpec.getDatasetId() != null) {
            log.debug("Fetching dataset from Braintrust by ID: {}", (Object)dataSpec.getDatasetId());
            Optional<BraintrustApiClient.Dataset> datasetMetadata = apiClient.getDataset(dataSpec.getDatasetId());
            if (datasetMetadata.isEmpty()) {
                throw new IllegalArgumentException("Dataset not found: " + dataSpec.getDatasetId());
            }
            Optional<BraintrustApiClient.Project> project = apiClient.getProject(datasetMetadata.get().projectId());
            if (project.isEmpty()) {
                throw new IllegalArgumentException("Project not found: " + datasetMetadata.get().projectId());
            }
            String fetchedProjectName = project.get().name();
            String fetchedDatasetName = datasetMetadata.get().name();
            log.debug("Resolved dataset ID to project={}, dataset={}", (Object)fetchedProjectName, (Object)fetchedDatasetName);
            return Dataset.fetchFromBraintrust(apiClient, fetchedProjectName, fetchedDatasetName, null);
        }
        throw new IllegalStateException("No dataset specification provided");
    }

    @Generated
    public String host() {
        return this.host;
    }

    @Generated
    public int port() {
        return this.port;
    }

    public static class Builder {
        @Nullable
        private BraintrustConfig config = null;
        private String host = "localhost";
        private int port = 8300;
        @Nullable
        private String orgName = null;
        private List<RemoteEval<?, ?>> evals = new ArrayList();
        @Nullable
        private Consumer<SdkTracerProviderBuilder> traceBuilderHook = null;
        @Nullable
        private Consumer<BraintrustConfig.Builder> configBuilderHook = null;

        public Devserver build() {
            if (this.evals.isEmpty()) {
                throw new IllegalStateException("At least one evaluator must be registered");
            }
            if (this.config == null) {
                throw new IllegalStateException("config is required");
            }
            return new Devserver(this);
        }

        public Builder config(BraintrustConfig config) {
            this.config = config;
            return this;
        }

        public Builder registerEval(RemoteEval<?, ?> eval) {
            this.evals.add(eval);
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder braintrustConfigBuilderHook(Consumer<BraintrustConfig.Builder> configBuilderHook) {
            this.configBuilderHook = configBuilderHook;
            return this;
        }
    }

    private static class NotSupportedYetException
    extends RuntimeException {
        private final String description;

        public NotSupportedYetException(String description) {
            super("feature not supported yet: " + description);
            this.description = description;
        }
    }

    private record ParentInfo(@Nonnull BraintrustUtils.Parent braintrustParent, @Nullable String generation) {
    }
}

