/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.devserver;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class LRUCache<K, V> {
    private final int maxSize;
    private final Map<K, V> cache;

    public LRUCache(int maxSize) {
        this.maxSize = maxSize;
        this.cache = new LinkedHashMap<K, V>(maxSize, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > LRUCache.this.maxSize;
            }
        };
    }

    public synchronized void put(K key, V value) {
        this.cache.put(key, value);
    }

    @Nullable
    public synchronized V get(K key) {
        return this.cache.get(key);
    }

    public synchronized V getOrCompute(K key, Supplier<V> supplier) {
        V value = this.cache.get(key);
        if (value == null) {
            value = supplier.get();
            this.cache.put(key, value);
        }
        return value;
    }

    public synchronized boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    public synchronized void clear() {
        this.cache.clear();
    }

    public synchronized int size() {
        return this.cache.size();
    }
}

