/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.devserver;

import dev.braintrust.eval.Scorer;
import dev.braintrust.eval.Task;
import dev.braintrust.eval.TaskResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class RemoteEval<INPUT, OUTPUT> {
    @Nonnull
    private final String name;
    @Nonnull
    private final Task<INPUT, OUTPUT> task;
    @Nonnull
    private final List<Scorer<INPUT, OUTPUT>> scorers;
    @Nonnull
    private final Map<String, Parameter> parameters;

    @Generated
    RemoteEval(@Nonnull String name, @Nonnull Task<INPUT, OUTPUT> task, @Nonnull List<Scorer<INPUT, OUTPUT>> scorers, @Nonnull Map<String, Parameter> parameters) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (scorers == null) {
            throw new NullPointerException("scorers is marked non-null but is null");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        this.name = name;
        this.task = task;
        this.scorers = scorers;
        this.parameters = parameters;
    }

    @Generated
    public static <INPUT, OUTPUT> Builder<INPUT, OUTPUT> builder() {
        return new Builder();
    }

    @Nonnull
    @Generated
    public String getName() {
        return this.name;
    }

    @Nonnull
    @Generated
    public Task<INPUT, OUTPUT> getTask() {
        return this.task;
    }

    @Nonnull
    @Generated
    public List<Scorer<INPUT, OUTPUT>> getScorers() {
        return this.scorers;
    }

    @Nonnull
    @Generated
    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public static class Builder<INPUT, OUTPUT> {
        @Generated
        private String name;
        @Generated
        private Task<INPUT, OUTPUT> task;
        @Generated
        private ArrayList<Scorer<INPUT, OUTPUT>> scorers;
        @Generated
        private ArrayList<String> parameters$key;
        @Generated
        private ArrayList<Parameter> parameters$value;

        public Builder<INPUT, OUTPUT> taskFunction(Function<INPUT, OUTPUT> taskFn) {
            return this.task(datasetCase -> {
                Object result = taskFn.apply(datasetCase.input());
                return new TaskResult(result, datasetCase);
            });
        }

        public RemoteEval<INPUT, OUTPUT> build() {
            return this.internalBuild();
        }

        @Generated
        Builder() {
        }

        @Generated
        public Builder<INPUT, OUTPUT> name(@Nonnull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public Builder<INPUT, OUTPUT> task(@Nonnull Task<INPUT, OUTPUT> task) {
            if (task == null) {
                throw new NullPointerException("task is marked non-null but is null");
            }
            this.task = task;
            return this;
        }

        @Generated
        public Builder<INPUT, OUTPUT> scorer(Scorer<INPUT, OUTPUT> scorer) {
            if (this.scorers == null) {
                this.scorers = new ArrayList();
            }
            this.scorers.add(scorer);
            return this;
        }

        @Generated
        public Builder<INPUT, OUTPUT> scorers(Collection<? extends Scorer<INPUT, OUTPUT>> scorers) {
            if (scorers == null) {
                throw new NullPointerException("scorers cannot be null");
            }
            if (this.scorers == null) {
                this.scorers = new ArrayList();
            }
            this.scorers.addAll(scorers);
            return this;
        }

        @Generated
        public Builder<INPUT, OUTPUT> clearScorers() {
            if (this.scorers != null) {
                this.scorers.clear();
            }
            return this;
        }

        @Generated
        public Builder<INPUT, OUTPUT> parameter(String parameterKey, Parameter parameterValue) {
            if (this.parameters$key == null) {
                this.parameters$key = new ArrayList();
                this.parameters$value = new ArrayList();
            }
            this.parameters$key.add(parameterKey);
            this.parameters$value.add(parameterValue);
            return this;
        }

        @Generated
        public Builder<INPUT, OUTPUT> parameters(Map<? extends String, ? extends Parameter> parameters) {
            if (parameters == null) {
                throw new NullPointerException("parameters cannot be null");
            }
            if (this.parameters$key == null) {
                this.parameters$key = new ArrayList();
                this.parameters$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Parameter> $lombokEntry : parameters.entrySet()) {
                this.parameters$key.add($lombokEntry.getKey());
                this.parameters$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public Builder<INPUT, OUTPUT> clearParameters() {
            if (this.parameters$key != null) {
                this.parameters$key.clear();
                this.parameters$value.clear();
            }
            return this;
        }

        @Generated
        public RemoteEval<INPUT, OUTPUT> internalBuild() {
            Map<String, Parameter> parameters;
            List scorers = switch (this.scorers == null ? 0 : this.scorers.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.scorers.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Scorer<INPUT, OUTPUT>>(this.scorers));
            };
            switch (this.parameters$key == null ? 0 : this.parameters$key.size()) {
                case 0: {
                    parameters = Collections.emptyMap();
                    break;
                }
                case 1: {
                    parameters = Collections.singletonMap(this.parameters$key.get(0), this.parameters$value.get(0));
                    break;
                }
                default: {
                    parameters = new LinkedHashMap(this.parameters$key.size() < 0x40000000 ? 1 + this.parameters$key.size() + (this.parameters$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.parameters$key.size(); ++$i) {
                        parameters.put(this.parameters$key.get($i), this.parameters$value.get($i));
                    }
                    parameters = Collections.unmodifiableMap(parameters);
                }
            }
            return new RemoteEval<INPUT, OUTPUT>(this.name, this.task, scorers, parameters);
        }

        @Generated
        public String toString() {
            return "RemoteEval.Builder(name=" + this.name + ", task=" + String.valueOf(this.task) + ", scorers=" + String.valueOf(this.scorers) + ", parameters$key=" + String.valueOf(this.parameters$key) + ", parameters$value=" + String.valueOf(this.parameters$value) + ")";
        }
    }

    public static enum ParameterType {
        PROMPT("prompt"),
        DATA("data");

        private final String value;

        private ParameterType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Parameter {
        @Nonnull
        private final ParameterType type;
        @Nullable
        private final String description;
        @Nullable
        private final Object defaultValue;
        @Nullable
        private final Map<String, Object> schema;

        public static Parameter promptParameter(String description, Object defaultValue) {
            return Parameter.builder().type(ParameterType.PROMPT).description(description).defaultValue(defaultValue).build();
        }

        public static Parameter promptParameter(Object defaultValue) {
            return Parameter.promptParameter(null, defaultValue);
        }

        public static Parameter dataParameter(String description, Map<String, Object> schema, Object defaultValue) {
            return Parameter.builder().type(ParameterType.DATA).description(description).schema(schema).defaultValue(defaultValue).build();
        }

        public static Parameter dataParameter(Map<String, Object> schema, Object defaultValue) {
            return Parameter.dataParameter(null, schema, defaultValue);
        }

        public static Parameter dataParameter(Map<String, Object> schema) {
            return Parameter.dataParameter(null, schema, null);
        }

        @Generated
        Parameter(@Nonnull ParameterType type, @Nullable String description, @Nullable Object defaultValue, @Nullable Map<String, Object> schema) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            this.description = description;
            this.defaultValue = defaultValue;
            this.schema = schema;
        }

        @Generated
        public static Builder builder() {
            return new Builder();
        }

        @Nonnull
        @Generated
        public ParameterType getType() {
            return this.type;
        }

        @Nullable
        @Generated
        public String getDescription() {
            return this.description;
        }

        @Nullable
        @Generated
        public Object getDefaultValue() {
            return this.defaultValue;
        }

        @Nullable
        @Generated
        public Map<String, Object> getSchema() {
            return this.schema;
        }

        @Generated
        public static class Builder {
            @Generated
            private ParameterType type;
            @Generated
            private String description;
            @Generated
            private Object defaultValue;
            @Generated
            private Map<String, Object> schema;

            @Generated
            Builder() {
            }

            @Generated
            public Builder type(@Nonnull ParameterType type) {
                if (type == null) {
                    throw new NullPointerException("type is marked non-null but is null");
                }
                this.type = type;
                return this;
            }

            @Generated
            public Builder description(@Nullable String description) {
                this.description = description;
                return this;
            }

            @Generated
            public Builder defaultValue(@Nullable Object defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            @Generated
            public Builder schema(@Nullable Map<String, Object> schema) {
                this.schema = schema;
                return this;
            }

            @Generated
            public Parameter build() {
                return new Parameter(this.type, this.description, this.defaultValue, this.schema);
            }

            @Generated
            public String toString() {
                return "RemoteEval.Parameter.Builder(type=" + String.valueOf((Object)this.type) + ", description=" + this.description + ", defaultValue=" + String.valueOf(this.defaultValue) + ", schema=" + String.valueOf(this.schema) + ")";
            }
        }
    }
}

