/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.eval;

import dev.braintrust.api.BraintrustApiClient;
import dev.braintrust.eval.DatasetBrainstoreImpl;
import dev.braintrust.eval.DatasetCase;
import dev.braintrust.eval.DatasetInMemoryImpl;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

public interface Dataset<INPUT, OUTPUT> {
    public Cursor<DatasetCase<INPUT, OUTPUT>> openCursor();

    public String id();

    public Optional<String> version();

    default public void forEach(Consumer<DatasetCase<INPUT, OUTPUT>> consumer) {
        try (Cursor<DatasetCase<INPUT, OUTPUT>> cursor = this.openCursor();){
            Optional<DatasetCase<INPUT, OUTPUT>> cursorCase = cursor.next();
            while (cursorCase.isPresent()) {
                consumer.accept(cursorCase.get());
                cursorCase = cursor.next();
            }
        }
    }

    @SafeVarargs
    public static <INPUT, OUTPUT> Dataset<INPUT, OUTPUT> of(DatasetCase<INPUT, OUTPUT> ... cases) {
        return new DatasetInMemoryImpl<INPUT, OUTPUT>(List.of(cases));
    }

    public static <INPUT, OUTPUT> Dataset<INPUT, OUTPUT> fetchFromBraintrust(BraintrustApiClient apiClient, String projectName, String datasetName, @Nullable String datasetVersion) {
        List<BraintrustApiClient.Dataset> datasets = apiClient.queryDatasets(projectName, datasetName);
        if (datasets.isEmpty()) {
            throw new RuntimeException("Dataset not found: project=" + projectName + ", dataset=" + datasetName);
        }
        if (datasets.size() > 1) {
            throw new RuntimeException("Multiple datasets found for project=" + projectName + ", dataset=" + datasetName + ". Found " + datasets.size() + " datasets");
        }
        BraintrustApiClient.Dataset dataset = datasets.get(0);
        return new DatasetBrainstoreImpl(apiClient, dataset.id(), datasetVersion != null ? datasetVersion : dataset.updatedAt());
    }

    @NotThreadSafe
    public static interface Cursor<CASE>
    extends AutoCloseable {
        public Optional<CASE> next();

        @Override
        public void close();
    }
}

