/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.eval;

import dev.braintrust.Origin;
import dev.braintrust.api.BraintrustApiClient;
import dev.braintrust.eval.Dataset;
import dev.braintrust.eval.DatasetCase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class DatasetBrainstoreImpl<INPUT, OUTPUT>
implements Dataset<INPUT, OUTPUT> {
    private final BraintrustApiClient apiClient;
    private final String datasetId;
    @Nullable
    private final String pinnedVersion;
    private final int batchSize;

    public DatasetBrainstoreImpl(BraintrustApiClient apiClient, String datasetId, @Nullable String datasetVersion) {
        this(apiClient, datasetId, datasetVersion, 512);
    }

    DatasetBrainstoreImpl(BraintrustApiClient apiClient, String datasetId, @Nullable String datasetVersion, int batchSize) {
        this.apiClient = apiClient;
        this.datasetId = datasetId;
        this.batchSize = batchSize;
        this.pinnedVersion = datasetVersion;
    }

    @Override
    public String id() {
        return this.datasetId;
    }

    @Override
    public Optional<String> version() {
        return Optional.ofNullable(this.pinnedVersion);
    }

    @Override
    public Dataset.Cursor<DatasetCase<INPUT, OUTPUT>> openCursor() {
        return new BrainstoreCursor();
    }

    private class BrainstoreCursor
    implements Dataset.Cursor<DatasetCase<INPUT, OUTPUT>> {
        private List<Map<String, Object>> currentBatch = new ArrayList<Map<String, Object>>();
        private int currentIndex = 0;
        @Nullable
        private String cursor = null;
        private boolean exhausted = false;
        private boolean closed = false;

        BrainstoreCursor() {
        }

        @Override
        public Optional<DatasetCase<INPUT, OUTPUT>> next() {
            List<String> tags;
            if (this.closed) {
                throw new IllegalStateException("Cursor is closed");
            }
            if (this.currentIndex >= this.currentBatch.size() && !this.exhausted) {
                this.fetchNextBatch();
            }
            if (this.currentIndex >= this.currentBatch.size()) {
                return Optional.empty();
            }
            Map<String, Object> event = this.currentBatch.get(this.currentIndex++);
            Object input = event.get("input");
            Object expected = event.get("expected");
            Map<String, Object> metadata = (Map<String, Object>)event.get("metadata");
            if (metadata == null) {
                metadata = Map.of();
            }
            if ((tags = (List<String>)event.get("tags")) == null) {
                tags = List.of();
            }
            DatasetCase<Object, Object> datasetCase = new DatasetCase<Object, Object>(input, expected, tags, metadata, Optional.of(new Origin("dataset", Objects.requireNonNull((String)event.get("dataset_id")), Objects.requireNonNull((String)event.get("id")), Objects.requireNonNull((String)event.get("_xact_id")), Objects.requireNonNull((String)event.get("created")))));
            return Optional.of(datasetCase);
        }

        private void fetchNextBatch() {
            BraintrustApiClient.DatasetFetchRequest request = new BraintrustApiClient.DatasetFetchRequest(DatasetBrainstoreImpl.this.batchSize, this.cursor, DatasetBrainstoreImpl.this.pinnedVersion);
            BraintrustApiClient.DatasetFetchResponse response = DatasetBrainstoreImpl.this.apiClient.fetchDatasetEvents(DatasetBrainstoreImpl.this.datasetId, request);
            this.currentBatch = new ArrayList<Map<String, Object>>(response.events());
            this.currentIndex = 0;
            this.cursor = response.cursor();
            if (this.cursor == null || this.cursor.isEmpty() || response.events().isEmpty()) {
                this.exhausted = true;
            }
        }

        @Override
        public void close() {
            this.closed = true;
            this.currentBatch.clear();
        }
    }
}

