/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.eval;

import dev.braintrust.eval.Dataset;
import dev.braintrust.eval.DatasetCase;
import java.util.List;
import java.util.Optional;

class DatasetInMemoryImpl<INPUT, OUTPUT>
implements Dataset<INPUT, OUTPUT> {
    private final List<DatasetCase<INPUT, OUTPUT>> cases;
    private final String id;

    DatasetInMemoryImpl(List<DatasetCase<INPUT, OUTPUT>> cases) {
        this.cases = List.copyOf(cases);
        this.id = "in-memory-dataset<" + this.cases.hashCode() + ">";
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Optional<String> version() {
        return Optional.empty();
    }

    @Override
    public Dataset.Cursor<DatasetCase<INPUT, OUTPUT>> openCursor() {
        return new Dataset.Cursor<DatasetCase<INPUT, OUTPUT>>(){
            int nextIndex = 0;
            boolean closed = false;

            @Override
            public Optional<DatasetCase<INPUT, OUTPUT>> next() {
                if (this.closed) {
                    throw new IllegalStateException("this method may not be invoked after close");
                }
                if (this.nextIndex < DatasetInMemoryImpl.this.cases.size()) {
                    return Optional.of(DatasetInMemoryImpl.this.cases.get(this.nextIndex++));
                }
                return Optional.empty();
            }

            @Override
            public void close() {
                this.closed = true;
            }
        };
    }
}

