/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.eval;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.braintrust.BraintrustUtils;
import dev.braintrust.api.BraintrustApiClient;
import dev.braintrust.config.BraintrustConfig;
import dev.braintrust.eval.Dataset;
import dev.braintrust.eval.DatasetCase;
import dev.braintrust.eval.EvalCase;
import dev.braintrust.eval.EvalResult;
import dev.braintrust.eval.Score;
import dev.braintrust.eval.Scorer;
import dev.braintrust.eval.Task;
import dev.braintrust.eval.TaskResult;
import dev.braintrust.trace.BraintrustContext;
import dev.braintrust.trace.BraintrustTracing;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Eval<INPUT, OUTPUT> {
    private static final AttributeKey<String> PARENT = AttributeKey.stringKey((String)"braintrust.parent");
    static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    @Nonnull
    private final String experimentName;
    @Nonnull
    private final BraintrustConfig config;
    @Nonnull
    private final BraintrustApiClient client;
    @Nonnull
    private final BraintrustApiClient.OrganizationAndProjectInfo orgAndProject;
    @Nonnull
    private final Tracer tracer;
    @Nonnull
    private final Dataset<INPUT, OUTPUT> dataset;
    @Nonnull
    private final Task<INPUT, OUTPUT> task;
    @Nonnull
    private final List<Scorer<INPUT, OUTPUT>> scorers;

    private Eval(Builder<INPUT, OUTPUT> builder) {
        this.experimentName = builder.experimentName;
        this.config = Objects.requireNonNull(builder.config);
        this.client = Objects.requireNonNull(builder.apiClient);
        this.orgAndProject = null == builder.projectId ? this.client.getProjectAndOrgInfo().orElseThrow() : this.client.getProjectAndOrgInfo(builder.projectId).orElseThrow(() -> new RuntimeException("invalid project id: " + builder.projectId));
        this.tracer = Objects.requireNonNull(builder.tracer);
        this.dataset = builder.dataset;
        this.task = Objects.requireNonNull(builder.task);
        this.scorers = List.copyOf(builder.scorers);
    }

    public EvalResult run() {
        BraintrustApiClient.Experiment experiment = this.client.getOrCreateExperiment(new BraintrustApiClient.CreateExperimentRequest(this.orgAndProject.project().id(), this.experimentName, Optional.empty(), Optional.empty()));
        this.dataset.forEach(datasetCase -> this.evalOne(experiment.id(), (DatasetCase<INPUT, OUTPUT>)datasetCase));
        String experimentUrl = "%s/experiments/%s".formatted(BraintrustUtils.createProjectURI(this.config.appUrl(), this.orgAndProject).toASCIIString(), this.experimentName);
        return new EvalResult(experimentUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evalOne(String experimentId, DatasetCase<INPUT, OUTPUT> datasetCase) {
        Span rootSpan = this.tracer.spanBuilder("eval").setNoParent().setSpanKind(SpanKind.CLIENT).setAttribute(PARENT, (Object)("experiment_id:" + experimentId)).setAttribute("braintrust.span_attributes", this.json(Map.of("type", "eval"))).setAttribute("braintrust.input_json", this.json(Map.of("input", datasetCase.input()))).setAttribute("braintrust.expected", this.json(datasetCase.expected())).startSpan();
        if (datasetCase.origin().isPresent()) {
            rootSpan.setAttribute("braintrust.origin", this.json(datasetCase.origin().get()));
        }
        if (!datasetCase.tags().isEmpty()) {
            rootSpan.setAttribute(AttributeKey.stringArrayKey((String)"braintrust.tags"), datasetCase.tags());
        }
        try (Scope rootScope = BraintrustContext.ofExperiment(experimentId, rootSpan).makeCurrent();){
            TaskResult taskResult;
            Scope unused;
            Span taskSpan = this.tracer.spanBuilder("task").setAttribute(PARENT, (Object)("experiment_id:" + experimentId)).setAttribute("braintrust.span_attributes", this.json(Map.of("type", "task"))).startSpan();
            try {
                unused = BraintrustContext.ofExperiment(experimentId, taskSpan).makeCurrent();
                try {
                    taskResult = this.task.apply(datasetCase);
                }
                finally {
                    if (unused != null) {
                        unused.close();
                    }
                }
            }
            finally {
                taskSpan.end();
            }
            try {
                rootSpan.setAttribute("braintrust.output_json", JSON_MAPPER.writeValueAsString(Map.of("output", taskResult.result())));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            Span scoreSpan = this.tracer.spanBuilder("score").setAttribute(PARENT, (Object)("experiment_id:" + experimentId)).setAttribute("braintrust.span_attributes", this.json(Map.of("type", "score"))).startSpan();
            try {
                unused = BraintrustContext.ofExperiment(experimentId, scoreSpan).makeCurrent();
                try {
                    LinkedHashMap nameToScore = new LinkedHashMap();
                    this.scorers.forEach(scorer -> {
                        List<Score> scores = scorer.score(taskResult);
                        scores.forEach(score -> {
                            if (score.value() < 0.0 || score.value() > 1.0) {
                                throw new RuntimeException("score must be between 0 and 1: %s : %s".formatted(scorer.getName(), score));
                            }
                            nameToScore.put(score.name(), score.value());
                        });
                    });
                    scoreSpan.setAttribute("braintrust.scores", this.json(nameToScore));
                }
                finally {
                    if (unused != null) {
                        unused.close();
                    }
                }
            }
            finally {
                scoreSpan.end();
            }
        }
        finally {
            rootSpan.end();
        }
    }

    private String json(Object o) {
        return JSON_MAPPER.writeValueAsString(o);
    }

    public static <INPUT, OUTPUT> Builder<INPUT, OUTPUT> builder() {
        return new Builder();
    }

    public static final class Builder<INPUT, OUTPUT> {
        @Nonnull
        public Dataset<INPUT, OUTPUT> dataset;
        @Nonnull
        private String experimentName = "unnamed-java-eval";
        @Nullable
        private BraintrustConfig config;
        @Nullable
        private BraintrustApiClient apiClient;
        @Nullable
        private String projectId;
        @Nullable
        private Tracer tracer = null;
        @Nullable
        private Task<INPUT, OUTPUT> task;
        @Nonnull
        private List<Scorer<INPUT, OUTPUT>> scorers = List.of();

        public Eval<INPUT, OUTPUT> build() {
            if (this.config == null) {
                this.config = BraintrustConfig.fromEnvironment();
            }
            if (this.tracer == null) {
                this.tracer = BraintrustTracing.getTracer();
            }
            if (this.projectId == null) {
                this.projectId = this.config.defaultProjectId().orElse(null);
            }
            if (this.scorers.isEmpty()) {
                throw new RuntimeException("must provide at least one scorer");
            }
            if (null == this.apiClient) {
                this.apiClient = BraintrustApiClient.of(this.config);
            }
            Objects.requireNonNull(this.dataset);
            Objects.requireNonNull(this.task);
            return new Eval(this);
        }

        public Builder<INPUT, OUTPUT> name(@Nonnull String name) {
            this.experimentName = Objects.requireNonNull(name);
            return this;
        }

        public Builder<INPUT, OUTPUT> projectId(@Nonnull String projectId) {
            this.projectId = Objects.requireNonNull(projectId);
            return this;
        }

        public Builder<INPUT, OUTPUT> config(BraintrustConfig config) {
            this.config = config;
            return this;
        }

        public Builder<INPUT, OUTPUT> apiClient(BraintrustApiClient apiClient) {
            this.apiClient = apiClient;
            return this;
        }

        public Builder<INPUT, OUTPUT> tracer(Tracer tracer) {
            this.tracer = tracer;
            return this;
        }

        public Builder<INPUT, OUTPUT> dataset(Dataset<INPUT, OUTPUT> dataset) {
            this.dataset = dataset;
            return this;
        }

        @Deprecated
        @SafeVarargs
        public final Builder<INPUT, OUTPUT> cases(EvalCase<INPUT, OUTPUT> ... cases) {
            return this.cases(Arrays.stream(cases).map(evalCase -> DatasetCase.of(evalCase.input(), evalCase.expected())).toList().toArray(new DatasetCase[0]));
        }

        @SafeVarargs
        public final Builder<INPUT, OUTPUT> cases(DatasetCase<INPUT, OUTPUT> ... cases) {
            if (cases.length == 0) {
                throw new RuntimeException("must provide at least one case");
            }
            return this.dataset(Dataset.of(cases));
        }

        public Builder<INPUT, OUTPUT> task(Task<INPUT, OUTPUT> task) {
            this.task = task;
            return this;
        }

        public Builder<INPUT, OUTPUT> taskFunction(final Function<INPUT, OUTPUT> taskFn) {
            return this.task(new Task<INPUT, OUTPUT>(){

                @Override
                public TaskResult<INPUT, OUTPUT> apply(DatasetCase<INPUT, OUTPUT> datasetCase) {
                    Object result = taskFn.apply(datasetCase.input());
                    return new TaskResult(result, datasetCase);
                }
            });
        }

        @SafeVarargs
        public final Builder<INPUT, OUTPUT> scorers(Scorer<INPUT, OUTPUT> ... scorers) {
            this.scorers = List.of(scorers);
            return this;
        }
    }
}

