/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.eval;

import dev.braintrust.eval.Score;
import dev.braintrust.eval.TaskResult;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface Scorer<INPUT, OUTPUT> {
    public String getName();

    public List<Score> score(TaskResult<INPUT, OUTPUT> var1);

    public static <INPUT, OUTPUT> Scorer<INPUT, OUTPUT> of(final String scorerName, final Function<TaskResult<INPUT, OUTPUT>, Double> scorerFn) {
        return new Scorer<INPUT, OUTPUT>(){

            @Override
            public String getName() {
                return scorerName;
            }

            @Override
            public List<Score> score(TaskResult<INPUT, OUTPUT> taskResult) {
                return List.of(new Score(scorerName, (Double)scorerFn.apply(taskResult)));
            }
        };
    }

    public static <INPUT, OUTPUT> Scorer<INPUT, OUTPUT> of(final String scorerName, final BiFunction<OUTPUT, OUTPUT, Double> scorerFn) {
        return new Scorer<INPUT, OUTPUT>(){

            @Override
            public String getName() {
                return scorerName;
            }

            @Override
            public List<Score> score(TaskResult<INPUT, OUTPUT> taskResult) {
                return List.of(new Score(scorerName, (Double)scorerFn.apply(taskResult.datasetCase().expected(), taskResult.result())));
            }
        };
    }
}

