/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.anthropic.otel;

import com.anthropic.client.AnthropicClient;
import com.anthropic.models.messages.Message;
import com.anthropic.models.messages.MessageCreateParams;
import dev.braintrust.instrumentation.anthropic.otel.AnthropicTelemetryBuilder;
import dev.braintrust.instrumentation.anthropic.otel.InstrumentedAnthropicClient;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;

public final class AnthropicTelemetry {
    private final Instrumenter<MessageCreateParams, Message> messageInstrumenter;
    private final boolean captureMessageContent;

    public static AnthropicTelemetry create(OpenTelemetry openTelemetry) {
        return AnthropicTelemetry.builder(openTelemetry).build();
    }

    public static AnthropicTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new AnthropicTelemetryBuilder(openTelemetry);
    }

    AnthropicTelemetry(Instrumenter<MessageCreateParams, Message> messageInstrumenter, boolean captureMessageContent) {
        this.messageInstrumenter = messageInstrumenter;
        this.captureMessageContent = captureMessageContent;
    }

    public AnthropicClient wrap(AnthropicClient client) {
        return (AnthropicClient)new InstrumentedAnthropicClient(client, this.messageInstrumenter, this.captureMessageContent).createProxy();
    }
}

