/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.anthropic.otel;

import com.anthropic.models.messages.Message;
import com.anthropic.models.messages.MessageCreateParams;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.braintrust.instrumentation.anthropic.otel.AnthropicTelemetry;
import dev.braintrust.instrumentation.anthropic.otel.MessageAttributesGetter;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.incubator.semconv.genai.GenAiAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.genai.GenAiAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.genai.GenAiClientMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;

public final class AnthropicTelemetryBuilder {
    static final String INSTRUMENTATION_NAME = "io.opentelemetry.anthropic-java-2.8";
    private final OpenTelemetry openTelemetry;
    private boolean captureMessageContent;

    AnthropicTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public AnthropicTelemetryBuilder setCaptureMessageContent(boolean captureMessageContent) {
        this.captureMessageContent = captureMessageContent;
        return this;
    }

    public AnthropicTelemetry build() {
        Instrumenter messageInstrumenter = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, request -> MessageAttributesGetter.INSTANCE.getOperationName((MessageCreateParams)request)).addAttributesExtractor(GenAiAttributesExtractor.create((GenAiAttributesGetter)MessageAttributesGetter.INSTANCE)).addOperationMetrics(GenAiClientMetrics.get()).buildInstrumenter(SpanKindExtractor.alwaysClient());
        return new AnthropicTelemetry((Instrumenter<MessageCreateParams, Message>)messageInstrumenter, this.captureMessageContent);
    }
}

