/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.anthropic.otel;

import com.anthropic.models.messages.Message;
import com.anthropic.models.messages.MessageParam;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.opentelemetry.api.trace.Span;
import java.util.List;

final class BraintrustAnthropicSpanAttributes {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    static final String OPERATION_CHAT = "chat";
    static final String SYSTEM_ANTHROPIC = "anthropic";

    private BraintrustAnthropicSpanAttributes() {
    }

    public static void setInputMessages(Span span, List<MessageParam> messages) {
        span.setAttribute("braintrust.input_json", JSON_MAPPER.writeValueAsString(messages));
    }

    public static void setOutputMessage(Span span, Message message) {
        span.setAttribute("braintrust.output_json", JSON_MAPPER.writeValueAsString((Object)message));
    }

    public static void setOutputJson(Span span, String outputJson) {
        span.setAttribute("braintrust.output_json", outputJson);
    }
}

