/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.anthropic.otel;

import com.anthropic.core.RequestOptions;
import com.anthropic.core.http.StreamResponse;
import com.anthropic.models.messages.Message;
import com.anthropic.models.messages.MessageCreateParams;
import com.anthropic.models.messages.MessageParam;
import com.anthropic.models.messages.RawMessageStreamEvent;
import com.anthropic.models.messages.TextBlockParam;
import com.anthropic.services.blocking.MessageService;
import dev.braintrust.instrumentation.anthropic.otel.BraintrustAnthropicSpanAttributes;
import dev.braintrust.instrumentation.anthropic.otel.DelegatingInvocationHandler;
import dev.braintrust.instrumentation.anthropic.otel.StreamListener;
import dev.braintrust.instrumentation.anthropic.otel.TracingStreamedResponse;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.stream.Collectors;

final class InstrumentedMessageService
extends DelegatingInvocationHandler<MessageService, InstrumentedMessageService> {
    private final Instrumenter<MessageCreateParams, Message> instrumenter;
    private final boolean captureMessageContent;

    InstrumentedMessageService(MessageService delegate, Instrumenter<MessageCreateParams, Message> instrumenter, boolean captureMessageContent) {
        super(delegate);
        this.instrumenter = instrumenter;
        this.captureMessageContent = captureMessageContent;
    }

    @Override
    protected Class<MessageService> getProxyType() {
        return MessageService.class;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        switch (methodName) {
            case "create": {
                if (parameterTypes.length < 1 || parameterTypes[0] != MessageCreateParams.class) break;
                if (parameterTypes.length == 1) {
                    return this.create((MessageCreateParams)args[0], RequestOptions.none());
                }
                if (parameterTypes.length != 2 || parameterTypes[1] != RequestOptions.class) break;
                return this.create((MessageCreateParams)args[0], (RequestOptions)args[1]);
            }
            case "createStreaming": {
                if (parameterTypes.length < 1 || parameterTypes[0] != MessageCreateParams.class) break;
                if (parameterTypes.length == 1) {
                    return this.createStreaming((MessageCreateParams)args[0], RequestOptions.none());
                }
                if (parameterTypes.length != 2 || parameterTypes[1] != RequestOptions.class) break;
                return this.createStreaming((MessageCreateParams)args[0], (RequestOptions)args[1]);
            }
        }
        return super.invoke(proxy, method, args);
    }

    private Message create(MessageCreateParams inputMessage, RequestOptions requestOptions) {
        Message outputMessage;
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, (Object)inputMessage)) {
            return ((MessageService)this.delegate).create(inputMessage, requestOptions);
        }
        Context context = this.instrumenter.start(parentContext, (Object)inputMessage);
        long startTimeNanos = System.nanoTime();
        try (Scope ignored = context.makeCurrent();){
            Span currentSpan = Span.current();
            currentSpan.setAttribute("provider", "anthropic");
            ArrayList<MessageParam> inputMessages = new ArrayList<MessageParam>(inputMessage.messages());
            if (inputMessage.system().isPresent()) {
                inputMessages.add(MessageParam.builder().role(MessageParam.Role.of((String)"system")).content(((MessageCreateParams.System)inputMessage.system().get()).asString()).build());
            }
            BraintrustAnthropicSpanAttributes.setInputMessages(currentSpan, inputMessages);
            outputMessage = ((MessageService)this.delegate).create(inputMessage, requestOptions);
            long endTimeNanos = System.nanoTime();
            double timeToFirstTokenSeconds = (double)(endTimeNanos - startTimeNanos) / 1.0E9;
            currentSpan.setAttribute("braintrust.metrics.time_to_first_token", timeToFirstTokenSeconds);
            BraintrustAnthropicSpanAttributes.setOutputMessage(Span.current(), outputMessage);
        }
        catch (Throwable t) {
            this.instrumenter.end(context, (Object)inputMessage, null, t);
            throw t;
        }
        this.instrumenter.end(context, (Object)inputMessage, (Object)outputMessage, null);
        return outputMessage;
    }

    private StreamResponse<RawMessageStreamEvent> createStreaming(MessageCreateParams inputMessage, RequestOptions requestOptions) {
        StreamResponse<RawMessageStreamEvent> streamResponse;
        block9: {
            Context parentContext = Context.current();
            if (!this.instrumenter.shouldStart(parentContext, (Object)inputMessage)) {
                return this.createStreamingWithAttributes(parentContext, inputMessage, requestOptions, false);
            }
            Context context = this.instrumenter.start(parentContext, (Object)inputMessage);
            Scope ignored = context.makeCurrent();
            try {
                streamResponse = this.createStreamingWithAttributes(context, inputMessage, requestOptions, true);
                if (ignored == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    this.instrumenter.end(context, (Object)inputMessage, null, t);
                    throw t;
                }
            }
            ignored.close();
        }
        return streamResponse;
    }

    private StreamResponse<RawMessageStreamEvent> createStreamingWithAttributes(Context context, MessageCreateParams inputMessage, RequestOptions requestOptions, boolean newSpan) {
        Span span = Span.fromContext((Context)context);
        span.setAttribute("provider", "anthropic");
        ArrayList<MessageParam> inputMessages = new ArrayList<MessageParam>(inputMessage.messages());
        if (inputMessage.system().isPresent()) {
            inputMessages.add(MessageParam.builder().role(MessageParam.Role.of((String)"system")).content(((MessageCreateParams.System)inputMessage.system().get()).asString()).build());
        }
        BraintrustAnthropicSpanAttributes.setInputMessages(span, inputMessages);
        long startTimeNanos = System.nanoTime();
        StreamResponse result = ((MessageService)this.delegate).createStreaming(inputMessage, requestOptions);
        return new TracingStreamedResponse((StreamResponse<RawMessageStreamEvent>)result, new StreamListener(context, inputMessage, this.instrumenter, this.captureMessageContent, newSpan, startTimeNanos));
    }

    private static String contentToString(MessageCreateParams.System content) {
        if (content.isString()) {
            return content.asString();
        }
        if (content.isTextBlockParams()) {
            return content.asTextBlockParams().stream().map(TextBlockParam::text).collect(Collectors.joining());
        }
        return "";
    }
}

