/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.anthropic.otel;

import com.anthropic.models.messages.Message;
import com.anthropic.models.messages.MessageCreateParams;
import io.opentelemetry.instrumentation.api.incubator.semconv.genai.GenAiAttributesGetter;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

enum MessageAttributesGetter implements GenAiAttributesGetter<MessageCreateParams, Message>
{
    INSTANCE;


    public String getOperationName(MessageCreateParams request) {
        return "anthropic.messages.create";
    }

    public String getSystem(MessageCreateParams request) {
        return "anthropic";
    }

    public String getRequestModel(MessageCreateParams request) {
        return request.model().asString();
    }

    @Nullable
    public Long getRequestSeed(MessageCreateParams request) {
        return null;
    }

    @Nullable
    public List<String> getRequestEncodingFormats(MessageCreateParams request) {
        return null;
    }

    @Nullable
    public Double getRequestFrequencyPenalty(MessageCreateParams request) {
        return null;
    }

    @Nullable
    public Long getRequestMaxTokens(MessageCreateParams request) {
        long maxTokens = request.maxTokens();
        return maxTokens > 0L ? Long.valueOf(maxTokens) : null;
    }

    @Nullable
    public Double getRequestPresencePenalty(MessageCreateParams request) {
        return null;
    }

    @Nullable
    public List<String> getRequestStopSequences(MessageCreateParams request) {
        return request.stopSequences().orElse(null);
    }

    @Nullable
    public Double getRequestTemperature(MessageCreateParams request) {
        return request.temperature().orElse(null);
    }

    @Nullable
    public Double getRequestTopK(MessageCreateParams request) {
        return request.topK().map(Long::doubleValue).orElse(null);
    }

    @Nullable
    public Double getRequestTopP(MessageCreateParams request) {
        return request.topP().orElse(null);
    }

    public List<String> getResponseFinishReasons(MessageCreateParams request, @Nullable Message response) {
        if (response == null) {
            return Collections.emptyList();
        }
        return response.stopReason().map(reason -> List.of(reason.asString())).orElse(Collections.emptyList());
    }

    @Nullable
    public String getResponseId(MessageCreateParams request, @Nullable Message response) {
        if (response == null) {
            return null;
        }
        return response.id();
    }

    @Nullable
    public String getResponseModel(MessageCreateParams request, @Nullable Message response) {
        if (response == null) {
            return null;
        }
        return response.model().asString();
    }

    @Nullable
    public Long getUsageInputTokens(MessageCreateParams request, @Nullable Message response) {
        if (response == null) {
            return null;
        }
        return response.usage().inputTokens();
    }

    @Nullable
    public Long getUsageOutputTokens(MessageCreateParams request, @Nullable Message response) {
        if (response == null) {
            return null;
        }
        return response.usage().outputTokens();
    }
}

