/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.anthropic.otel;

import com.anthropic.models.messages.Message;
import com.anthropic.models.messages.MessageCreateParams;
import com.anthropic.models.messages.MessageDeltaUsage;
import com.anthropic.models.messages.Model;
import com.anthropic.models.messages.RawContentBlockDeltaEvent;
import com.anthropic.models.messages.RawMessageDeltaEvent;
import com.anthropic.models.messages.RawMessageStartEvent;
import com.anthropic.models.messages.RawMessageStreamEvent;
import com.anthropic.models.messages.StopReason;
import com.anthropic.models.messages.TextDelta;
import com.anthropic.models.messages.Usage;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import dev.braintrust.instrumentation.anthropic.otel.BraintrustAnthropicSpanAttributes;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

final class StreamListener {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private final Context context;
    private final MessageCreateParams request;
    private final Instrumenter<MessageCreateParams, Message> instrumenter;
    private final boolean captureMessageContent;
    private final boolean newSpan;
    private final AtomicBoolean hasEnded;
    private final long startTimeNanos;
    private final StringBuilder contentBuilder = new StringBuilder();
    @Nullable
    private Usage usage;
    @Nullable
    private MessageDeltaUsage deltaUsage;
    @Nullable
    private Model model;
    @Nullable
    private String responseId;
    @Nullable
    private String stopReason;
    @Nullable
    private Double timeToFirstToken;

    StreamListener(Context context, MessageCreateParams request, Instrumenter<MessageCreateParams, Message> instrumenter, boolean captureMessageContent, boolean newSpan, long startTimeNanos) {
        this.context = context;
        this.request = request;
        this.instrumenter = instrumenter;
        this.captureMessageContent = captureMessageContent;
        this.newSpan = newSpan;
        this.startTimeNanos = startTimeNanos;
        this.hasEnded = new AtomicBoolean();
    }

    void onEvent(RawMessageStreamEvent event) {
        RawContentBlockDeltaEvent delta;
        if (this.timeToFirstToken == null) {
            long firstEventTimeNanos = System.nanoTime();
            this.timeToFirstToken = (double)(firstEventTimeNanos - this.startTimeNanos) / 1.0E9;
        }
        if (event.messageStart().isPresent()) {
            RawMessageStartEvent messageStart = (RawMessageStartEvent)event.messageStart().get();
            this.model = messageStart.message().model();
            this.responseId = messageStart.message().id();
            if (messageStart.message().usage() != null) {
                this.usage = messageStart.message().usage();
            }
        }
        if (event.contentBlockDelta().isPresent() && (delta = (RawContentBlockDeltaEvent)event.contentBlockDelta().get()).delta().text().isPresent()) {
            this.contentBuilder.append(((TextDelta)delta.delta().text().get()).text());
        }
        if (event.messageDelta().isPresent()) {
            RawMessageDeltaEvent messageDelta = (RawMessageDeltaEvent)event.messageDelta().get();
            if (messageDelta.delta().stopReason().isPresent()) {
                this.stopReason = ((StopReason)messageDelta.delta().stopReason().get()).toString();
            }
            if (messageDelta.usage() != null) {
                this.deltaUsage = messageDelta.usage();
            }
        }
        if (event.contentBlockStop().isPresent()) {
            ArrayNode outputArray = JSON_MAPPER.createArrayNode();
            ObjectNode message = JSON_MAPPER.createObjectNode();
            message.put("role", "assistant");
            message.put("content", this.contentBuilder.toString());
            outputArray.add((JsonNode)message);
            BraintrustAnthropicSpanAttributes.setOutputJson(Span.fromContext((Context)this.context), JSON_MAPPER.writeValueAsString((Object)outputArray));
        }
    }

    void endSpan(@Nullable Throwable error) {
        if (!this.hasEnded.compareAndSet(false, true)) {
            return;
        }
        if (!this.newSpan) {
            return;
        }
        if (this.model == null || this.responseId == null) {
            this.instrumenter.end(this.context, (Object)this.request, null, error);
            return;
        }
        Span span = Span.fromContext((Context)this.context);
        if (this.model != null) {
            span.setAttribute("gen_ai.response.model", this.model.asString());
        }
        if (this.responseId != null) {
            span.setAttribute("gen_ai.response.id", this.responseId);
        }
        if (this.stopReason != null) {
            span.setAttribute(AttributeKey.stringArrayKey((String)"gen_ai.response.finish_reasons"), Arrays.asList(this.stopReason));
        }
        if (this.usage != null) {
            span.setAttribute("gen_ai.usage.input_tokens", this.usage.inputTokens());
        }
        if (this.deltaUsage != null) {
            this.deltaUsage.inputTokens().ifPresent(tokens -> span.setAttribute("gen_ai.usage.input_tokens", tokens.longValue()));
            span.setAttribute("gen_ai.usage.output_tokens", this.deltaUsage.outputTokens());
        } else if (this.usage != null) {
            span.setAttribute("gen_ai.usage.output_tokens", this.usage.outputTokens());
        }
        if (this.timeToFirstToken != null) {
            span.setAttribute("braintrust.metrics.time_to_first_token", this.timeToFirstToken.doubleValue());
        }
        this.instrumenter.end(this.context, (Object)this.request, null, error);
    }
}

