/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.anthropic.otel;

import com.anthropic.core.http.StreamResponse;
import com.anthropic.models.messages.RawMessageStreamEvent;
import dev.braintrust.instrumentation.anthropic.otel.StreamListener;
import java.util.Comparator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

final class TracingStreamedResponse
implements StreamResponse<RawMessageStreamEvent> {
    private final StreamResponse<RawMessageStreamEvent> delegate;
    private final StreamListener listener;

    TracingStreamedResponse(StreamResponse<RawMessageStreamEvent> delegate, StreamListener listener) {
        this.delegate = delegate;
        this.listener = listener;
    }

    public Stream<RawMessageStreamEvent> stream() {
        return StreamSupport.stream(new TracingSpliterator(this.delegate.stream().spliterator()), false);
    }

    public void close() {
        this.listener.endSpan(null);
        this.delegate.close();
    }

    private class TracingSpliterator
    implements Spliterator<RawMessageStreamEvent> {
        private final Spliterator<RawMessageStreamEvent> delegateSpliterator;

        private TracingSpliterator(Spliterator<RawMessageStreamEvent> delegateSpliterator) {
            this.delegateSpliterator = delegateSpliterator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super RawMessageStreamEvent> action) {
            boolean eventReceived = this.delegateSpliterator.tryAdvance((? super T event) -> {
                TracingStreamedResponse.this.listener.onEvent((RawMessageStreamEvent)event);
                action.accept((RawMessageStreamEvent)event);
            });
            if (!eventReceived) {
                TracingStreamedResponse.this.listener.endSpan(null);
            }
            return eventReceived;
        }

        @Override
        @Nullable
        public Spliterator<RawMessageStreamEvent> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return this.delegateSpliterator.estimateSize();
        }

        @Override
        public long getExactSizeIfKnown() {
            return this.delegateSpliterator.getExactSizeIfKnown();
        }

        @Override
        public int characteristics() {
            return this.delegateSpliterator.characteristics();
        }

        @Override
        public Comparator<? super RawMessageStreamEvent> getComparator() {
            return this.delegateSpliterator.getComparator();
        }
    }
}

